/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.cnd.debugger.gdb.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.openide.util.Utilities;

public class BreakpointAnnotationListener
extends DebuggerManagerAdapter {
    private HashMap<GdbBreakpoint, Object> breakpointToAnnotation = new HashMap();
    private boolean listen = true;

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.listen) {
            String string = propertyChangeEvent.getPropertyName();
            if (!(string != null && propertyChangeEvent.getSource() != null && propertyChangeEvent.getSource() instanceof GdbBreakpoint && (string.equals("condition") || string.equals("url") || string.equals("lineNumber") || string.equals("enabled") || string.equals("refresh")))) {
                return;
            }
            if (propertyChangeEvent.getSource() instanceof GdbBreakpoint) {
                this.annotate((GdbBreakpoint)((Object)propertyChangeEvent.getSource()));
            }
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        if (breakpoint instanceof GdbBreakpoint) {
            this.annotate((GdbBreakpoint)breakpoint);
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        this.removeAnnotation(breakpoint);
    }

    public GdbBreakpoint findBreakpoint(String string, int n) {
        for (GdbBreakpoint gdbBreakpoint : this.breakpointToAnnotation.keySet()) {
            int n2;
            Object object;
            int n3;
            Object object2;
            Object object3;
            if (gdbBreakpoint instanceof LineBreakpoint) {
                object3 = (LineBreakpoint)gdbBreakpoint;
                if (!object3.getURL().equals(string)) continue;
                object2 = this.breakpointToAnnotation.get(object3);
                n3 = EditorContextBridge.getContext().getLineNumber(object2, null);
                if (n3 == n) {
                    return object3;
                }
            }
            if (gdbBreakpoint instanceof FunctionBreakpoint) {
                object3 = (FunctionBreakpoint)gdbBreakpoint;
                if (Utilities.isWindows()) {
                    boolean bl = false;
                    if (object3.getURL().equals(string)) {
                        bl = true;
                    } else {
                        String string2 = object3.getURL();
                        if (string2.startsWith("file:/") && string.startsWith("file:/") && string2.charAt(7) == ':' && string.charAt(7) == ':') {
                            String string3 = string.substring(0, 8);
                            string3 = string3.toLowerCase() + string.substring(8);
                            String string4 = string2.substring(0, 8);
                            if ((string4 = string4.toLowerCase() + string2.substring(8)).equals(string3)) {
                                bl = true;
                            }
                        }
                    }
                    if (!bl) {
                        continue;
                    }
                } else if (!object3.getURL().equals(string)) continue;
                object2 = this.breakpointToAnnotation.get(object3);
                n3 = EditorContextBridge.getContext().getLineNumber(object2, null);
                if (n3 == n) {
                    return object3;
                }
            }
            if (!(gdbBreakpoint instanceof AddressBreakpoint) || (object3 = Disassembly.getCurrent()) == null || ((Disassembly)object3).getAddressLine(((AddressBreakpoint)(object2 = (AddressBreakpoint)gdbBreakpoint)).getAddress()) == -1 || (object = this.breakpointToAnnotation.get(object2)) == null || (n2 = EditorContextBridge.getContext().getLineNumber(object, null)) != n) continue;
            return object2;
        }
        return null;
    }

    private void annotate(GdbBreakpoint gdbBreakpoint) {
        Object object = this.breakpointToAnnotation.get((Object)gdbBreakpoint);
        if (object != null) {
            EditorContextBridge.getContext().removeAnnotation(object);
        }
        if (gdbBreakpoint.isHidden()) {
            return;
        }
        int n = gdbBreakpoint.getLineNumber();
        if (n < 1) {
            return;
        }
        object = EditorContextBridge.annotate(gdbBreakpoint);
        if (object == null && !(gdbBreakpoint instanceof AddressBreakpoint)) {
            return;
        }
        this.breakpointToAnnotation.put(gdbBreakpoint, object);
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Object object2 = null;
        if (debuggerEngine != null) {
            object2 = debuggerEngine.lookupFirst(null, GdbDebugger.class);
        }
        this.update(gdbBreakpoint, object2);
    }

    public void updateBreakpoints() {
        for (GdbBreakpoint gdbBreakpoint : this.breakpointToAnnotation.keySet()) {
            this.update(gdbBreakpoint, null);
        }
    }

    private void update(GdbBreakpoint gdbBreakpoint, Object object) {
        Object object2 = this.breakpointToAnnotation.get((Object)gdbBreakpoint);
        if (gdbBreakpoint instanceof AddressBreakpoint) {
            this.listen = false;
            object2 = EditorContextBridge.annotate(gdbBreakpoint);
            this.breakpointToAnnotation.put(gdbBreakpoint, object2);
            this.listen = true;
        }
        if (object2 != null) {
            int n = EditorContextBridge.getContext().getLineNumber(object2, object);
            this.listen = false;
            gdbBreakpoint.setLineNumber(n);
            this.listen = true;
        }
    }

    private void removeAnnotation(Breakpoint breakpoint) {
        Object object = this.breakpointToAnnotation.remove(breakpoint);
        if (object != null) {
            EditorContextBridge.getContext().removeAnnotation(object);
        }
    }
}

