/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.gdb.Field;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.GdbErrorException;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb.InvalidExpressionException;
import org.netbeans.modules.cnd.debugger.gdb.LocalVariable;
import org.netbeans.modules.cnd.debugger.gdb.TypeInfo;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractVariable
implements LocalVariable,
Customizer,
PropertyChangeListener {
    private GdbDebugger debugger;
    protected String name;
    protected String type;
    protected String value;
    protected String ovalue;
    protected String derefValue;
    protected Field[] fields;
    protected TypeInfo tinfo;
    private static Logger log = Logger.getLogger("gdb.logger");
    private Set<PropertyChangeListener> listeners = new HashSet<PropertyChangeListener>();
    private static final String ZEROS = "            ";

    public AbstractVariable(GdbVariable gdbVariable) {
        this(gdbVariable.getName(), gdbVariable.getValue());
    }

    public AbstractVariable(String string) {
        this(string, null);
    }

    public AbstractVariable(String string, String string2) {
        assert (string.indexOf(123) == -1);
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        assert (!SwingUtilities.isEventDispatchThread());
        this.name = string;
        this.type = this.getDebugger().requestWhatis(string);
        this.ovalue = null;
        this.fields = new Field[0];
        this.tinfo = TypeInfo.getTypeInfo(this.getDebugger(), this);
        this.getDebugger().addPropertyChangeListener("valueChanged", this);
        this.value = Utilities.getOperatingSystem() != 4096 ? string2 : GdbUtils.mackHack(string2);
        this.derefValue = GdbUtils.isSinglePointer(this.type) ? this.getDebugger().requestValue('*' + string) : null;
    }

    protected AbstractVariable() {
        if (this.getDebugger() != null) {
            this.getDebugger().addPropertyChangeListener("valueChanged", this);
        }
    }

    protected TypeInfo getTypeInfo() {
        if (this.tinfo == null) {
            this.tinfo = TypeInfo.getTypeInfo(this.getDebugger(), this);
        }
        return this.tinfo;
    }

    protected void resetVariable() {
        this.tinfo = null;
        this.type = "";
        this.value = "";
        this.fields = new Field[0];
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String waitForType() {
        if (!SwingUtilities.isEventDispatchThread()) {
            int n = 20;
            while (this.type == null && n-- > 0 && this.debugger.getState().equals("state_stopped")) {
                if (log.isLoggable(Level.FINE) && n == 19) {
                    log.fine("AV.waitForType: Waiting on type for " + this.name);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
        }
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    @Override
    public String getValue() {
        if (this.value.startsWith(">") && this.value.endsWith(".\"<")) {
            return '>' + this.value.substring(2, this.value.length() - 3).replace("\\\"", "\"") + '<';
        }
        return this.value.replace("\\\"", "\"");
    }

    @Override
    public void setValue(String string) {
        Object object;
        if (string.equals(this.value)) {
            return;
        }
        String string2 = null;
        String string3 = this.getTypeInfo().getResolvedType(this);
        if (this.getDebugger() != null) {
            int n;
            if ((string = string.trim()).length() > 0 && string.charAt(0) == '(' && (n = GdbUtils.findMatchingParen(string, 0)) != -1) {
                string = string.substring(n + 1).trim();
            }
            if (string3.equals("char") || string3.equals("unsigned char")) {
                if ((string = this.setValueChar(string)) == null) {
                    string2 = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Char");
                }
            } else if (string3.equals("char *") || string3.equals("unsigned char *")) {
                if ((string = this.setValueCharStar(string)) == null) {
                    string2 = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Char*");
                }
            } else if (string3.equals("int") || string3.equals("long")) {
                if ((string = this.setValueNumber(string)) == null) {
                    string2 = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Number");
                }
            } else if (this.getDebugger().isCplusPlus() && string3.equals("bool")) {
                if (!(string.equals("true") || string.equals("false") || this.isNumber(string))) {
                    string2 = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_CplusPlus_Bool");
                }
            } else if (string3.startsWith("enum ")) {
                if ((string = this.setValueEnum(string)) == null) {
                    string2 = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Enum");
                }
            } else if (string.charAt(0) == '\"' || string.startsWith("0x") && string.endsWith("\"")) {
                if ((string = this.setValueCharStar(string)) == null) {
                    string2 = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Char*");
                }
            } else if (GdbUtils.isPointer(string3)) {
                // empty if block
            }
            if (string != null) {
                if (string.endsWith("\\\"") && (n = string.indexOf(34)) != -1) {
                    string = string.substring(n, string.length() - 1) + '\"';
                }
                if (string.charAt(0) == '(' && (n = GdbUtils.findMatchingParen(string, 0)) != -1) {
                    string = string.substring(n + 1).trim();
                }
            }
            if (string2 == null) {
                object = this instanceof GdbWatchVariable ? ((GdbWatchVariable)this).getWatch().getExpression() : (this instanceof AbstractField ? ((AbstractField)this).getFullName(false) : this.name);
                this.ovalue = this.value;
                this.value = this.getDebugger().updateVariable((String)object, string);
                if (this instanceof AbstractField) {
                    AbstractVariable abstractVariable = ((AbstractField)this).parent;
                    while (abstractVariable instanceof AbstractField) {
                        abstractVariable.value = this.getDebugger().requestValue(abstractVariable.getFullName());
                        this.getDebugger().variableChanged(abstractVariable);
                        abstractVariable = ((AbstractField)abstractVariable).parent;
                    }
                    abstractVariable.value = this.getDebugger().requestValue(abstractVariable.getName());
                    this.getDebugger().variableChanged(abstractVariable);
                    this.getDebugger().updateGdbVariable(abstractVariable.getName(), abstractVariable.value);
                    this.getDebugger().fireLocalsRefresh(abstractVariable);
                }
                this.getDebugger().variableChanged(this);
            }
        }
        if (string2 != null) {
            object = new NotifyDescriptor.Message(string2);
            object.setTitle(NbBundle.getMessage(AbstractVariable.class, (String)"TITLE_SetValue_Warning"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
        }
    }

    public void restoreOldValue() {
        this.value = this.ovalue;
    }

    public synchronized void setModifiedValue(String string) {
        this.value = string;
        if (this.fields.length > 0) {
            this.fields = new Field[0];
            this.derefValue = null;
            if (string.length() > 0) {
                this.expandChildren();
            }
        }
    }

    private String setValueChar(String string) {
        int n;
        if (string.startsWith("0x") && (n = string.indexOf(" '")) != -1 && string.endsWith("'")) {
            string = string.substring(n + 1);
        } else if (string.charAt(0) != '\'' || string.charAt(string.length() - 1) != '\'') {
            string = null;
        }
        return string;
    }

    private String setValueCharStar(String string) {
        int n;
        if (string.startsWith("0x") && (n = string.indexOf(" \\\"")) != -1 && string.endsWith("\\\"")) {
            string = '\"' + string.substring(n + 3, string.length() - 2) + '\"';
        } else if (string.startsWith("0x") && (n = string.indexOf(" \"")) != -1 && string.endsWith("\"")) {
            string = string.substring(n + 1);
        } else if (string.charAt(0) != '\"' || string.charAt(string.length() - 1) != '\"') {
            string = null;
        }
        return string;
    }

    private String setValueEnum(String string) {
        block3: {
            int n;
            int n2;
            String string2;
            block2: {
                string2 = this.getTypeInfo().getResolvedType(this);
                n2 = string2.indexOf(123);
                n = string2.indexOf(125);
                if (n2 <= 0 || n <= 0) break block2;
                String string3 = string2.substring(n2 + 1, n);
                for (String string4 : string3.split(", ")) {
                    if (!string.equals(string4)) continue;
                    return string;
                }
                break block3;
            }
            string2 = this.getTypeInfo().getDetailedType(this);
            n2 = string2.indexOf(123);
            n = string2.indexOf(125);
            if (n2 <= 0 || n <= 0) break block3;
            String string5 = string2.substring(n2 + 1, n);
            for (String string6 : string5.split(", ")) {
                if (!string.equals(string6)) continue;
                return string;
            }
        }
        return null;
    }

    private String setValueNumber(String string) {
        if (!this.isNumber(string)) {
            string = null;
        }
        return string;
    }

    @Override
    public void setObject(Object object) {
    }

    public int getFieldsCount() {
        if (this.getDebugger() == null || !this.getDebugger().getState().equals("state_stopped")) {
            return 0;
        }
        if (this.fields.length > 0) {
            return this.fields.length;
        }
        if (this.mightHaveFields()) {
            return this.estimateFieldCount();
        }
        return 0;
    }

    private boolean mightHaveFields() {
        String string = this.getTypeInfo().getResolvedType(this);
        if (GdbUtils.isArray(string) && !this.isCharString(string)) {
            return true;
        }
        if (this.isValidPointerAddress()) {
            return !GdbUtils.isFunctionPointer(string) && !string.equals("void *") && (!this.isCharString(string) || GdbUtils.isMultiPointer(string));
        }
        return this.value != null && this.value.length() > 0 && (this.value.charAt(0) == '{' || this.value.charAt(this.value.length() - 1) == '}');
    }

    private int estimateFieldCount() {
        int n = 100;
        return n;
    }

    private boolean isValidPointerAddress() {
        String string = "";
        if (this.value == null && this instanceof GdbWatchVariable) {
            this.getValue();
        }
        if (this.value != null) {
            if (this.value.length() > 0 && this.value.charAt(0) == '(') {
                int n = this.value.indexOf("*) 0x");
                if (n == -1) {
                    n = this.value.indexOf("* const) 0x");
                    if (n != -1) {
                        string = this.value.substring(n + 11);
                    }
                } else {
                    string = this.value.substring(n + 5);
                }
                if (n != -1) {
                    long l;
                    try {
                        l = Long.parseLong(string, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    return l > 0L;
                }
            } else if (this.value.startsWith("0x")) {
                long l;
                try {
                    l = Long.parseLong(this.value.substring(2), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return l > 0L;
            }
        }
        return false;
    }

    public Field getField(String string) {
        for (Field field : this.fields) {
            if (!string.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public Field[] getFields(int n, int n2) {
        if (n2 != 0) {
            if (this.fields.length == 0) {
                this.expandChildren();
            }
            n2 = Math.min(this.fields.length, n2);
            n = Math.min(this.fields.length, n);
            Field[] fieldArray = new Field[n2 - n];
            System.arraycopy(this.fields, n, fieldArray, 0, n2 - n);
            return fieldArray;
        }
        return this.fields;
    }

    public String getToStringValue() throws InvalidExpressionException {
        return this.getValue();
    }

    public boolean equals(Object object) {
        return object instanceof AbstractVariable && this.getFullName(true).equals(((AbstractVariable)object).getFullName(true));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected final GdbDebugger getDebugger() {
        if (this.debugger == null) {
            DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
            if (debuggerEngine == null) {
                return null;
            }
            this.debugger = (GdbDebugger)debuggerEngine.lookupFirst(null, GdbDebugger.class);
        }
        return this.debugger;
    }

    public synchronized boolean expandChildren() {
        if (this.fields.length == 0) {
            this.createChildren();
        }
        return this.fields.length > 0;
    }

    private void createChildren() {
        String string = this.getTypeInfo().getResolvedType(this);
        String string2 = null;
        String string3 = null;
        if (GdbUtils.isPointer(string) && !this.isCharString(string) && !GdbUtils.isMultiPointer(string)) {
            if (this.value.endsWith(" 0") || this.value.endsWith(" 0x0")) {
                string2 = null;
                string3 = null;
            } else {
                string2 = GdbUtils.getBaseType(string);
                try {
                    string3 = this.getDebugger().requestValueEx('*' + this.getFullName(false));
                }
                catch (GdbErrorException gdbErrorException) {
                    this.addField(new ErrorField(gdbErrorException.getMessage()));
                    return;
                }
            }
        } else {
            string2 = string;
            string3 = this.value;
        }
        if (string3 != null) {
            if (GdbUtils.isArray(string2)) {
                this.createChildrenForArray(string2, string3);
            } else if (GdbUtils.isMultiPointer(string2)) {
                this.createChildrenForMultiPointer(string2);
            } else {
                Map<String, Object> map = this.getTypeInfo().getMap();
                if (map != null) {
                    if (map.isEmpty() && string3.charAt(0) != '{') {
                        this.createChildrenForPointer(string2, string3);
                    } else if (string3.length() > 0) {
                        int n = string3.indexOf(123);
                        assert (n != -1);
                        String string4 = string3.substring(n + 1, string3.length() - 1);
                        int n2 = 0;
                        int n3 = GdbUtils.findNextComma(string4, 0);
                        while (n3 != -1) {
                            String string5 = string4.substring(n2, n3).trim();
                            this.addField(this.completeFieldDefinition(this, map, string5));
                            n2 = n3 + 1;
                            n3 = GdbUtils.findNextComma(string4, n3 + 1);
                        }
                        this.addField(this.completeFieldDefinition(this, map, string4.substring(n2).trim()));
                    } else {
                        log.fine("AV.createChildren: 0 length value for " + this.getFullName(false));
                    }
                }
            }
        }
    }

    private void createChildrenForPointer(String string, String string2) {
        this.addField(new AbstractField(this, '*' + this.getName(), string, string2));
    }

    private void createChildrenForMultiPointer(String string) {
        int n = 0;
        String string2 = this.getFullName(false);
        String string3 = string.substring(0, string.length() - 1);
        int n2 = string3.startsWith("char *") ? 20 : 10;
        int n3 = AbstractVariable.log10(n2 - 1);
        while (n2-- > 0) {
            String string4 = this.getDebugger().requestValue(string2 + '[' + n + ']');
            if (string4 == null || string4.length() < 1 || string4.endsWith("0x0")) {
                return;
            }
            this.addField(new AbstractField(this, this.getName() + AbstractVariable.getIndexStr(n3, n++), string3, string4));
        }
    }

    private boolean isCharString(String string) {
        return string != null && string.endsWith("*") && !string.endsWith("**") && ((string = GdbUtils.getBaseType(string)).equals("char") || string.equals("unsigned char"));
    }

    private AbstractField completeFieldDefinition(AbstractVariable abstractVariable, Map<String, Object> map, String string) {
        if (string.charAt(0) == '{') {
            int n;
            try {
                n = Integer.parseInt((String)map.get("<anon-count>"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            string = string.substring(1, string.length() - 1);
            for (int i = 1; i <= n; ++i) {
                Map map2 = (Map)map.get("<anonymous" + i + ">");
                int n2 = 0;
                int n3 = GdbUtils.findNextComma(string, 0);
                while (n3 != -1) {
                    String string2 = string.substring(n2, n3).trim();
                    abstractVariable.addField(this.completeFieldDefinition(abstractVariable, map2, string2));
                    n2 = n3 + 1;
                    n3 = GdbUtils.findNextComma(string, n3 + 1);
                }
                abstractVariable.addField(this.completeFieldDefinition(abstractVariable, map2, string.substring(n2).trim()));
            }
        } else {
            int n = string.indexOf(61);
            if (n != -1) {
                String string3;
                String string4;
                String string5;
                if (string.charAt(0) == '<') {
                    string5 = NbBundle.getMessage(AbstractVariable.class, (String)"LBL_BaseClass");
                    string4 = string.substring(1, n - 2).trim();
                    string3 = string.substring(n + 1).trim();
                    if (string4.length() == 0) {
                        string4 = (String)map.get("<super1>");
                    }
                    if (string5.startsWith("_vptr")) {
                        return null;
                    }
                } else {
                    string5 = string.substring(0, n - 1).trim();
                    string3 = string.substring(n + 1).trim();
                    if (string5.startsWith("_vptr")) {
                        return null;
                    }
                    Object object = map.get(string5);
                    if (object instanceof String) {
                        string4 = object.toString();
                    } else if (object instanceof Map) {
                        string4 = (String)((Map)object).get("<name>");
                    } else if (this.isNumber(string3)) {
                        string4 = "int";
                    } else {
                        log.warning("Cannot determine field type for " + string5);
                        return null;
                    }
                }
                return new AbstractField(abstractVariable, string5, string4, string3);
            }
            if (string.trim().equals("<No data fields>")) {
                return new AbstractField(abstractVariable, "", "", string.trim());
            }
        }
        return null;
    }

    private void parseCharArray(AbstractVariable abstractVariable, String string, String string2, int n, String string3) {
        int n2 = 0;
        boolean bl = false;
        int n3 = AbstractVariable.log10(n - 1);
        while (n2 < string3.length()) {
            String string4;
            int n4;
            if (string3.substring(n2).startsWith("\\\"")) {
                String string5;
                n4 = string3.indexOf("\\\",", n2);
                if (n4 >= 0) {
                    string4 = string3.substring(n2 + 2, n4);
                    n2 += string4.length() + 4;
                } else {
                    if (string3.endsWith("\\\"...")) {
                        string4 = string3.substring(n2 + 2, string3.length() - 5);
                        bl = true;
                    } else {
                        string4 = string3.substring(n2 + 2, string3.length() - 2);
                    }
                    n2 = string3.length();
                }
                this.parseCharArrayFragment(abstractVariable, string, string2, n3, string4);
                if (abstractVariable.fields.length < n && n2 >= string3.length()) {
                    abstractVariable.addField(new AbstractField(abstractVariable, string + AbstractVariable.getIndexStr(n3, n - 1), string2.substring(0, string2.indexOf(91)).trim(), "'\\000'"));
                }
                if (!bl) continue;
                try {
                    string5 = string2.substring(string2.indexOf("[") + 1, string2.indexOf("]"));
                    Integer.parseInt(string5);
                }
                catch (Exception exception) {
                    string5 = "...";
                }
                abstractVariable.addField(new AbstractField(abstractVariable, string + AbstractVariable.getIndexStr(n3, abstractVariable.fields.length, "-" + string5), "", "..."));
                continue;
            }
            if (string3.charAt(n2) == ' ' || string3.charAt(n2) == ',') {
                ++n2;
                continue;
            }
            n4 = GdbUtils.findNextComma(string3, n2);
            string4 = n4 > 0 ? string3.substring(n2, n4) : string3.substring(n2);
            this.parseRepeatArrayFragment(abstractVariable, string, string2, n3, string4);
            n2 += string4.length();
        }
    }

    private void parseRepeatArrayFragment(AbstractVariable abstractVariable, String string, String string2, int n, String string3) {
        int n2;
        String string4 = string2.substring(0, string2.indexOf(91)).trim();
        int n3 = abstractVariable.fields.length;
        int n4 = string3.indexOf(32);
        String string5 = string3.substring(0, n4).replace("\\\\", "\\");
        int n5 = string3.indexOf("<repeats ");
        int n6 = string3.indexOf(" times>");
        try {
            n2 = Integer.parseInt(string3.substring(n5 + 9, n6));
        }
        catch (Exception exception) {
            return;
        }
        while (--n2 >= 0) {
            abstractVariable.addField(new AbstractField(abstractVariable, string + AbstractVariable.getIndexStr(n, n3++), string4, string5));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseCharArrayFragment(AbstractVariable abstractVariable, String string, String string2, int n, String string3) {
        String string4 = string2.substring(0, string2.indexOf(91)).trim();
        int n2 = 0;
        string3 = string3.replace("\\\\", "\\");
        int n3 = string3.length();
        int n4 = abstractVariable.fields.length;
        while (true) {
            String string5;
            block8: {
                int n5;
                StringBuilder stringBuilder;
                char c;
                block12: {
                    block11: {
                        int n6;
                        block9: {
                            block10: {
                                if (n2 >= n3) {
                                    return;
                                }
                                n6 = n2;
                                if ((c = string3.charAt(n2++)) != '\\' || n2 >= n3) break block9;
                                if ((c = string3.charAt(n2++)) < '0' || c > '7') break block10;
                                stringBuilder = new StringBuilder();
                                stringBuilder.append('\\');
                                stringBuilder.append(c);
                                break block11;
                            }
                            if (c == 'x' || c == 'X') {
                                stringBuilder = new StringBuilder();
                                stringBuilder.append('\\');
                                stringBuilder.append(c);
                                break block12;
                            } else if (string3.substring(n2 - 1, n2).matches("['\"?abfnrt]") || c == '\\') {
                                string5 = '\\' + string3.substring(n2 - 1, n2);
                                break block8;
                            } else {
                                log.warning("AV.parseCharArrayFragment: Ignoring invalid character array fragment");
                                continue;
                            }
                        }
                        string5 = string3.substring(n6, n2);
                        break block8;
                    }
                    for (n5 = 0; n5 < 2 && n2 < n3 && (c = string3.charAt(n2)) >= '0' && c <= '7'; ++n2, ++n5) {
                        stringBuilder.append(c);
                    }
                    string5 = stringBuilder.toString();
                    break block8;
                }
                for (n5 = 0; !(n5 >= 2 || n2 >= n3 || (c = string3.charAt(n2)) >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F'); ++n2, ++n5) {
                    stringBuilder.append(c);
                }
                string5 = stringBuilder.toString();
            }
            abstractVariable.addField(new AbstractField(abstractVariable, string + AbstractVariable.getIndexStr(n, n4++), string4, '\'' + string5 + '\''));
        }
    }

    private void createChildrenForArray(String string, String string2) {
        int n;
        int n2;
        int n3 = string.lastIndexOf(125);
        if (n3 == -1) {
            n2 = string.indexOf(91);
        } else {
            n2 = string.indexOf(91, n3);
            n3 = string.indexOf(123);
        }
        int n4 = GdbUtils.findMatchingBrace(string, n2);
        assert (n4 != -1);
        int n5 = 0;
        int n6 = string.indexOf(91, n4);
        String string3 = n6 == -1 ? "" : string.substring(n6);
        String string4 = n3 == -1 ? string.substring(0, n2).trim() + string3 : string.substring(0, n3).trim() + string3;
        try {
            n = Integer.valueOf(string.substring(n2 + 1, n4));
        }
        catch (Exception exception) {
            n = 0;
        }
        if (string4.equals("char") || string4.equals("unsigned char")) {
            this.parseCharArray(this, this.getName(), string, n, string2);
        } else {
            string2 = string2.substring(1, string2.length() - 1);
            int n7 = AbstractVariable.log10(n - 1);
            for (int i = 0; i < n && n5 != -1; ++i) {
                int n8 = string2.charAt(n5) == '{' ? GdbUtils.findNextComma(string2, GdbUtils.findMatchingCurly(string2, n5)) : GdbUtils.findNextComma(string2, n5);
                this.addField(new AbstractField(this, this.getName() + AbstractVariable.getIndexStr(n7, i), string4, n8 == -1 ? string2.substring(n5) : string2.substring(n5, n8)));
                n5 = GdbUtils.firstNonWhite(string2, n8 + 1);
            }
        }
    }

    private static String getIndexStr(int n, int n2) {
        return AbstractVariable.getIndexStr(n, n2, "");
    }

    private static String getIndexStr(int n, int n2, String string) {
        int n3 = n - AbstractVariable.log10(n2);
        String string2 = n2 + string;
        if (n3 > 0) {
            string2 = AbstractVariable.zeros(n3) + string2;
        }
        return "[" + string2 + "]";
    }

    private static int log10(int n) {
        int n2 = 1;
        while ((n /= 10) > 0) {
            ++n2;
        }
        return n2;
    }

    static String zeros(int n) {
        if (n < ZEROS.length()) {
            return ZEROS.substring(0, n);
        }
        String string = ZEROS;
        while (string.length() < n) {
            string = string + " ";
        }
        return string;
    }

    public void addField(Field field) {
        if (field != null) {
            int n = this.fields.length;
            Field[] fieldArray = new Field[n + 1];
            System.arraycopy(this.fields, 0, fieldArray, 0, n);
            this.fields = fieldArray;
            this.fields[n] = field;
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("valueChanged")) {
            assert (propertyChangeEvent.getNewValue() instanceof AbstractVariable);
            AbstractVariable abstractVariable = (AbstractVariable)propertyChangeEvent.getNewValue();
            if (abstractVariable != this && abstractVariable.getFullName().equals(this.getFullName())) {
                if (abstractVariable instanceof AbstractField) {
                    final AbstractVariable abstractVariable2 = ((AbstractField)this).getAncestor();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            abstractVariable2.updateVariable();
                        }
                    });
                } else {
                    this.setModifiedValue(abstractVariable.getValue());
                }
            }
        }
    }

    private void updateVariable() {
        this.value = this.getDebugger().requestValue("\"" + this.getName() + "\"");
        String string = this.getTypeInfo().getResolvedType(this);
        if (GdbUtils.isPointer(string)) {
            this.derefValue = this.getDebugger().requestValue('*' + this.getName());
        }
        this.setModifiedValue(this.value);
    }

    public String toString() {
        return this.getFullName(false);
    }

    private boolean isNumber(String string) {
        try {
            Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getFullName() {
        return this.getFullName(false);
    }

    public String getFullName(boolean bl) {
        if (this instanceof AbstractField) {
            return ((AbstractField)this).getFullName(bl);
        }
        return this.getName();
    }

    private boolean isError(String string) {
        return string.startsWith(">") && string.endsWith("<");
    }

    public static class ErrorField
    implements Field {
        private final String msg;

        public ErrorField(String string) {
            this.msg = string.substring(1, string.length() - 1);
        }

        public String getName() {
            return NbBundle.getMessage(AbstractVariable.class, (String)"LBL_Error");
        }

        public boolean isStatic() {
            return false;
        }

        public void setValue(String string) throws InvalidExpressionException {
            throw new UnsupportedOperationException("Not supported");
        }

        public String getType() {
            return "";
        }

        public String getValue() {
            return this.msg;
        }
    }

    public class AbstractField
    extends AbstractVariable
    implements Field {
        private AbstractVariable parent;

        public AbstractField(AbstractVariable abstractVariable2, String string, String string2, String string3) {
            this.name = string.startsWith("static ") ? string.substring(7) : string;
            int n = string2.indexOf(123);
            if (n == -1) {
                this.type = string2;
            } else {
                int n2 = string2.indexOf(125, n);
                this.type = string2.substring(0, n).trim() + string2.substring(n2 + 1);
            }
            this.parent = abstractVariable2;
            this.fields = new Field[0];
            this.derefValue = null;
            this.tinfo = null;
            this.value = Utilities.getOperatingSystem() == 4096 ? GdbUtils.mackHack(string3) : string3;
        }

        protected AbstractVariable getAncestor() {
            if (this.parent instanceof AbstractField) {
                return ((AbstractField)this.parent).getAncestor();
            }
            return this.parent;
        }

        public boolean isStatic() {
            return false;
        }

        public String getFullName(boolean bl) {
            int n;
            String string = this.parent instanceof AbstractField ? ((AbstractField)this.parent).getFullName(bl) : this.parent.getName();
            String string2 = this.name.equals(NbBundle.getMessage(AbstractVariable.class, (String)"LBL_BaseClass")) ? (bl ? string + ".<" + this.type + ">" : string) : (this.name.indexOf(91) != -1 ? ((n = string.lastIndexOf(46)) != -1 ? string.substring(0, n) + '.' + this.name : this.name) : (GdbUtils.isSimplePointer(this.parent.getType()) && this.name.startsWith("*") ? '*' + string : (GdbUtils.isPointer(this.parent.getType()) ? string + "->" + this.name : (this.name.length() > 0 ? string + '.' + this.name : string))));
            return string2;
        }
    }
}

