/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.gdb.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpointPanel;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpointPanel;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpointPanel;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BreakpointsActionsProvider
implements NodeActionsProviderFilter {
    private static final Action GO_TO_SOURCE_ACTION = Models.createAction((String)BreakpointsActionsProvider.loc("CTL_Breakpoint_GoToSource_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            BreakpointsActionsProvider.goToSource((LineBreakpoint)((Object)objectArray[0]));
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action CUSTOMIZE_ACTION = Models.createAction((String)BreakpointsActionsProvider.loc("CTL_Breakpoint_Customize_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            BreakpointsActionsProvider.customize((Breakpoint)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action GO_TO_DIS_ACTION = Models.createAction((String)BreakpointsActionsProvider.loc("CTL_Breakpoint_GoToDis_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return Disassembly.getCurrent() != null;
        }

        public void perform(Object[] objectArray) {
            BreakpointsActionsProvider.goToSource((AddressBreakpoint)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    private static String loc(String string) {
        return NbBundle.getBundle(BreakpointsActionsProvider.class).getString(string);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (!(object instanceof GdbBreakpoint)) {
            return nodeActionsProvider.getActions(object);
        }
        Action[] actionArray = nodeActionsProvider.getActions(object);
        if (object instanceof LineBreakpoint) {
            Action[] actionArray2 = new Action[actionArray.length + 3];
            actionArray2[0] = GO_TO_SOURCE_ACTION;
            actionArray2[1] = null;
            System.arraycopy(actionArray, 0, actionArray2, 2, actionArray.length);
            actionArray2[actionArray2.length - 1] = CUSTOMIZE_ACTION;
            return actionArray2;
        }
        if (object instanceof AddressBreakpoint) {
            Action[] actionArray3 = new Action[actionArray.length + 3];
            actionArray3[0] = GO_TO_DIS_ACTION;
            actionArray3[1] = null;
            System.arraycopy(actionArray, 0, actionArray3, 2, actionArray.length);
            actionArray3[actionArray3.length - 1] = CUSTOMIZE_ACTION;
            return actionArray3;
        }
        Action[] actionArray4 = new Action[actionArray.length + 1];
        System.arraycopy(actionArray, 0, actionArray4, 0, actionArray.length);
        actionArray4[actionArray4.length - 1] = CUSTOMIZE_ACTION;
        return actionArray4;
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            BreakpointsActionsProvider.goToSource((LineBreakpoint)((Object)object));
        } else if (object instanceof AddressBreakpoint) {
            BreakpointsActionsProvider.goToSource((AddressBreakpoint)object);
        } else if (object instanceof GdbBreakpoint) {
            BreakpointsActionsProvider.customize((Breakpoint)object);
        } else {
            nodeActionsProvider.performDefaultAction(object);
        }
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    public static JComponent getCustomizerComponent(Breakpoint breakpoint) {
        JPanel jPanel = null;
        if (breakpoint instanceof LineBreakpoint) {
            jPanel = new LineBreakpointPanel((LineBreakpoint)breakpoint);
        } else if (breakpoint instanceof FunctionBreakpoint) {
            jPanel = new FunctionBreakpointPanel((FunctionBreakpoint)breakpoint);
        } else if (breakpoint instanceof AddressBreakpoint) {
            jPanel = new AddressBreakpointPanel((AddressBreakpoint)breakpoint);
        } else {
            throw new IllegalStateException(breakpoint.toString());
        }
        ((Component)jPanel).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"ACSD_Breakpoint_Customizer_Dialog"));
        return jPanel;
    }

    public static void customize(Breakpoint breakpoint) {
        JComponent jComponent = BreakpointsActionsProvider.getCustomizerComponent(breakpoint);
        HelpCtx helpCtx = HelpCtx.findHelp((Component)jComponent);
        if (helpCtx == null) {
            helpCtx = new HelpCtx("debug.add.breakpoint");
        }
        final Controller[] controllerArray = new Controller[]{(Controller)jComponent};
        final DialogDescriptor[] dialogDescriptorArray = new DialogDescriptor[1];
        final Dialog[] dialogArray = new Dialog[1];
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (dialogDescriptorArray[0].getValue() == DialogDescriptor.OK_OPTION) {
                    boolean bl = controllerArray[0].ok();
                    if (bl) {
                        dialogArray[0].setVisible(false);
                    }
                } else {
                    dialogArray[0].setVisible(false);
                }
            }
        };
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jComponent, NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_Breakpoint_Customizer_Title"), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, actionListener);
        dialogDescriptor.setClosingOptions(new Object[0]);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialogDescriptorArray[0] = dialogDescriptor;
        dialogArray[0] = dialog;
        dialog.setVisible(true);
    }

    private static void goToSource(GdbBreakpoint gdbBreakpoint) {
        EditorContextBridge.showSource(gdbBreakpoint, null);
    }
}

