/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.gdb.Field;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.InvalidExpressionException;
import org.netbeans.modules.cnd.debugger.gdb.LocalVariable;
import org.netbeans.modules.cnd.debugger.gdb.Variable;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class VariablesTableModel
implements TableModel,
Constants {
    private GdbDebugger debugger;
    private ContextProvider lookupProvider;
    private static Logger log = Logger.getLogger("gdb.logger");

    public VariablesTableModel(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (this.debugger == null || !this.debugger.getState().equals("state_stopped")) {
            return "";
        }
        if (string.equals("LocalsToString") || string.equals("WatchToString")) {
            if (object instanceof Variable) {
                return ((Variable)object).getValue();
            }
        } else if (string.equals("LocalsType") || string.equals("WatchType")) {
            if (object instanceof Variable) {
                return ((Variable)object).getType();
            }
        } else if ((string.equals("LocalsValue") || string.equals("WatchValue")) && object instanceof Variable) {
            return ((Variable)object).getValue();
        }
        if (object instanceof JToolTip) {
            if ((object = ((JToolTip)object).getClientProperty("getShortDescrption")) instanceof AbstractVariable) {
                return ((AbstractVariable)object).getType();
            }
            if (object == null) {
                return "";
            }
        }
        if (object.toString().startsWith("No current thread")) {
            return NbBundle.getMessage(VariablesTableModel.class, (String)"NoCurrentThreadVar");
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof AbstractVariable) {
            AbstractVariable abstractVariable = (AbstractVariable)object;
            if (this.debugger == null || !this.debugger.getState().equals("state_stopped")) {
                return true;
            }
            if (string.equals("LocalsToString") || string.equals("WatchToString") || string.equals("LocalsType") || string.equals("WatchType")) {
                return true;
            }
            if (string.equals("LocalsValue") || string.equals("WatchValue")) {
                String string2 = abstractVariable.waitForType();
                if (string2 == null) {
                    if (log.isLoggable(Level.FINE) && this.debugger.getState().equals("state_stopped") && !SwingUtilities.isEventDispatchThread()) {
                        log.fine("VTM.isReadOnly: null type for " + abstractVariable.getName() + " (state is " + this.debugger.getState() + ")");
                    }
                    return false;
                }
                if (GdbUtils.isPointer(string2)) {
                    return false;
                }
                if (string2.length() == 0 && abstractVariable.getValue() != null && abstractVariable.getValue().equals("...")) {
                    return true;
                }
                return abstractVariable.getFieldsCount() != 0;
            }
        } else {
            if (object.toString().startsWith("No current thread")) {
                return true;
            }
            if (object instanceof AbstractVariable.ErrorField) {
                return true;
            }
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (this.debugger == null || !this.debugger.getState().equals("state_stopped")) {
            return;
        }
        if (object instanceof LocalVariable) {
            if (string.equals("LocalsValue") || string.equals("WatchValue")) {
                if (object instanceof GdbWatchVariable) {
                    ((GdbWatchVariable)object).setValueAt((String)object2);
                } else {
                    ((LocalVariable)object).setValue((String)object2);
                }
                return;
            }
        } else if (object instanceof Field && (string.equals("LocalsValue") || string.equals("WatchValue"))) {
            try {
                ((Field)object).setValue((String)object2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }
}

