/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalTerminal
implements PropertyChangeListener {
    private String tty = null;
    private long pid;
    private File gdbHelperLog = null;
    private File gdbHelperScript = null;
    private GdbDebugger debugger;

    public ExternalTerminal(GdbDebugger gdbDebugger, String string, String[] stringArray) throws IOException {
        Object object;
        Object object2;
        this.initGdbHelpers();
        gdbDebugger.addPropertyChangeListener(this);
        this.debugger = gdbDebugger;
        ProcessBuilder processBuilder = new ProcessBuilder(this.getTermOptions(string));
        if (Utilities.getOperatingSystem() == 4096 && (object2 = processBuilder.environment()).get("DISPLAY") == null) {
            object = ":0.0";
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("DISPLAY=") || stringArray[i].length() < 8) continue;
                object = stringArray[i].substring(8);
            }
            object2.put("DISPLAY", object);
        }
        object2 = processBuilder.start();
        object = new BufferedReader(new FileReader(this.gdbHelperLog.getAbsolutePath()));
        new RequestProcessor("TermReader").post(new Runnable((BufferedReader)object){
            final /* synthetic */ BufferedReader val$fromTerm;
            {
                this.val$fromTerm = bufferedReader;
            }

            public void run() {
                int n = 0;
                String string = null;
                try {
                    while (n++ < 300) {
                        ExternalTerminal.this.tty = this.val$fromTerm.readLine();
                        string = this.val$fromTerm.readLine();
                        if (string == null) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    return;
                }
                try {
                    ExternalTerminal.this.pid = Long.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    ExternalTerminal.this.pid = 0L;
                }
            }
        });
    }

    private void initGdbHelpers() {
        Object object;
        try {
            this.gdbHelperLog = File.createTempFile("gdb_helper_", ".log");
            this.gdbHelperScript = File.createTempFile("gdb_helper_", ".sh");
        }
        catch (IOException iOException) {
            this.gdbHelperLog = new File("/tmp/gdb_helper.log");
            this.gdbHelperScript = new File("/tmp/gdb_helper.sh");
        }
        String string = NbBundle.getMessage(ExternalTerminal.class, (String)"GdbHelperScript", (Object)this.gdbHelperLog.getAbsolutePath());
        this.gdbHelperLog.deleteOnExit();
        this.gdbHelperScript.deleteOnExit();
        try {
            object = new FileWriter(this.gdbHelperScript);
            ((Writer)object).write(string);
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = new ProcessBuilder("/bin/chmod", "755", this.gdbHelperScript.getAbsolutePath());
        try {
            ((ProcessBuilder)object).start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getTty() {
        while (this.tty == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.tty;
    }

    private List<String> getTermOptions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        if (string.contains("gnome-terminal")) {
            arrayList.add("--hide-menubar");
            arrayList.add("--disable-factory");
            arrayList.add("--command");
            arrayList.add(this.gdbHelperScript.getAbsolutePath());
        } else if (string.contains("xterm")) {
            arrayList.add("-e");
            arrayList.add(this.gdbHelperScript.getAbsolutePath());
        } else if (string.contains("konsole")) {
            arrayList.add("-e");
            arrayList.add(this.gdbHelperScript.getAbsolutePath());
        }
        return arrayList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("state")) {
            Object object = propertyChangeEvent.getNewValue();
            if (object == "state_none") {
                this.gdbHelperScript.delete();
                this.gdbHelperLog.delete();
            }
        } else if (propertyChangeEvent.getPropertyName().equals("killTerm")) {
            this.debugger.kill(15, this.pid);
        }
    }
}

