/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.base.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.compapp.projects.base.IcanproConstants;
import org.netbeans.modules.compapp.projects.base.ui.FoldersListSettings;
import org.netbeans.modules.compapp.projects.base.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.compapp.projects.base.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

class PanelProjectLocationVisual
extends SettingsPanel
implements DocumentListener,
IcanproConstants {
    public static final String PROP_PROJECT_NAME = "projectName";
    private PanelConfigureProject panel;
    private JButton Button;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    protected JTextField projectNameTextField;

    public PanelProjectLocationVisual(PanelConfigureProject panelConfigureProject) {
        this.initComponents();
        this.panel = panelConfigureProject;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
    }

    JTextField getProjectNameTextField() {
        return this.projectNameTextField;
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.Button = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_ProjectName_A11YDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_ProjectName_A11YDesc"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NPW1_ProjectLocation_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.Button, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.Button.setActionCommand("BROWSE");
        this.Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelProjectLocationVisual.this.browseLocationAction(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.Button, gridBagConstraints);
        this.Button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_BrowseLocation_A11YDesc"));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.createdFolderLabel, gridBagConstraints);
        this.createdFolderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.createdFolderTextField, gridBagConstraints);
        this.createdFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_CreatedProjectFolder_A11YDesc"));
    }

    private void browseLocationAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("BROWSE".equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(NbBundle.getBundle((String)"org/netbeans/modules/compapp/projects/base/ui/wizards/Bundle").getString("LBL_NWP1_SelectProjectLocation"));
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                this.projectLocationTextField.setText(file.getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        File file;
        String string = this.projectNameTextField.getText();
        if (string.length() == 0 || string.substring(0, 1).equals("\\") || string.indexOf(47) >= 0 || string.indexOf("\\") >= 0 || string.indexOf(58) >= 0 || !PanelProjectLocationVisual.isValidName(string)) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getBundle((String)"org/netbeans/modules/compapp/projects/base/ui/wizards/Bundle").getString("MSG_IllegalProjectName"));
            return false;
        }
        if (string.indexOf(32) >= 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectNameWithWhiteSpace"));
            return false;
        }
        File file2 = new File(this.projectLocationTextField.getText()).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(file2) == null) {
            String string2 = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string2);
            return false;
        }
        File file3 = new File(this.createdFolderTextField.getText());
        if (PanelProjectLocationVisual.getCanonicalFile(file3) == null) {
            String string3 = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectName");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string3);
            return false;
        }
        for (file = FileUtil.normalizeFile((File)file3); file != null && !file.exists(); file = file.getParentFile()) {
        }
        if (file == null || !file.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderReadOnly"));
            return false;
        }
        if (FileUtil.toFileObject((File)file) == null) {
            String string4 = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string4);
            return false;
        }
        File[] fileArray = file3.listFiles();
        if (file3.exists() && fileArray != null && fileArray.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getBundle((String)"org/netbeans/modules/compapp/projects/base/ui/wizards/Bundle").getString("MSG_ProjectFolderExists"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    static boolean isValidName(String string) {
        try {
            boolean bl = true;
            File file = new File(string);
            String string2 = "00" + string;
            File file2 = File.createTempFile(string2, null);
            if (!FileUtil.normalizeFile((File)file).equals(file.getCanonicalFile())) {
                bl = false;
            }
            file2.delete();
            file2 = null;
            file = null;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(this.createdFolderTextField.getText().trim()));
        wizardDescriptor.putProperty("name", (Object)string);
        File file = new File(this.projectLocationTextField.getText());
        if (file.isDirectory()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
    }

    public void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationTextField.setText(file.getAbsolutePath());
        String string = (String)wizardDescriptor.getProperty("name");
        if (string == null) {
            int n = FoldersListSettings.getDefault().getNewProjectCount() + 1;
            String string2 = this.panel.getDefaultName();
            while ((string = this.validFreeProjectName(file, string2, n)) == null) {
                ++n;
            }
        }
        this.projectNameTextField.setText(string);
        this.projectNameTextField.selectAll();
    }

    private static JFileChooser createChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        return jFileChooser;
    }

    private String validFreeProjectName(File file, String string, int n) {
        String string2 = MessageFormat.format(string, new Integer(n));
        File file2 = new File(file, string2);
        return file2.exists() ? null : string2;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            String string3 = FileUtil.normalizeFile((File)new File(string2)).getAbsolutePath();
            if (string3.endsWith(File.separator)) {
                this.createdFolderTextField.setText(string3 + string);
            } else {
                this.createdFolderTextField.setText(string3 + File.separator + string);
            }
        }
        this.panel.fireChangeEvent();
    }

    private String getCreatedFolderPath() {
        StringBuffer stringBuffer = new StringBuffer(this.projectLocationTextField.getText().trim());
        if (!this.projectLocationTextField.getText().endsWith(File.separator)) {
            stringBuffer.append(File.separatorChar);
        }
        stringBuffer.append(this.projectNameTextField.getText().trim());
        return stringBuffer.toString();
    }

    static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

