/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.common;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.compapp.projects.common.XAMCatalogWSDLSerializer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogWSDL {
    public static final String TNS = "http://soa.netbeans.org/wsdl/catalog";
    public static final String CATALOG_WSDL_FILE = "catalog.wsdl";
    public static final String CATALOG_NAME = "catalog";
    private static final Logger sLogger = Logger.getLogger(CatalogWSDL.class.getName());
    private static CatalogWSDLSerializer sSerializer = new XAMCatalogWSDLSerializer();
    private List<Entry> mEntries = new ArrayList<Entry>();

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.mEntries);
    }

    public List<Entry> getEntries(EntryType entryType) {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (Entry entry : this.mEntries) {
            if (!entry.getType().equals((Object)entryType)) continue;
            arrayList.add(entry);
        }
        return arrayList;
    }

    public List<Entry> getEntries(String string) {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (Entry entry : this.mEntries) {
            if (!entry.getNamesapce().equals(string)) continue;
            arrayList.add(entry);
        }
        return arrayList;
    }

    public Entry getEntry(EntryType entryType, String string, String string2) {
        for (Entry entry : this.mEntries) {
            if (!entry.getType().equals((Object)entryType) || !entry.getNamesapce().equals(string) || string2 != null && !string2.equals(entry.getLocation())) continue;
            return entry;
        }
        return null;
    }

    public boolean addAllEntries(List<Entry> list) {
        return this.mEntries.addAll(list);
    }

    public boolean addEntry(Entry entry) {
        return this.mEntries.add(entry);
    }

    public boolean removeEntry(Entry entry) {
        return this.mEntries.remove(entry);
    }

    public void clear() {
        this.mEntries.clear();
    }

    public static void setCatalogWSDLSerializer(CatalogWSDLSerializer catalogWSDLSerializer) {
        sLogger.fine("new CatalogWSDLSerializer set");
        sSerializer = catalogWSDLSerializer;
    }

    public static CatalogWSDLSerializer getCatalogWSDLSerializer() {
        if (sSerializer == null) {
            sSerializer = new XAMCatalogWSDLSerializer();
        }
        return sSerializer;
    }

    public static CatalogWSDL loadCatalogWSDL(FileObject fileObject) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(CATALOG_WSDL_FILE);
        if (fileObject2 == null) {
            throw new FileNotFoundException("Catalog.wsdl file not found in " + fileObject.getPath());
        }
        return CatalogWSDL.getCatalogWSDLSerializer().unmarshall(fileObject2);
    }

    public static void saveCatalogWSDL(CatalogWSDL catalogWSDL, FileObject fileObject) throws IOException {
        FileObject fileObject2 = CatalogWSDLSerializer.createCatalogWSDLFile(fileObject, true);
        CatalogWSDL.getCatalogWSDLSerializer().marshall(catalogWSDL, fileObject2);
    }

    public static FileObject getCatalogWSDLFile(Project project) throws IOException {
        FileObject fileObject = CatalogWSDLSerializer.createCatalogWSDLFile(project.getProjectDirectory(), false);
        return fileObject;
    }

    public static CatalogWSDL loadCatalogWSDL(Project project) throws IOException {
        return CatalogWSDL.loadCatalogWSDL(project.getProjectDirectory());
    }

    public static void saveCatalogWSDL(CatalogWSDL catalogWSDL, Project project) throws IOException {
        CatalogWSDL.saveCatalogWSDL(catalogWSDL, project.getProjectDirectory());
    }

    public static abstract class CatalogWSDLSerializer {
        public abstract void marshall(CatalogWSDL var1, FileObject var2) throws IOException;

        public abstract CatalogWSDL unmarshall(FileObject var1) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void saveToFileObject(FileObject fileObject, StringBuffer stringBuffer) {
            FileLock fileLock = null;
            OutputStream outputStream = null;
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
                fileLock = fileObject.lock();
                outputStream = fileObject.getOutputStream(fileLock);
                FileUtil.copy((InputStream)byteArrayInputStream, (OutputStream)outputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (byteArrayInputStream != null) {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException) {
                        sLogger.log(Level.FINER, iOException.getMessage(), iOException);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        sLogger.log(Level.FINER, iOException.getMessage(), iOException);
                    }
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }

        public static FileObject createCatalogWSDLFile(FileObject fileObject, boolean bl) throws IOException {
            FileObject fileObject2 = null;
            fileObject2 = fileObject.getFileObject(CatalogWSDL.CATALOG_WSDL_FILE);
            if (fileObject2 != null && !bl) {
                return fileObject2;
            }
            if (fileObject2 == null) {
                fileObject2 = FileUtil.createData((FileObject)fileObject, (String)CatalogWSDL.CATALOG_WSDL_FILE);
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<definitions name=\"catalog\" targetNamespace=\"http://soa.netbeans.org/wsdl/catalog\"");
            printWriter.println("   xmlns=\"http://schemas.xmlsoap.org/wsdl/\"");
            printWriter.println("   xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"");
            printWriter.println("   xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
            printWriter.println("   xmlns:tns=\"http://soa.netbeans.org/wsdl/catalog\"");
            printWriter.println(">");
            printWriter.println("   <types/>");
            printWriter.println("</definitions>");
            printWriter.close();
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            CatalogWSDLSerializer.saveToFileObject(fileObject2, stringWriter.getBuffer());
            return fileObject2;
        }
    }

    public static class Entry {
        private EntryType mType;
        private String mNamespace;
        private String mLocation;

        public Entry(EntryType entryType) {
            this.mType = entryType;
        }

        public EntryType getType() {
            return this.mType;
        }

        public String getNamesapce() {
            return this.mNamespace;
        }

        public void setNamespace(String string) {
            this.mNamespace = string;
        }

        public String getLocation() {
            return this.mLocation;
        }

        public void setLocation(String string) {
            this.mLocation = string;
        }

        public String toString() {
            return " Type     : " + (Object)((Object)this.mType) + "\n Namespace: " + this.mNamespace + "\n Location : " + this.mLocation;
        }

        public static Entry createXSDEntry(String string, String string2) {
            Entry entry = new Entry(EntryType.XSD);
            entry.setNamespace(string);
            entry.setLocation(string2);
            return entry;
        }

        public static Entry createWSDLEntry(String string, String string2) {
            Entry entry = new Entry(EntryType.WSDL);
            entry.setNamespace(string);
            entry.setLocation(string2);
            return entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntryType {
        XSD,
        WSDL;

    }
}

