/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.actions;

import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.ui.CreateDatabasePanel;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDatabaseAction
extends CookieAction {
    private static Logger LOGGER = Logger.getLogger(CreateDatabaseAction.class.getName());
    private static final Class[] COOKIE_CLASSES = new Class[]{DatabaseServer.class};

    public CreateDatabaseAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return Utils.getBundle().getString("LBL_CreateDatabaseAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateDatabaseAction.class);
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return false;
        }
        Node node = nodeArray[0];
        DatabaseServer databaseServer = (DatabaseServer)node.getCookie(DatabaseServer.class);
        return databaseServer != null && databaseServer.isConnected();
    }

    protected int mode() {
        return 8;
    }

    protected Class<?>[] cookieClasses() {
        return COOKIE_CLASSES;
    }

    protected void performAction(Node[] nodeArray) {
        Node node = nodeArray[0];
        DatabaseServer databaseServer = (DatabaseServer)node.getCookie(DatabaseServer.class);
        try {
            CreateDatabasePanel createDatabasePanel = new CreateDatabasePanel(databaseServer);
            createDatabasePanel.showCreateDatabaseDialog();
        }
        catch (DatabaseException databaseException) {
            Utils.displayErrorMessage(databaseException.getMessage());
        }
    }
}

