/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionProcessor
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ConnectionProcessor.class.getName());
    final BlockingQueue<Runnable> inqueue;
    private Connection conn;
    private Thread taskThread;

    void setConnection(Connection connection) {
        this.conn = connection;
    }

    Connection getConnection() {
        return this.conn;
    }

    void validateConnection() throws DatabaseException {
        try {
            if (this.conn == null) {
                return;
            }
            if (this.conn.isClosed()) {
                this.conn = null;
                throw new DatabaseException(NbBundle.getMessage(ConnectionProcessor.class, (String)"MSG_ConnectionLost"));
            }
            this.conn.getMetaData().getTables(null, null, " ", new String[]{"TABLE"}).close();
        }
        catch (SQLException sQLException) {
            this.conn = null;
            LOGGER.log(Level.FINE, null, sQLException);
            throw new DatabaseException(NbBundle.getMessage(ConnectionProcessor.class, (String)"MSG_ConnectionLost"), (Throwable)sQLException);
        }
    }

    boolean isConnected() {
        return this.conn != null;
    }

    boolean isConnProcessorThread() {
        return Thread.currentThread().equals(this.taskThread);
    }

    public ConnectionProcessor(BlockingQueue<Runnable> blockingQueue) {
        this.inqueue = blockingQueue;
    }

    @Override
    public void run() {
        this.taskThread = Thread.currentThread();
        try {
            while (true) {
                Runnable runnable = this.inqueue.take();
                runnable.run();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

