/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.WebProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class WebProjectUtil {
    private WebProjectUtil() {
    }

    public static URL getRootURL(File file, String string) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        } else if (!file.exists()) {
            uRL = new URL(uRL.toExternalForm() + "/");
        }
        if (string != null) {
            assert (string.endsWith("/"));
            uRL = new URL(uRL.toExternalForm() + string);
        }
        return uRL;
    }

    public static LibraryChooser.Filter getFilter(WebProject webProject) {
        LibraryChooser.Filter filter = null;
        if ("1.3".equals(WebModule.getWebModule((FileObject)webProject.getProjectDirectory()).getJ2eePlatformVersion())) {
            filter = new LibraryChooser.Filter(){

                public boolean accept(Library library) {
                    if ("javascript".equals(library.getType())) {
                        return false;
                    }
                    try {
                        library.getContent("classpath");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                    return !library.getName().matches("jstl11|jaxrpc16|toplink|Spring|jaxws20|jaxb20|struts|jsf");
                }
            };
        }
        return filter;
    }
}

