/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.identity.profile.api.configurator.Configurator;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.netbeans.modules.identity.profile.api.configurator.ProviderConfigurator;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanism;
import org.netbeans.modules.identity.profile.ui.WSCSecurityPanel;
import org.netbeans.modules.identity.profile.ui.support.J2eeProjectHelper;
import org.netbeans.modules.xml.multiview.ui.SectionNodeInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WSPSecurityPanel
extends SectionNodeInnerPanel {
    private static final String URN = "urn:";
    private ProviderConfigurator configurator;
    private J2eeProjectHelper helper;
    private boolean disabled = false;
    private JLabel certSettingsInfoLabel;
    private JLabel certSettingsLabel;
    private JCheckBox enableSecurityCB;
    private JLabel errorLabel;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JLabel requestLabel;
    private JComboBox requestSecMechCB;
    private JLabel secMechLabel;
    private JLabel userNameInfoLabel;

    public WSPSecurityPanel(SectionNodeView sectionNodeView, J2eeProjectHelper j2eeProjectHelper) {
        super(sectionNodeView);
        this.initComponents();
        this.errorLabel.setText("");
        this.helper = j2eeProjectHelper;
        try {
            this.configurator = ProviderConfigurator.getConfigurator((String)j2eeProjectHelper.getServiceDescriptionName(), (ProviderConfigurator.Type)ProviderConfigurator.Type.WSP, (Configurator.AccessMethod)Configurator.AccessMethod.FILE, (Object)j2eeProjectHelper.getConfigPath(), (String)j2eeProjectHelper.getServerID());
        }
        catch (ConfiguratorException configuratorException) {
            this.errorLabel.setText(configuratorException.getMessage());
            this.disabled = true;
        }
        if (!this.disabled) {
            if (j2eeProjectHelper.isSecurityEnabled()) {
                this.enableSecurityCB.setSelected(true);
            } else {
                this.enableSecurityCB.setSelected(false);
            }
            this.configurator.addModifier(ProviderConfigurator.Configurable.SECURITY_MECH, (Object)this.requestSecMechCB, (Object)this.configurator.getSecMechHelper().getAllWSPSecurityMechanisms());
        }
        this.updateVisualState();
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    public void setValue(JComponent jComponent, Object object) {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    private void updateVisualState() {
        if (this.disabled) {
            this.disableAll();
            this.enableSecurityCB.setEnabled(false);
            return;
        }
        if (this.helper.isWsitSecurityEnabled()) {
            this.enableSecurityCB.setEnabled(false);
            this.errorLabel.setText(NbBundle.getMessage(WSCSecurityPanel.class, (String)"MSG_WsitEnabled"));
        } else {
            this.enableSecurityCB.setEnabled(true);
            this.errorLabel.setText("");
        }
        if (this.enableSecurityCB.isSelected() && this.enableSecurityCB.isEnabled()) {
            this.secMechLabel.setEnabled(true);
            this.requestLabel.setEnabled(true);
            this.requestSecMechCB.setEnabled(true);
            this.userNameInfoLabel.setEnabled(true);
            this.certSettingsLabel.setEnabled(true);
            this.certSettingsInfoLabel.setEnabled(true);
            this.certSettingsInfoLabel.setBackground(UIManager.getDefaults().getColor("Label.background"));
            this.certSettingsInfoLabel.setForeground(UIManager.getDefaults().getColor("Label.foreground"));
        } else {
            this.secMechLabel.setEnabled(false);
            this.requestLabel.setEnabled(false);
            this.requestSecMechCB.setEnabled(false);
            this.userNameInfoLabel.setEnabled(false);
            this.certSettingsLabel.setEnabled(false);
            this.certSettingsInfoLabel.setEnabled(false);
            this.certSettingsInfoLabel.setBackground(UIManager.getDefaults().getColor("Label.disabledShadow"));
            this.certSettingsInfoLabel.setForeground(UIManager.getDefaults().getColor("Label.disabledForeground"));
        }
        SecurityMechanism securityMechanism = (SecurityMechanism)this.requestSecMechCB.getSelectedItem();
        if (securityMechanism.isPasswordCredentialRequired() && this.requestSecMechCB.isEnabled()) {
            this.userNameInfoLabel.setVisible(true);
        } else {
            this.userNameInfoLabel.setVisible(false);
        }
    }

    private void disableAll() {
        this.secMechLabel.setEnabled(false);
        this.requestLabel.setEnabled(false);
        this.requestSecMechCB.setEnabled(false);
        this.userNameInfoLabel.setEnabled(false);
        this.certSettingsLabel.setEnabled(false);
        this.certSettingsInfoLabel.setEnabled(false);
        this.certSettingsInfoLabel.setBackground(UIManager.getDefaults().getColor("Label.disabledShadow"));
        this.certSettingsInfoLabel.setForeground(UIManager.getDefaults().getColor("Label.disabledForeground"));
        this.userNameInfoLabel.setVisible(false);
    }

    public void save() {
        if (!this.disabled) {
            if (this.enableSecurityCB.isSelected()) {
                this.configurator.save();
                SecurityMechanism securityMechanism = (SecurityMechanism)this.configurator.getValue((Enum)ProviderConfigurator.Configurable.SECURITY_MECH);
                this.helper.enableWSPSecurity(securityMechanism.getName());
            } else {
                this.helper.disableWSPSecurity();
                this.configurator.disable();
                this.configurator.save();
            }
        }
        this.configurator.close();
        this.helper.clearTransientState();
    }

    public void cancel() {
        this.configurator.close();
        this.helper.clearTransientState();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.enableSecurityCB = new JCheckBox();
        this.secMechLabel = new JLabel();
        this.requestLabel = new JLabel();
        this.userNameInfoLabel = new JLabel();
        this.requestSecMechCB = new JComboBox();
        this.certSettingsInfoLabel = new JLabel();
        this.certSettingsLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.errorLabel = new JLabel();
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                WSPSecurityPanel.this.formFocusGained(focusEvent);
            }
        });
        this.addAncestorListener(new AncestorListener(){

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                WSPSecurityPanel.this.formAncestorAdded(ancestorEvent);
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/identity/profile/ui/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.enableSecurityCB, (String)resourceBundle.getString("LBL_EnableSecurity"));
        this.enableSecurityCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableSecurityCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WSPSecurityPanel.this.enableSecurityCBActionPerformed(actionEvent);
            }
        });
        this.secMechLabel.setText(resourceBundle.getString("LBL_SecurityMechanisms"));
        this.requestLabel.setLabelFor(this.requestSecMechCB);
        Mnemonics.setLocalizedText((JLabel)this.requestLabel, (String)resourceBundle.getString("LBL_Request"));
        this.userNameInfoLabel.setText(resourceBundle.getString("MSG_UserNameInfo"));
        this.requestSecMechCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WSPSecurityPanel.this.requestSecMechCBActionPerformed(actionEvent);
            }
        });
        this.certSettingsInfoLabel.setText(resourceBundle.getString("MSG_CertificateSettingsInfo"));
        this.certSettingsInfoLabel.setFocusable(false);
        this.certSettingsLabel.setText(resourceBundle.getString("LBL_CertificateSettings"));
        this.errorLabel.setForeground(new Color(255, 0, 0));
        this.errorLabel.setText("Error:");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(20, 20, 20).add((Component)this.certSettingsInfoLabel, -1, 390, Short.MAX_VALUE)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(30, 30, 30).add((Component)this.userNameInfoLabel, -1, 380, Short.MAX_VALUE)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.enableSecurityCB).add((Component)this.secMechLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.requestLabel).addPreferredGap(0).add((Component)this.requestSecMechCB, 0, 321, Short.MAX_VALUE)))).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator1, -1, 390, Short.MAX_VALUE)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.certSettingsLabel)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.errorLabel))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.enableSecurityCB).addPreferredGap(0).add((Component)this.secMechLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.requestLabel).add((Component)this.requestSecMechCB, -2, -1, -2)).addPreferredGap(0).add((Component)this.userNameInfoLabel).addPreferredGap(0).add((Component)this.certSettingsLabel).addPreferredGap(0).add((Component)this.certSettingsInfoLabel).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.errorLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.updateVisualState();
    }

    private void formAncestorAdded(AncestorEvent ancestorEvent) {
        this.updateVisualState();
    }

    private void requestSecMechCBActionPerformed(ActionEvent actionEvent) {
        this.updateVisualState();
        SecurityMechanism securityMechanism = (SecurityMechanism)this.requestSecMechCB.getSelectedItem();
        if (securityMechanism.isLiberty()) {
            this.configurator.setValue((Enum)ProviderConfigurator.Configurable.SERVICE_TYPE, (Object)(URN + this.helper.getEndpointURI().get(0)));
        } else {
            this.configurator.setValue((Enum)ProviderConfigurator.Configurable.SERVICE_TYPE, null);
        }
    }

    private void enableSecurityCBActionPerformed(ActionEvent actionEvent) {
        if (this.enableSecurityCB.isSelected()) {
            this.configurator.enable();
            this.helper.setTransientState(true);
        } else {
            this.configurator.disable();
            this.helper.setTransientState(false);
        }
        this.updateVisualState();
    }
}

