/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jruby.nb.ast.IfNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.EditList;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.PreviewableFix;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ParseTreeVisitor;
import org.netbeans.modules.ruby.ParseTreeWalker;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccidentalAssignment
extends RubyAstRule {
    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.IFNODE);
    }

    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        Node node = rubyRuleContext.node;
        AstPath astPath = rubyRuleContext.path;
        CompilationInfo compilationInfo = rubyRuleContext.compilationInfo;
        IfNode ifNode = (IfNode)node;
        Node node2 = ifNode.getCondition();
        if (node2 != null) {
            Object object;
            if (node2.nodeId == NodeType.NEWLINENODE) {
                object = node2.childNodes();
                if (object.size() == 0) {
                    return;
                }
                node2 = (Node)object.get(0);
            }
            if (node2.nodeId == NodeType.LOCALASGNNODE && !this.isFirstUsage(astPath, node2) || node2.nodeId == NodeType.ATTRASSIGNNODE) {
                object = NbBundle.getMessage(AccidentalAssignment.class, (String)"AccidentalAssignment");
                OffsetRange offsetRange = AstUtilities.getRange((Node)node2);
                if ((offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange)) != OffsetRange.NONE) {
                    ArrayList<ConvertAssignmentFix> arrayList = new ArrayList<ConvertAssignmentFix>(2);
                    arrayList.add(new ConvertAssignmentFix(rubyRuleContext, node2));
                    Hint hint = new Hint((Rule)this, (String)object, compilationInfo.getFileObject(), offsetRange, arrayList, 600);
                    list.add(hint);
                }
            }
        }
    }

    private boolean isFirstUsage(AstPath astPath, Node node) {
        DeclarationFinder declarationFinder = new DeclarationFinder(node);
        Node node2 = AstUtilities.findLocalScope((Node)node, (AstPath)astPath);
        new ParseTreeWalker((ParseTreeVisitor)declarationFinder).walk(node2);
        return declarationFinder.isDeclaration();
    }

    public String getId() {
        return "AccidentalAssignment";
    }

    public String getDescription() {
        return NbBundle.getMessage(AccidentalAssignment.class, (String)"AccidentalAssignmentDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AccidentalAssignment.class, (String)"AccidentalAssignment");
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public class DeclarationFinder
    implements ParseTreeVisitor {
        private Node target;
        private Set<String> names = new HashSet<String>();
        private boolean found;

        DeclarationFinder(Node node) {
            this.target = node;
        }

        public boolean isDeclaration() {
            return !this.found;
        }

        public boolean visit(Node node) {
            String string;
            if (node == this.target && this.names.contains(string = ((INameNode)node).getName())) {
                this.found = true;
                return true;
            }
            switch (node.nodeId) {
                case LOCALVARNODE: {
                    this.names.add(((INameNode)node).getName());
                    break;
                }
                case DVARNODE: {
                    this.names.add(((INameNode)node).getName());
                }
            }
            return false;
        }

        public boolean unvisit(Node node) {
            switch (node.nodeId) {
                case LOCALASGNNODE: {
                    this.names.add(((INameNode)node).getName());
                    break;
                }
                case DASGNNODE: {
                    this.names.add(((INameNode)node).getName());
                }
            }
            return node == this.target;
        }
    }

    private static class ConvertAssignmentFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final Node assignment;

        public ConvertAssignmentFix(RubyRuleContext rubyRuleContext, Node node) {
            this.context = rubyRuleContext;
            this.assignment = node;
        }

        public String getDescription() {
            return NbBundle.getMessage(AccidentalAssignment.class, (String)"AccidentalAssignmentFix");
        }

        public void implement() throws Exception {
            EditList editList = this.getEditList();
            if (editList != null) {
                editList.apply();
            }
        }

        public EditList getEditList() throws Exception {
            int n;
            String string;
            int n2;
            BaseDocument baseDocument = this.context.doc;
            OffsetRange offsetRange = AstUtilities.getNameRange((Node)this.assignment);
            int n3 = offsetRange.getEnd();
            if (this.assignment.nodeId == NodeType.ATTRASSIGNNODE) {
                n3 = offsetRange.getStart();
            }
            if ((n2 = (string = baseDocument.getText(n3, (n = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3)) - n3)).indexOf(61)) != -1) {
                return new EditList(baseDocument).replace(n3 + n2, 0, "=", false, 0);
            }
            return null;
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

