/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jruby.nb.ast.CallNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsDeprecations
extends RubyAstRule {
    static Set<String> deprecatedFields = new HashSet<String>();
    static Map<String, String> deprecatedMethods = new HashMap<String, String>();

    public boolean appliesTo(RuleContext ruleContext) {
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        Project project = FileOwnerQuery.getOwner((FileObject)compilationInfo.getFileObject());
        return project != null && project.getClass().getName().indexOf("RailsProject") != -1;
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.ROOTNODE);
    }

    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        Node node = rubyRuleContext.node;
        CompilationInfo compilationInfo = rubyRuleContext.compilationInfo;
        AstPath astPath = rubyRuleContext.path;
        if (node == null) {
            return;
        }
        assert (astPath.leaf() == node);
        this.scan(compilationInfo, node, list);
    }

    public void cancel() {
    }

    public String getId() {
        return "Rails_Deprecations";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RailsDeprecations.class, (String)"RailsDeprecation");
    }

    public String getDescription() {
        return NbBundle.getMessage(RailsDeprecations.class, (String)"RailsDeprecationDesc");
    }

    private void scan(CompilationInfo compilationInfo, Node node, List<Hint> list) {
        Object object;
        Object object2;
        if (node.nodeId == NodeType.INSTVARNODE || node.nodeId == NodeType.INSTASGNNODE) {
            object2 = ((INameNode)node).getName();
            if (deprecatedFields.contains(object2) && !compilationInfo.getFileObject().getName().endsWith("_test")) {
                object = NbBundle.getMessage(RailsDeprecations.class, (String)"DeprecatedRailsField", (Object)object2, (Object)((String)object2).substring(1));
                this.addFix(compilationInfo, node, list, (String)object);
            }
        } else if (AstUtilities.isCall((Node)node) && deprecatedMethods.containsKey(object2 = ((INameNode)node).getName())) {
            if ("render_template".equals(object2) && compilationInfo.getFileObject().getName().endsWith("_spec")) {
                return;
            }
            if (((String)object2).startsWith("find_") && node.nodeId == NodeType.CALLNODE) {
                object = ((CallNode)node).getReceiverNode();
                if (((Node)object).nodeId != NodeType.CONSTNODE && ((Node)object).nodeId != NodeType.COLON2NODE) {
                    return;
                }
            }
            object = NbBundle.getMessage(RailsDeprecations.class, (String)"DeprecatedRailsMethodUse", (Object)object2, (Object)deprecatedMethods.get(object2));
            this.addFix(compilationInfo, node, list, (String)object);
        }
        object2 = node.childNodes();
        object = object2.iterator();
        while (object.hasNext()) {
            Node node2 = (Node)object.next();
            if (node2.isInvisible()) continue;
            this.scan(compilationInfo, node2, list);
        }
    }

    private void addFix(CompilationInfo compilationInfo, Node node, List<Hint> list, String string) {
        OffsetRange offsetRange = AstUtilities.getNameRange((Node)node);
        if ((offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange)) != OffsetRange.NONE) {
            Hint hint = new Hint((Rule)this, string, compilationInfo.getFileObject(), offsetRange, Collections.emptyList(), 100);
            list.add(hint);
        }
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    static {
        deprecatedFields.add("@params");
        deprecatedFields.add("@session");
        deprecatedFields.add("@flash");
        deprecatedFields.add("@request");
        deprecatedFields.add("@cookies");
        deprecatedFields.add("@headers");
        deprecatedFields.add("@response");
        deprecatedMethods.put("find_first", "find :first");
        deprecatedMethods.put("find_all", "find :all");
        deprecatedMethods.put("push_with_attributes", "has_many :through");
        deprecatedMethods.put("redirect_to_path", "redirect_to");
        deprecatedMethods.put("redirect_to_url", "redirect_to");
        deprecatedMethods.put("start_form_tag", "form_tag with a block");
        deprecatedMethods.put("end_form_tag", "form_tag with a block");
        deprecatedMethods.put("update_element_function", "RJS");
        deprecatedMethods.put("link_to_image", "link_to(image_tag(..), url)");
        deprecatedMethods.put("link_image_to", "link_to(image_tag(..), url)");
        deprecatedMethods.put("human_size", "number_to_human_size");
        deprecatedMethods.put("post_format", "respond_to or request.format");
        deprecatedMethods.put("formatted_post?", "respond_to or request.format");
        deprecatedMethods.put("xml_post?", "respond_to or request.format");
        deprecatedMethods.put("yaml_post?", "respond_to or request.format");
        deprecatedMethods.put("render_text", "render :text => ...");
        deprecatedMethods.put("render_template", "render :template => ...");
    }
}

