/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.junit.JUnitCfgOfCreate;
import org.netbeans.modules.junit.JUnitPluginTrampoline;
import org.netbeans.modules.junit.TestAction;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class CreateTestAction
extends TestAction {
    public CreateTestAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(CreateTestAction.class, (String)"LBL_Action_CreateTest");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateTestAction.class);
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(CreateTestAction.class, (String)"HINT_Action_CreateTest"));
    }

    protected String iconResource() {
        return "org/netbeans/modules/junit/resources/CreateTestActionIcon.gif";
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return false;
        }
        if (nodeArray.length == 1) {
            Project project;
            FileObject fileObject;
            Node node = nodeArray[0];
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject != null && (fileObject = dataObject.getPrimaryFile()) != null && fileObject.isValid() && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && CreateTestAction.getSourceGroup(fileObject, project) != null && (TestUtil.isJavaFile(fileObject) || node.getCookie(DataFolder.class) != null)) {
                JUnitPlugin jUnitPlugin = TestUtil.getPluginForProject(project);
                return JUnitPluginTrampoline.DEFAULT.canCreateTests(jUnitPlugin, fileObject);
            }
            return false;
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(nodeArray.length);
        Project project = null;
        boolean bl = false;
        for (Node node : nodeArray) {
            FileObject fileObject;
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject == null || (fileObject = dataObject.getPrimaryFile()) == null || !fileObject.isValid()) continue;
            arrayList.add(fileObject);
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project2 == null) continue;
            if (project == null) {
                project = project2;
            }
            if (project2 != project) {
                return false;
            }
            if (CreateTestAction.getSourceGroup(fileObject, project2) == null || !TestUtil.isJavaFile(fileObject) && node.getCookie(DataFolder.class) == null) continue;
            bl = true;
        }
        if (project != null) {
            JUnitPlugin jUnitPlugin = TestUtil.getPluginForProject(project);
            bl &= JUnitPluginTrampoline.DEFAULT.canCreateTests(jUnitPlugin, arrayList.toArray(new FileObject[arrayList.size()]));
        }
        return bl;
    }

    private static String checkNodesValidity(Node[] nodeArray) {
        FileObject[] fileObjectArray = CreateTestAction.getFiles(nodeArray);
        Project project = CreateTestAction.getProject(fileObjectArray);
        if (project == null) {
            return NbBundle.getMessage(CreateTestAction.class, (String)"MSG_multiproject_selection");
        }
        if (!CreateTestAction.checkPackages(fileObjectArray)) {
            return NbBundle.getMessage(CreateTestAction.class, (String)"MSG_invalid_packages");
        }
        return null;
    }

    private static boolean checkPackages(FileObject[] fileObjectArray) {
        if (fileObjectArray.length == 0) {
            return true;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObjectArray[0]);
        for (int i = 0; i < fileObjectArray.length; ++i) {
            String string = CreateTestAction.getPackage(project, fileObjectArray[i]);
            if (string != null && TestUtil.isValidPackageName(string)) continue;
            return false;
        }
        return true;
    }

    private static String getPackage(Project project, FileObject fileObject) {
        SourceGroup sourceGroup = TestUtil.findSourceGroupOwner(project, fileObject);
        if (sourceGroup != null) {
            ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{sourceGroup.getRootFolder()});
            return classPath.getResourceName(fileObject, '.', false);
        }
        return null;
    }

    private static FileObject[] getFiles(Node[] nodeArray) {
        FileObject[] fileObjectArray = new FileObject[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            fileObjectArray[i] = TestUtil.getFileObjectFromNode(nodeArray[i]);
        }
        return fileObjectArray;
    }

    private static Project getProject(FileObject[] fileObjectArray) {
        Project project = null;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObjectArray[i]);
            if (project == null) {
                project = project2;
                continue;
            }
            if (project == project2) continue;
            return null;
        }
        return project;
    }

    protected void performAction(Node[] nodeArray) {
        String string = CreateTestAction.checkNodesValidity(nodeArray);
        if (string != null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        final FileObject[] fileObjectArray = CreateTestAction.getFileObjectsFromNodes(nodeArray);
        if (fileObjectArray == null) {
            return;
        }
        final JUnitPlugin jUnitPlugin = TestUtil.getPluginForProject(FileOwnerQuery.getOwner((FileObject)fileObjectArray[0]));
        if (!JUnitPluginTrampoline.DEFAULT.createTestActionCalled(jUnitPlugin, fileObjectArray)) {
            return;
        }
        JUnitCfgOfCreate jUnitCfgOfCreate = new JUnitCfgOfCreate(nodeArray);
        if (!jUnitCfgOfCreate.configure()) {
            return;
        }
        boolean bl = jUnitCfgOfCreate.isSingleClass();
        final Map<JUnitPlugin.CreateTestParam, Object> map = TestUtil.getSettingsMap(!bl);
        if (bl) {
            map.put(JUnitPlugin.CreateTestParam.CLASS_NAME, jUnitCfgOfCreate.getTestClassName());
        }
        final FileObject fileObject = jUnitCfgOfCreate.getTargetFolder();
        jUnitCfgOfCreate = null;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                FileObject[] fileObjectArray2 = JUnitPluginTrampoline.DEFAULT.createTests(jUnitPlugin, fileObjectArray, fileObject, map);
                if (fileObjectArray2.length == 1) {
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fileObjectArray2[0]);
                        final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                        if (editorCookie != null) {
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    editorCookie.open();
                                }
                            });
                        }
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        dataObjectNotFoundException.printStackTrace();
                    }
                }
            }
        });
    }

    private static FileObject[] getFileObjectsFromNodes(Node[] nodeArray) {
        FileObject[] fileObjectArray = new FileObject[nodeArray.length];
        ArrayList<FileObject> arrayList = null;
        for (int i = 0; i < nodeArray.length; ++i) {
            FileObject fileObject;
            Node node = nodeArray[i];
            if (!CreateTestAction.hasParentAmongNodes(nodeArray, i) && (fileObject = CreateTestAction.getTestFileObject(node)) != null) {
                if (fileObjectArray != null) {
                    fileObjectArray[i] = fileObject;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<FileObject>(nodeArray.length - i);
                }
                arrayList.add(fileObject);
                continue;
            }
            fileObjectArray = null;
        }
        if (fileObjectArray == null && arrayList != null) {
            fileObjectArray = arrayList.toArray(new FileObject[arrayList.size()]);
            arrayList = null;
        }
        return fileObjectArray;
    }

    private static FileObject getTestFileObject(Node node) {
        FileObject fileObject = TestUtil.getFileObjectFromNode(node);
        if (fileObject == null) {
            TestUtil.notifyUser(NbBundle.getMessage(CreateTestAction.class, (String)"MSG_file_from_node_failed"));
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            TestUtil.notifyUser(NbBundle.getMessage(CreateTestAction.class, (String)"MSG_no_project", (Object)fileObject));
            return null;
        }
        return fileObject;
    }

    private static boolean hasParentAmongNodes(Node[] nodeArray, int n) {
        for (Node node = nodeArray[n].getParentNode(); null != node; node = node.getParentNode()) {
            for (int i = 0; i < nodeArray.length; ++i) {
                if (i == n || node != nodeArray[i]) continue;
                return true;
            }
        }
        return false;
    }
}

