/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.modules.junit.output.AntSessionInfo;
import org.netbeans.modules.junit.output.JUnitOutputReader;
import org.netbeans.modules.junit.output.TaskType;
import org.netbeans.modules.junit.output.antutils.AntProject;
import org.netbeans.modules.junit.output.antutils.TestCounter;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JUnitAntLogger
extends AntLogger {
    private static final int[] LEVELS_OF_INTEREST = new int[]{2, 1, 3};
    public static final String TASK_JAVA = "java";
    public static final String TASK_JUNIT = "junit";
    private static final String[] INTERESTING_TASKS = new String[]{"java", "junit"};
    private static final String ANT_TEST_RUNNER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner";
    private static final String XML_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter";

    public boolean interestedInSession(AntSession antSession) {
        return true;
    }

    public String[] interestedInTargets(AntSession antSession) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession antSession) {
        return INTERESTING_TASKS;
    }

    private static TaskType detectTaskType(AntEvent antEvent) {
        String string = antEvent.getTaskName();
        if (string == null) {
            return null;
        }
        if (string.equals(TASK_JUNIT)) {
            return TaskType.TEST_TASK;
        }
        if (string.equals(TASK_JAVA)) {
            TaskStructure taskStructure = antEvent.getTaskStructure();
            String string2 = taskStructure.getAttribute("classname");
            if (string2 == null) {
                return TaskType.OTHER_TASK;
            }
            if ((string2 = antEvent.evaluate(string2)).equals("junit.textui.TestRunner") || string2.startsWith("org.junit.runner.") || string2.equals(ANT_TEST_RUNNER_CLASS_NAME)) {
                TaskStructure[] taskStructureArray;
                for (TaskStructure taskStructure2 : taskStructureArray = taskStructure.getChildren()) {
                    if (!taskStructure2.getName().equals("jvmarg")) continue;
                    String string3 = taskStructure2.getAttribute("value");
                    if (string3 != null) {
                        if (!antEvent.evaluate(string3).equals("-Xdebug")) continue;
                        return TaskType.DEBUGGING_TEST_TASK;
                    }
                    string3 = taskStructure2.getAttribute("line");
                    if (string3 == null) continue;
                    for (String string4 : JUnitAntLogger.parseCmdLine(antEvent.evaluate(string3))) {
                        if (!string4.equals("-Xdebug")) continue;
                        return TaskType.DEBUGGING_TEST_TASK;
                    }
                }
                return TaskType.TEST_TASK;
            }
            return TaskType.OTHER_TASK;
        }
        assert (false) : "Unhandled task name";
        return TaskType.OTHER_TASK;
    }

    private static final List<String> parseCmdLine(String string) {
        if ((string = string.trim()).length() == 0) {
            return Collections.emptyList();
        }
        char[] cArray = string.toCharArray();
        boolean bl = true;
        for (char c : cArray) {
            if (c != ' ' && c != '\"' && c != '\'') continue;
            bl = false;
            break;
        }
        if (bl) {
            return Collections.singletonList(string);
        }
        Object object = new ArrayList(4);
        StringBuilder stringBuilder = new StringBuilder(20);
        int n = 0;
        block7: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (n) {
                case 0: {
                    if (c == '\"') {
                        n = 3;
                        continue block7;
                    }
                    if (c == '\'') {
                        n = 2;
                        continue block7;
                    }
                    if (c == ' ') continue block7;
                    stringBuilder.append(c);
                    n = 1;
                    continue block7;
                }
                case 3: {
                    if (c == '\"') {
                        n = 1;
                        continue block7;
                    }
                    stringBuilder.append(c);
                    continue block7;
                }
                case 2: {
                    if (c == '\'') {
                        n = 1;
                        continue block7;
                    }
                    stringBuilder.append(c);
                    continue block7;
                }
                case 1: {
                    if (c == '\"') {
                        n = 3;
                        continue block7;
                    }
                    if (c == '\'') {
                        n = 2;
                        continue block7;
                    }
                    if (c != ' ') continue block7;
                    object.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder(20);
                    n = 0;
                    continue block7;
                }
                default: {
                    assert (false);
                    continue block7;
                }
            }
        }
        assert (n != 0);
        object.add(stringBuilder.toString());
        return object;
    }

    private static boolean isTestTaskType(TaskType taskType) {
        return taskType != null && taskType != TaskType.OTHER_TASK;
    }

    public boolean interestedInScript(File file, AntSession antSession) {
        return true;
    }

    public int[] interestedInLogLevels(AntSession antSession) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent antEvent) {
        if (this.isTestTaskRunning(antEvent)) {
            if (antEvent.getLogLevel() != 3) {
                this.getOutputReader(antEvent).messageLogged(antEvent);
            } else {
                this.getOutputReader(antEvent).verboseMessageLogged(antEvent);
            }
        }
    }

    private boolean isTestTaskRunning(AntEvent antEvent) {
        return JUnitAntLogger.isTestTaskType(this.getSessionInfo((AntSession)antEvent.getSession()).currentTaskType);
    }

    public void taskStarted(AntEvent antEvent) {
        TaskType taskType = JUnitAntLogger.detectTaskType(antEvent);
        if (JUnitAntLogger.isTestTaskType(taskType)) {
            int n;
            AntSessionInfo antSessionInfo = this.getSessionInfo(antEvent.getSession());
            assert (!JUnitAntLogger.isTestTaskType(antSessionInfo.currentTaskType));
            antSessionInfo.timeOfTestTaskStart = System.currentTimeMillis();
            antSessionInfo.currentTaskType = taskType;
            if (antSessionInfo.sessionType == null) {
                antSessionInfo.sessionType = taskType;
            }
            try {
                n = TestCounter.getTestClassCount(antEvent);
            }
            catch (Exception exception) {
                n = 0;
                ErrorManager.getDefault().notify(4096, (Throwable)exception);
            }
            boolean bl = JUnitAntLogger.hasXmlOutput(antEvent);
            this.getOutputReader(antEvent).testTaskStarted(n, bl);
        }
    }

    public void taskFinished(AntEvent antEvent) {
        AntSessionInfo antSessionInfo = this.getSessionInfo(antEvent.getSession());
        if (JUnitAntLogger.isTestTaskType(antSessionInfo.currentTaskType)) {
            this.getOutputReader(antEvent).testTaskFinished();
            antSessionInfo.currentTaskType = null;
        }
    }

    public void buildFinished(AntEvent antEvent) {
        AntSession antSession = antEvent.getSession();
        AntSessionInfo antSessionInfo = this.getSessionInfo(antSession);
        if (JUnitAntLogger.isTestTaskType(antSessionInfo.sessionType)) {
            this.getOutputReader(antEvent).buildFinished(antEvent);
        }
        antSession.putCustomData((AntLogger)this, null);
    }

    private JUnitOutputReader getOutputReader(AntEvent antEvent) {
        assert (JUnitAntLogger.isTestTaskType(this.getSessionInfo((AntSession)antEvent.getSession()).sessionType));
        AntSession antSession = antEvent.getSession();
        AntSessionInfo antSessionInfo = this.getSessionInfo(antSession);
        JUnitOutputReader jUnitOutputReader = antSessionInfo.outputReader;
        if (jUnitOutputReader == null) {
            antSessionInfo.outputReader = jUnitOutputReader = new JUnitOutputReader(antSession, antSessionInfo.sessionType, antSessionInfo.getTimeOfTestTaskStart());
        }
        return jUnitOutputReader;
    }

    private AntSessionInfo getSessionInfo(AntSession antSession) {
        AntSessionInfo antSessionInfo;
        Object object = antSession.getCustomData((AntLogger)this);
        assert (object == null || object instanceof AntSessionInfo);
        if (object != null) {
            antSessionInfo = (AntSessionInfo)object;
        } else {
            antSessionInfo = new AntSessionInfo();
            antSession.putCustomData((AntLogger)this, (Object)antSessionInfo);
        }
        return antSessionInfo;
    }

    private static boolean hasXmlOutput(AntEvent antEvent) {
        String string = antEvent.getTaskName();
        if (string.equals(TASK_JUNIT)) {
            return JUnitAntLogger.hasXmlOutputJunit(antEvent);
        }
        if (string.equals(TASK_JAVA)) {
            return JUnitAntLogger.hasXmlOutputJava(antEvent);
        }
        assert (false);
        return false;
    }

    private static boolean hasXmlOutputJunit(AntEvent antEvent) {
        TaskStructure taskStructure = antEvent.getTaskStructure();
        for (TaskStructure taskStructure2 : taskStructure.getChildren()) {
            String string = taskStructure2.getName();
            if (!string.equals("formatter")) continue;
            String string2 = taskStructure2.getAttribute("type");
            string2 = string2 != null ? antEvent.evaluate(string2) : null;
            String string3 = taskStructure2.getAttribute("usefile");
            String string4 = string3 = string3 != null ? antEvent.evaluate(string3) : null;
            if (string2 == null || !string2.equals("xml") || string3 == null || AntProject.toBoolean(string3)) continue;
            String string5 = taskStructure2.getAttribute("if");
            String string6 = taskStructure2.getAttribute("unless");
            if (string5 != null && antEvent.getProperty(string5) == null || string6 != null && antEvent.getProperty(string6) != null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasXmlOutputJava(AntEvent antEvent) {
        TaskStructure taskStructure = antEvent.getTaskStructure();
        String string = taskStructure.getAttribute("classname");
        if (string == null || !antEvent.evaluate(string).equals(ANT_TEST_RUNNER_CLASS_NAME)) {
            return false;
        }
        for (TaskStructure taskStructure2 : taskStructure.getChildren()) {
            String string2 = taskStructure2.getName();
            if (!string2.equals("arg")) continue;
            String string3 = taskStructure2.getAttribute("value");
            if (string3 == null) {
                string3 = taskStructure2.getAttribute("line");
            }
            if (string3 == null || !(string3 = antEvent.evaluate(string3)).equals("formatter=org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter")) continue;
            return true;
        }
        return false;
    }
}

