/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.EventQueue;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Report {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());
    File antScript;
    File resultsDir;
    String suiteClassName;
    String classpath;
    ClassPath platformSources;
    Collection<FileObject> classpathSourceRoots;
    String[] outputStd;
    String[] outputErr;
    int totalTests;
    int failures;
    int errors;
    int interruptedTests;
    int elapsedTimeMillis;
    int detectedPassedTests;
    private Collection<Testcase> tests;
    private boolean hasTestsFromVerboseMsgs = false;
    private boolean suiteFinished = false;

    Report(String string) {
        if (this.LOG.isLoggable(Level.FINER)) {
            this.LOG.finer("<init>(" + string + ')');
        }
        this.suiteClassName = string;
        this.antScript = this.antScript;
        this.tests = new ArrayList<Testcase>(10);
    }

    void reportTest(Testcase testcase) {
        this.reportTest(testcase, InfoSource.TEST_REPORT);
    }

    void reportTest(Testcase testcase, InfoSource infoSource) {
        if (this.LOG.isLoggable(Level.FINER)) {
            this.LOG.finer("reportTest(" + (testcase.trouble == null ? "pass   " : (testcase.trouble.isError() ? "error  " : "failure")) + ", name: " + testcase.name + ", class: " + testcase.className + ')');
        }
        boolean bl = false;
        boolean bl2 = false;
        switch (infoSource) {
            case VERBOSE_MSG: {
                bl = true;
                bl2 = true;
                this.hasTestsFromVerboseMsgs = true;
                break;
            }
            case TEST_REPORT: {
                bl = !this.hasTestsFromVerboseMsgs || this.findTest(testcase.name, false) == null;
                break;
            }
            case XML_FILE: {
                bl = true;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (bl) {
            this.tests.add(testcase);
        }
        if (testcase.trouble == null) {
            if (bl2) {
                ++this.totalTests;
            }
            if (testcase.timeMillis == -2) {
                ++this.interruptedTests;
            } else {
                ++this.detectedPassedTests;
            }
        } else if (bl2) {
            ++this.totalTests;
            if (testcase.trouble.isError()) {
                ++this.errors;
            } else {
                ++this.failures;
            }
        }
    }

    Testcase findTest(String string) {
        return this.findTest(string, true);
    }

    private Testcase findTest(String string, boolean bl) {
        if (this.tests == null || this.tests.isEmpty()) {
            return bl ? new Testcase(string) : null;
        }
        for (Testcase testcase : this.tests) {
            if (!string.equals(testcase.name)) continue;
            return testcase;
        }
        return bl ? new Testcase(string) : null;
    }

    void markSuiteFinished() {
        this.suiteFinished = true;
    }

    boolean isSuiteFinished() {
        return this.suiteFinished;
    }

    boolean isSuiteInterrupted() {
        return !this.suiteFinished;
    }

    void update(Report report) {
        this.resultsDir = report.resultsDir;
        this.suiteClassName = report.suiteClassName;
        this.outputStd = report.outputStd;
        this.outputErr = report.outputErr;
        this.totalTests = report.totalTests;
        this.failures = report.failures;
        this.errors = report.errors;
        this.elapsedTimeMillis = report.elapsedTimeMillis;
        this.detectedPassedTests = report.detectedPassedTests;
        this.tests = report.tests;
        this.suiteFinished |= report.suiteFinished;
    }

    Collection<Testcase> getTests() {
        if (this.tests.isEmpty()) {
            List<Testcase> list = Collections.emptyList();
            return list;
        }
        return new ArrayList<Testcase>(this.tests);
    }

    boolean containsFailed() {
        assert (EventQueue.isDispatchThread());
        return this.failures + this.errors != 0;
    }

    ClassPath getSourceClassPath() {
        this.setClasspathSourceRoots();
        Collection<FileObject> collection = this.classpathSourceRoots;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        FileObject[] fileObjectArray = new FileObject[collection.size()];
        collection.toArray(fileObjectArray);
        return ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
    }

    void setClasspathSourceRoots() {
        String string;
        if (this.classpathSourceRoots != null) {
            return;
        }
        if (this.classpath == null) {
            return;
        }
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.classpath, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            FileObject[] fileObjectArray;
            FileObject[] fileObjectArray2;
            string = stringTokenizer.nextToken();
            File file = FileUtil.normalizeFile((File)new File(string));
            try {
                fileObjectArray2 = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
            if (FileUtil.isArchiveFile((URL)fileObjectArray2) && (fileObjectArray = FileUtil.getArchiveRoot((URL)fileObjectArray2)) != null) {
                fileObjectArray2 = fileObjectArray;
            }
            if ((fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)fileObjectArray2).getRoots()).length == 0) continue;
            if (fileObjectArray.length == 1) {
                linkedHashSet.add(fileObjectArray[0]);
                continue;
            }
            linkedHashSet.addAll(Arrays.asList(fileObjectArray));
        }
        if (this.platformSources != null) {
            linkedHashSet.addAll(Arrays.asList(this.platformSources.getRoots()));
        } else {
            string = JavaPlatform.getDefault();
            if (string != null) {
                linkedHashSet.addAll(Arrays.asList(string.getSourceFolders().getRoots()));
            }
        }
        this.classpathSourceRoots = linkedHashSet;
        this.classpath = null;
        this.platformSources = null;
    }

    static final class Trouble {
        static final String COMPARISON_FAILURE_JUNIT3 = "junit.framework.ComparisonFailure";
        static final String COMPARISON_FAILURE_JUNIT4 = "org.junit.ComparisonFailure";
        boolean error;
        String message;
        String exceptionClsName;
        String[] stackTrace;
        Trouble nestedTrouble;

        Trouble(boolean bl) {
            this.error = bl;
        }

        boolean isError() {
            return this.error;
        }

        boolean isComparisonFailure() {
            return this.exceptionClsName != null && (this.exceptionClsName.equals(COMPARISON_FAILURE_JUNIT3) || this.exceptionClsName.equals(COMPARISON_FAILURE_JUNIT4));
        }

        boolean isFakeError() {
            return this.error && this.isComparisonFailure();
        }
    }

    static final class Testcase {
        static final int TIME_UNKNOWN = -1;
        static final int NOT_FINISHED_YET = -2;
        String className;
        String name;
        int timeMillis;
        Trouble trouble;

        Testcase() {
        }

        Testcase(String string) {
            this.name = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InfoSource {
        VERBOSE_MSG,
        TEST_REPORT,
        XML_FILE;

    }
}

