/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grailsproject.GrailsActionProvider;
import org.netbeans.modules.groovy.grailsproject.GrailsProjectOperations;
import org.netbeans.modules.groovy.grailsproject.GrailsServerState;
import org.netbeans.modules.groovy.grailsproject.GrailsSources;
import org.netbeans.modules.groovy.grailsproject.classpath.ClassPathProviderImpl;
import org.netbeans.modules.groovy.grailsproject.classpath.SourceRoots;
import org.netbeans.modules.groovy.grailsproject.queries.GrailsProjectEncodingQueryImpl;
import org.netbeans.modules.groovy.grailsproject.ui.GrailsLogicalViewProvider;
import org.netbeans.modules.groovy.grailsproject.ui.GrailsProjectCustomizerProvider;
import org.netbeans.modules.groovy.support.spi.GroovyFeature;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;

public final class GrailsProject
implements Project {
    private final FileObject projectDir;
    private final ProjectState projectState;
    private final LogicalViewProvider logicalView;
    private final ClassPathProviderImpl cpProvider;
    private SourceRoots sourceRoots;
    private SourceRoots testRoots;
    private Lookup lookup;
    private final Logger LOG = Logger.getLogger(GrailsProject.class.getName());

    public GrailsProject(FileObject fileObject, ProjectState projectState) {
        this.projectDir = fileObject;
        this.projectState = projectState;
        this.logicalView = new GrailsLogicalViewProvider(this);
        this.cpProvider = new ClassPathProviderImpl(this.getSourceRoots(), this.getTestSourceRoots(), FileUtil.toFile((FileObject)fileObject));
    }

    public FileObject getProjectDirectory() {
        return this.projectDir;
    }

    public ProjectState getProjectState() {
        return this.projectState;
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = Lookups.fixed((Object[])new Object[]{this, this.projectState, new Info(), new GrailsActionProvider(this), GrailsSources.create(this.projectDir), new GrailsServerState(this, this.getProjectDirectory().getName()), new GrailsProjectCustomizerProvider(this), new GrailsProjectOperations(this), new GrailsProjectEncodingQueryImpl(), new OpenHook(), new AuxiliaryConfigurationImpl(), new RecommendedTemplatesImpl(), new GroovyFeatureImpl(), this.logicalView, this.cpProvider});
        }
        return this.lookup;
    }

    public synchronized SourceRoots getSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = new SourceRoots(this.projectDir);
        }
        return this.sourceRoots;
    }

    public synchronized SourceRoots getTestSourceRoots() {
        if (this.testRoots == null) {
            this.testRoots = new SourceRoots(this.projectDir);
        }
        return this.testRoots;
    }

    private static final class GroovyFeatureImpl
    implements GroovyFeature {
        private GroovyFeatureImpl() {
        }

        public boolean isGroovyEnabled() {
            return true;
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] RECOMMENDED_TYPES = new String[]{"groovy", "java-classes", "XML", "simple-files"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/Groovy/DomainClass.groovy", "Templates/Groovy/Controller.groovy", "Templates/Groovy/IntegrationTest.groovy", "Templates/Groovy/GantScript.groovy", "Templates/Groovy/Service.groovy", "Templates/Groovy/TagLib.groovy", "Templates/Groovy/UnitTest.groovy", "Templates/Other/Folder", "Templates/Other/properties.properties", "simple-files"};

        private RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return RECOMMENDED_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private static class AuxiliaryConfigurationImpl
    implements AuxiliaryConfiguration {
        private AuxiliaryConfigurationImpl() {
        }

        public Element getConfigurationFragment(String string, String string2, boolean bl) {
            return null;
        }

        public void putConfigurationFragment(Element element, boolean bl) throws IllegalArgumentException {
        }

        public boolean removeConfigurationFragment(String string, String string2, boolean bl) throws IllegalArgumentException {
            return false;
        }
    }

    private class OpenHook
    extends ProjectOpenedHook {
        private ClassPath cp;

        private OpenHook() {
        }

        protected void projectOpened() {
            org.netbeans.api.java.classpath.ClassPath[] classPathArray = GrailsProject.this.cpProvider.getProjectClassPaths("classpath/source");
            GlobalPathRegistry.getDefault().register("classpath/boot", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().register("classpath/compile", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/compile"));
            GlobalPathRegistry.getDefault().register("classpath/source", classPathArray);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (org.netbeans.api.java.classpath.ClassPath classPath : classPathArray) {
                arrayList.addAll(Arrays.asList(classPath.getRoots()));
            }
            this.cp = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[arrayList.size()]));
            org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{this.cp});
        }

        protected void projectClosed() {
            GlobalPathRegistry.getDefault().unregister("classpath/boot", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().unregister("classpath/compile", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/compile"));
            GlobalPathRegistry.getDefault().unregister("classpath/source", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/source"));
            if (this.cp != null) {
                org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistry.getDefault().unregister("classpath/source", new ClassPath[]{this.cp});
            }
        }
    }

    private final class Info
    implements ProjectInformation {
        private Info() {
        }

        public Icon getIcon() {
            Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/groovy/grails/resources/GrailsIcon16x16.png");
            return image == null ? null : new ImageIcon(image);
        }

        public String getName() {
            return GrailsProject.this.getProjectDirectory().getName();
        }

        public String getDisplayName() {
            return this.getName();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public Project getProject() {
            return GrailsProject.this;
        }
    }
}

