/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.classpath;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.groovy.grailsproject.GrailsSources;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceRoots {
    private final FileObject projectRoot;

    public SourceRoots(FileObject fileObject) {
        this.projectRoot = fileObject;
    }

    public FileObject[] getRoots() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        SourceRoots.addGrailsSourceRoots(this.projectRoot, arrayList);
        FileObject fileObject = this.projectRoot.getFileObject("plugins");
        if (fileObject != null) {
            Enumeration enumeration = fileObject.getFolders(false);
            while (enumeration.hasMoreElements()) {
                SourceRoots.addGrailsSourceRoots((FileObject)enumeration.nextElement(), arrayList);
            }
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    public List<URL> getRootURLs() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            for (FileObject fileObject : this.getRoots()) {
                arrayList.add(FileUtil.toFile((FileObject)fileObject).toURI().toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        return arrayList;
    }

    private static void addGrailsSourceRoots(FileObject fileObject, List<FileObject> list) {
        SourceRoots.addRoot(fileObject, SourceCategory.GRAILSAPP_CONF, list);
        SourceRoots.addRoot(fileObject, SourceCategory.GRAILSAPP_CONTROLLERS, list);
        SourceRoots.addRoot(fileObject, SourceCategory.GRAILSAPP_DOMAIN, list);
        SourceRoots.addRoot(fileObject, SourceCategory.GRAILSAPP_SERVICES, list);
        SourceRoots.addRoot(fileObject, SourceCategory.GRAILSAPP_TAGLIB, list);
        SourceRoots.addRoot(fileObject, SourceCategory.GRAILSAPP_UTILS, list);
        SourceRoots.addRoot(fileObject, SourceCategory.SCRIPTS, list);
        SourceRoots.addRoot(fileObject, SourceCategory.SRC_GROOVY, list);
        SourceRoots.addRoot(fileObject, SourceCategory.SRC_JAVA, list);
        SourceRoots.addRoot(fileObject, SourceCategory.TEST_INTEGRATION, list);
        SourceRoots.addRoot(fileObject, SourceCategory.TEST_UNIT, list);
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (!fileObject2.isFolder() || !VisibilityQuery.getDefault().isVisible(fileObject2) || GrailsSources.KNOWN_FOLDERS.contains(fileObject2.getName())) continue;
            list.add(fileObject2);
        }
        FileObject fileObject3 = fileObject.getFileObject("grails-app");
        if (fileObject3 != null) {
            for (FileObject fileObject4 : fileObject3.getChildren()) {
                if (!fileObject4.isFolder() || !VisibilityQuery.getDefault().isVisible(fileObject4) || GrailsSources.KNOWN_FOLDERS_IN_GRAILS_APP.contains(fileObject4.getName())) continue;
                list.add(fileObject4);
            }
        }
    }

    private static void addRoot(FileObject fileObject, SourceCategory sourceCategory, List<FileObject> list) {
        FileObject fileObject2 = fileObject.getFileObject(sourceCategory.getRelativePath());
        if (fileObject2 != null) {
            list.add(fileObject2);
        }
    }
}

