/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.GetArtifactNameStep;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.NewGrailsProjectWizardIterator;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.WizardSettingsPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class GetArtifactNamePanel
extends WizardSettingsPanel
implements DocumentListener {
    GetArtifactNameStep parentStep;
    GrailsProject project;
    String baseDir;
    private String fileName = "";
    String suffix = "";
    SourceCategory cat;
    private JLabel classNameLabel;
    private JTextField classNameTextField;
    private JLabel createdFileLabel;
    private JTextField createdFileTextField;
    private JLabel projectLabel;
    private JTextField projectTextField;

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (!Utilities.isJavaIdentifier((String)this.classNameTextField.getText().trim())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(NewGrailsProjectWizardIterator.class, (String)"GetArtifactNamePanel.NotValidIdentifier"));
            return false;
        }
        if (new File(this.createdFileTextField.getText().trim()).exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(NewGrailsProjectWizardIterator.class, (String)"GetArtifactNamePanel.FileAlreadyExists"));
            return false;
        }
        return true;
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("projectFolder", (Object)this.projectTextField.getText().trim());
    }

    public GetArtifactNamePanel(GetArtifactNameStep getArtifactNameStep, SourceCategory sourceCategory) {
        this.parentStep = getArtifactNameStep;
        this.cat = sourceCategory;
        this.initComponents();
        String string = "<unknown>";
        String string2 = "";
        String string3 = "";
        FileObject fileObject = getArtifactNameStep.project.getProjectDirectory().getFileObject(sourceCategory.getRelativePath());
        switch (sourceCategory) {
            case GRAILSAPP_DOMAIN: {
                this.setName(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"WIZARD_TITLE_DOMAIN"));
                this.setTitle(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"TXT_NewDomain"));
                string = "domain";
                string2 = "grails-app" + File.separatorChar;
                string3 = GetArtifactNamePanel.uniqueName("NewElement", this.suffix, fileObject);
                break;
            }
            case GRAILSAPP_CONTROLLERS: {
                this.setName(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"WIZARD_TITLE_CONTROLLERS"));
                this.setTitle(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"TXT_NewController"));
                string = "controllers";
                string2 = "grails-app" + File.separatorChar;
                this.suffix = "Controller";
                string3 = GetArtifactNamePanel.uniqueName("NewElement", this.suffix, fileObject);
                break;
            }
            case GRAILSAPP_SERVICES: {
                this.setName(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"WIZARD_TITLE_SERVICES"));
                this.setTitle(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"TXT_NewService"));
                string = "services";
                string2 = "grails-app" + File.separatorChar;
                this.suffix = "Service";
                string3 = GetArtifactNamePanel.uniqueName("NewElement", this.suffix, fileObject);
                break;
            }
            case GRAILSAPP_VIEWS: {
                this.setName(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"WIZARD_TITLE_VIEWS"));
                this.setTitle(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"TXT_NewView"));
                string = "views";
                string2 = "grails-app" + File.separatorChar;
                string3 = GetArtifactNamePanel.uniqueName("NewElement", this.suffix, fileObject);
                break;
            }
            case GRAILSAPP_TAGLIB: {
                this.setName(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"WIZARD_TITLE_TAGLIB"));
                this.setTitle(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"TXT_NewTaglib"));
                string = "taglib";
                string2 = "grails-app" + File.separatorChar;
                this.suffix = "TagLib";
                string3 = GetArtifactNamePanel.uniqueName("NewElement", this.suffix, fileObject);
                break;
            }
            case TEST_INTEGRATION: {
                this.setName(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"WIZARD_TITLE_INTEGRATION"));
                this.setTitle(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"TXT_NewIntegrationTest"));
                string = "integration";
                string2 = "test" + File.separatorChar;
                this.suffix = "Tests";
                string3 = GetArtifactNamePanel.uniqueName("NewElement", this.suffix, fileObject);
                break;
            }
            case TEST_UNIT: {
                this.setName(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"WIZARD_TITLE_UNIT"));
                this.setTitle(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"TXT_NewUnitTest"));
                string = "unit";
                string2 = "test" + File.separatorChar;
                this.suffix = "Tests";
                string3 = GetArtifactNamePanel.uniqueName("NewElement", this.suffix, fileObject);
                break;
            }
            case SCRIPTS: {
                this.setName(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"WIZARD_TITLE_SCRIPTS"));
                this.setTitle(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"TXT_NewScript"));
                string = "scripts";
                string3 = GetArtifactNamePanel.uniqueName("NewElement", this.suffix, fileObject);
            }
        }
        this.project = getArtifactNameStep.getGrailsProject();
        this.projectTextField.setText(this.project.getProjectDirectory().getName());
        this.baseDir = FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()) + File.separatorChar + string2 + string;
        this.createdFileTextField.setText(this.baseDir + File.separatorChar);
        this.classNameTextField.getDocument().addDocumentListener(this);
        this.classNameTextField.setText(string3);
    }

    private void initComponents() {
        this.classNameLabel = new JLabel();
        this.projectLabel = new JLabel();
        this.classNameTextField = new JTextField();
        this.projectTextField = new JTextField();
        this.createdFileLabel = new JLabel();
        this.createdFileTextField = new JTextField();
        this.classNameLabel.setDisplayedMnemonic('N');
        this.classNameLabel.setLabelFor(this.classNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.classNameLabel, (String)NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetDomainClassNamePanel.projectNameLabel.text"));
        this.projectLabel.setDisplayedMnemonic('P');
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetDomainClassNamePanel.projectFolderLabel.text"));
        this.classNameTextField.setText(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetDomainClassNamePanel.projectNameTextField.text"));
        this.projectTextField.setEditable(false);
        this.projectTextField.setText(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.projectTextField.text"));
        this.createdFileLabel.setDisplayedMnemonic('F');
        this.createdFileLabel.setLabelFor(this.createdFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFileLabel, (String)NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.createdFileLabel.text"));
        this.createdFileTextField.setEditable(false);
        this.createdFileTextField.setText(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.createdFileTextField.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.classNameLabel).add((Component)this.createdFileLabel).add((Component)this.projectLabel)).add(23, 23, 23).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.createdFileTextField, -1, 315, Short.MAX_VALUE).add((Component)this.classNameTextField, -1, 315, Short.MAX_VALUE).add((Component)this.projectTextField, -1, 315, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.classNameLabel).add((Component)this.classNameTextField, -2, -1, -2)).add(20, 20, 20).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.projectTextField, -2, -1, -2).add((Component)this.projectLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createdFileLabel).add((Component)this.createdFileTextField, -2, -1, -2)).addContainerGap(27, Short.MAX_VALUE)));
        this.classNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.classNameLabel.AccessibleContext.accessibleDescription"));
        this.projectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.projectLabel.AccessibleContext.accessibleDescription"));
        this.classNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.classNameTextField.AccessibleContext.accessibleName"));
        this.classNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.classNameTextField.AccessibleContext.accessibleDescription"));
        this.projectTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.projectTextField.AccessibleContext.accessibleName"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.projectTextField.AccessibleContext.accessibleDescription"));
        this.createdFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.createdFileLabel.AccessibleContext.accessibleDescription"));
        this.createdFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.createdFileTextField.AccessibleContext.accessibleName"));
        this.createdFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.createdFileTextField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetArtifactNamePanel.class, (String)"GetArtifactNamePanel.AccessibleContext.accessibleDescription"));
    }

    private void setTitle(String string) {
        this.putClientProperty("NewFileWizard_Title", string);
        this.getAccessibleContext().setAccessibleName(string);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.classNameTextField.getDocument()) {
            String string = this.classNameTextField.getText().trim();
            if (string.indexOf(46) != -1) {
                string = string.replace('.', File.separatorChar);
            }
            this.fileName = this.baseDir + File.separatorChar + string + this.suffix + ".groovy";
            this.createdFileTextField.setText(this.fileName);
            this.projectTextField.setText(this.project.getProjectDirectory().getName());
            this.parentStep.fireChangeEvent();
        }
    }

    public String getArtifactName() {
        return this.classNameTextField.getText().trim();
    }

    public String getFileName() {
        return this.fileName;
    }

    private static String uniqueName(String string, String string2, FileObject fileObject) {
        String string3 = string;
        if (fileObject != null) {
            FileObject fileObject2;
            int n = 0;
            while ((fileObject2 = fileObject.getFileObject(string3 + string2, "groovy")) != null) {
                string3 = string + ++n;
            }
        }
        return string3;
    }
}

