/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema;

import java.io.IOException;
import javax.swing.Action;
import javax.xml.transform.Source;
import org.netbeans.modules.xml.api.XmlFileEncodingQueryImpl;
import org.netbeans.modules.xml.refactoring.CannotRefactorException;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.refactoring.ui.ModelProvider;
import org.netbeans.modules.xml.schema.SchemaEditorSupport;
import org.netbeans.modules.xml.schema.SchemaValidateXMLCookie;
import org.netbeans.modules.xml.schema.SearchProvider;
import org.netbeans.modules.xml.schema.actions.SchemaViewOpenAction;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.multiview.SchemaMultiViewSupport;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.TransformableSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.xml.sax.InputSource;

public final class SchemaDataObject
extends MultiDataObject {
    public static final String SCHEMA_ICON_BASE_WITH_EXT = "org/netbeans/modules/xml/schema/resources/Schema_File.png";
    private static final long serialVersionUID = -8229569186860053169L;
    private transient SchemaEditorSupport schemaEditorSupport;

    public SchemaDataObject(FileObject fileObject, UniFileLoader uniFileLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)uniFileLoader);
        CookieSet cookieSet = this.getCookieSet();
        this.schemaEditorSupport = new SchemaEditorSupport(this);
        cookieSet.add((Node.Cookie)this.schemaEditorSupport);
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        cookieSet.add((Node.Cookie)new CheckXMLSupport(inputSource));
        Source source = DataObjectAdapters.source((DataObject)this);
        cookieSet.add((Node.Cookie)new TransformableSupport(source));
        cookieSet.add((Node.Cookie)new SchemaValidateXMLCookie(this));
        cookieSet.add((Node.Cookie)new SchemaMultiViewSupport(this));
        cookieSet.assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject fileObject, String string) throws IOException {
                SchemaDataObject.this.schemaEditorSupport.saveAs(fileObject, string);
            }
        }});
        cookieSet.assign(SearchProvider.class, (Object[])new SearchProvider[]{new SearchProvider((DataObject)this)});
        cookieSet.assign(XmlFileEncodingQueryImpl.class, (Object[])new XmlFileEncodingQueryImpl[]{XmlFileEncodingQueryImpl.singleton()});
    }

    public final Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public void addSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().add((Node.Cookie)saveCookie);
    }

    public void removeSaveCookie() {
        Node.Cookie cookie = this.getCookie(SaveCookie.class);
        if (cookie != null) {
            this.getCookieSet().remove(cookie);
        }
    }

    public SchemaEditorSupport getSchemaEditorSupport() {
        return this.schemaEditorSupport;
    }

    public void handleDelete() throws IOException {
        if (this.isModified()) {
            this.setModified(false);
        }
        this.getSchemaEditorSupport().getEnv().unmarkModified();
        super.handleDelete();
    }

    protected Node createNodeDelegate() {
        SchemaNode schemaNode = new SchemaNode(this);
        schemaNode.setIconBaseWithExtension(SCHEMA_ICON_BASE_WITH_EXT);
        schemaNode.setShortDescription(NbBundle.getMessage(SchemaDataObject.class, (String)"LBL_SchemaNode_desc"));
        return schemaNode;
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl) {
            this.getCookieSet().add((Node.Cookie)this.getSaveCookie());
        } else {
            this.getCookieSet().remove((Node.Cookie)this.getSaveCookie());
        }
    }

    private SaveCookie getSaveCookie() {
        return new SaveCookie(){

            public void save() throws IOException {
                SchemaDataObject.this.getSchemaEditorSupport().saveDocument();
            }

            public int hashCode() {
                return this.getClass().hashCode();
            }

            public boolean equals(Object object) {
                return object != null && this.getClass().equals(object.getClass());
            }
        };
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        SaveCookie saveCookie;
        if (this.isModified() && (saveCookie = (SaveCookie)this.getCookie(SaveCookie.class)) != null) {
            saveCookie.save();
        }
        return super.handleMove(dataFolder);
    }

    static class SchemaNode
    extends DataNode
    implements ModelProvider {
        public SchemaNode(SchemaDataObject schemaDataObject) {
            super((DataObject)schemaDataObject, Children.LEAF);
            this.getCookieSet().add((Node.Cookie)this);
        }

        public Action getPreferredAction() {
            return SystemAction.get(SchemaViewOpenAction.class);
        }

        public void setName(String string, boolean bl) {
            if (!bl || string != null && string.equals(this.getDataObject().getName())) {
                return;
            }
            SchemaModel schemaModel = this.getModel();
            try {
                SharedUtils.silentFileRefactor((Model)schemaModel, (String)string, (boolean)true);
            }
            catch (CannotRefactorException cannotRefactorException) {
                SharedUtils.showFileRenameRefactoringUI((Model)schemaModel, (String)string);
            }
            catch (IOException iOException) {
                String string2 = NbBundle.getMessage(SchemaDataObject.class, (String)"MSG_UnableToRename", (Object)iOException.getMessage());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }

        public SchemaModel getModel() {
            try {
                SchemaDataObject schemaDataObject = (SchemaDataObject)this.getDataObject();
                return schemaDataObject.getSchemaEditorSupport().getModel();
            }
            catch (IOException iOException) {
                String string = NbBundle.getMessage(SchemaDataObject.class, (String)"MSG_UnableToLoadSchema", (Object)iOException.getMessage());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return null;
            }
        }
    }
}

