/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.actions;

import java.awt.Cursor;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.schema.SchemaDataObject;
import org.netbeans.modules.xml.schema.SchemaEditorSupport;
import org.netbeans.modules.xml.schema.abe.wizard.SchemaTransformWizard;
import org.netbeans.modules.xml.schema.actions.SchemaViewOpenAction;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.basic.SchemaModelCookie;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.windows.TopComponent;

public class SchemaTransformAction
extends CookieAction {
    private static final long serialVersionUID = 1L;
    private static final Class[] COOKIE_ARRAY = new Class[]{SchemaModelCookie.class};
    private static final String EMPTY_DOC = "<schema xmlns=\"http://www.w3.org/2001/XMLSchema\"/>";
    private SchemaDataObject sdo = null;

    public SchemaTransformAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean enable(Node[] nodeArray) {
        return this.isDocumentOpen(nodeArray);
    }

    protected void performAction(final Node[] nodeArray) {
        assert (nodeArray.length == 1) : "Length of nodes array should be 1";
        final TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    topComponent.setCursor(new Cursor(3));
                    SchemaModel schemaModel = SchemaTransformAction.this.getSchemaModel(nodeArray);
                    if (schemaModel != null) {
                        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(schemaModel);
                        SchemaTransformWizard schemaTransformWizard = new SchemaTransformWizard(schemaModel);
                        schemaTransformWizard.show();
                        if (!schemaTransformWizard.isCancelled() && SchemaTransformAction.this.sdo != null) {
                            SchemaTransformAction.this.sdo.setModified(true);
                        }
                    }
                }
                catch (IOException iOException) {
                    topComponent.setCursor(new Cursor(0));
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)iOException.getMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
                finally {
                    topComponent.setCursor(new Cursor(0));
                }
            }
        });
    }

    private SchemaModel getSchemaModel(Node[] nodeArray) throws IOException {
        if (nodeArray == null || nodeArray.length == 0 || nodeArray[0] == null) {
            return null;
        }
        this.sdo = (SchemaDataObject)((Object)nodeArray[0].getLookup().lookup(SchemaDataObject.class));
        if (this.sdo == null) {
            return null;
        }
        SchemaEditorSupport schemaEditorSupport = this.sdo.getSchemaEditorSupport();
        if (schemaEditorSupport == null) {
            return null;
        }
        return schemaEditorSupport.getModel();
    }

    private boolean isDocumentOpen(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        SchemaDataObject schemaDataObject = (SchemaDataObject)((Object)nodeArray[0].getLookup().lookup(SchemaDataObject.class));
        if (schemaDataObject == null) {
            return false;
        }
        SchemaEditorSupport schemaEditorSupport = schemaDataObject.getSchemaEditorSupport();
        if (schemaEditorSupport == null) {
            return false;
        }
        return schemaEditorSupport.getOpenedPanes() != null && schemaEditorSupport.getOpenedPanes().length != 0;
    }

    public String getName() {
        return NbBundle.getMessage(SchemaViewOpenAction.class, (String)"LBL_ApplyDesignPattern_Name");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return COOKIE_ARRAY;
    }
}

