/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.wizard;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.RetrieverEngine;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.wizard.InfoCollector;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class ImportDirectory
implements Runnable {
    private String importRoot;
    private File toDir;
    private Thread myThread;
    private boolean overWriteFiles = false;
    private Utilities.DocumentTypesEnum docType;
    InfoCollector infoCollector = null;
    Map<File, File> copiedFiles = new HashMap<File, File>();
    Map<File, File> errorsWhileCopyFiles = new HashMap<File, File>();
    static final String opTabTitle = NbBundle.getMessage(ImportDirectory.class, (String)"TITLE_retriever_output_tab_title");

    private void initOPTab() {
        InputOutput inputOutput = IOProvider.getDefault().getIO(opTabTitle, false);
        OutputWriter outputWriter = inputOutput.getOut();
        inputOutput.select();
        try {
            outputWriter.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ImportDirectory(String string, File file) {
        this(string, file, false, Utilities.DocumentTypesEnum.schema);
    }

    public ImportDirectory(String string, File file, boolean bl, Utilities.DocumentTypesEnum documentTypesEnum) {
        this.importRoot = string;
        this.toDir = file;
        this.overWriteFiles = bl;
        this.docType = documentTypesEnum;
        this.initOPTab();
        this.start();
    }

    public void setOverwriteFiles(boolean bl) {
        this.overWriteFiles = bl;
    }

    public void start() {
        RequestProcessor.getDefault().post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ImportDirectory.class, (String)"LBL_PROGRESSBAR_Retrieve_XML"));
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        try {
            this.infoCollector = new InfoCollector(this.importRoot, this.docType);
            if (this.infoCollector.hasReports()) {
                if (this.infoCollector.hasErrors()) {
                    String string = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_directory_closure_error");
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                    this.opErrors();
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
                if (this.infoCollector.hasWarnings()) {
                    String string = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_absolute_resource_warning");
                    String string2 = NbBundle.getMessage(ImportDirectory.class, (String)"TITLE_absolute_resource_warning");
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, string2, 0, 2);
                    this.opWarnings();
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (confirmation.getValue() == NotifyDescriptor.Confirmation.NO_OPTION) {
                        return;
                    }
                }
            }
            this.copyFiles();
            this.showCopiedFiles();
        }
        finally {
            progressHandle.finish();
        }
        this.invokeRetrieverEngineIfRequired();
    }

    private void copyFiles() {
        List<File> list = this.infoCollector.getCopyableFileList();
        for (File file : list) {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            String string = this.toDir.toURI().toString();
            StringBuffer stringBuffer = new StringBuffer(string);
            String string2 = stringBuffer.append(file.getName()).toString();
            File file2 = null;
            try {
                file2 = new File(new URI(string2));
            }
            catch (URISyntaxException uRISyntaxException) {
                continue;
            }
            if (fileObject == null) {
                this.errorsWhileCopyFiles.put(file, file2);
                continue;
            }
            if (file2.isFile() && this.overWriteFiles) {
                file2.delete();
            }
            String string3 = file2.getName();
            string3 = string3.substring(0, string3.lastIndexOf("."));
            File file3 = file2.getParentFile();
            file3.mkdirs();
            FileObject fileObject2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file3));
            try {
                FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)string3);
            }
            catch (IOException iOException) {
                this.errorsWhileCopyFiles.put(file, file2);
                continue;
            }
            this.copiedFiles.put(file, file2);
        }
    }

    private void showCopiedFiles() {
        Object[] objectArray;
        InputOutput inputOutput = IOProvider.getDefault().getIO(opTabTitle, false);
        inputOutput.setErrSeparated(true);
        OutputWriter outputWriter = inputOutput.getErr();
        OutputWriter outputWriter2 = inputOutput.getOut();
        if (this.errorsWhileCopyFiles.size() > 0) {
            outputWriter.println(NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_errors_while_copy"));
            for (File file : this.errorsWhileCopyFiles.keySet()) {
                objectArray = new String[]{file.toString(), this.errorsWhileCopyFiles.get(file).toString()};
                outputWriter.println(NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_from_target", (Object[])objectArray));
                outputWriter.println(NbBundle.getMessage(ImportDirectory.class, (String)"MSG_POSSIBLE_CAUSE_FOR_ERROR"));
            }
        }
        outputWriter.close();
        if (this.copiedFiles.size() > 0) {
            outputWriter2.println(NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_list_of_files_ret"));
            for (File file : this.copiedFiles.keySet()) {
                objectArray = new String[]{file.toString(), this.copiedFiles.get(file).toString()};
                outputWriter2.println(NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_from_copied", (Object[])objectArray));
            }
        }
        outputWriter2.close();
    }

    private void opErrors() {
        InputOutput inputOutput = IOProvider.getDefault().getIO(opTabTitle, false);
        inputOutput.setErrSeparated(true);
        OutputWriter outputWriter = inputOutput.getErr();
        String string = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_directory_closure");
        Map<File, List<InfoCollector.InfoEntry>> map = this.infoCollector.getErrors();
        outputWriter.printf("\n%s (%d):\n", new Object[]{string, map.size()});
        for (File file : map.keySet()) {
            String string2 = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_file");
            outputWriter.printf("%s %s\n", new Object[]{string2, file.toString()});
            List<InfoCollector.InfoEntry> list = map.get(file);
            String string3 = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_overflowing_location");
            for (InfoCollector.InfoEntry infoEntry : list) {
                outputWriter.printf("    %s %s\n", new Object[]{string3, infoEntry.getChildStr()});
            }
        }
        outputWriter.close();
    }

    private void opWarnings() {
        InputOutput inputOutput = IOProvider.getDefault().getIO(opTabTitle, false);
        inputOutput.setErrSeparated(true);
        OutputWriter outputWriter = inputOutput.getErr();
        String string = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_absolute_resource");
        Map<File, List<InfoCollector.InfoEntry>> map = this.infoCollector.getWarnings();
        outputWriter.printf("\n%s (%d):\n", new Object[]{string, map.size()});
        for (File file : map.keySet()) {
            String string2 = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_file");
            outputWriter.printf("%s %s\n", new Object[]{string2, file.toString()});
            List<InfoCollector.InfoEntry> list = map.get(file);
            String string3 = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_absolute_location");
            for (InfoCollector.InfoEntry infoEntry : list) {
                outputWriter.printf("    %s %s\n", new Object[]{string3, infoEntry.getChildStr()});
            }
        }
        outputWriter.close();
    }

    private void invokeRetrieverEngineIfRequired() {
        Map<File, List<InfoCollector.InfoEntry>> map = this.infoCollector.getAbsURL2Info();
        for (File file : map.keySet()) {
            List<InfoCollector.InfoEntry> list = map.get(file);
            for (InfoCollector.InfoEntry infoEntry : list) {
                InfoCollector.InfoType infoType = infoEntry.getInfoType();
                infoEntry.getInfoType();
                if (infoType != InfoCollector.InfoType.url) continue;
                String string = infoEntry.getChildStr();
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    continue;
                }
                RetrieverEngine retrieverEngine = RetrieverEngine.getRetrieverEngine((File)this.toDir);
                RetrieveEntry retrieveEntry = null;
                retrieveEntry = new RetrieveEntry(null, uRL.toString(), file, null, Utilities.DocumentTypesEnum.schema, true);
                retrieverEngine.addResourceToRetrieve(retrieveEntry);
                retrieverEngine.start();
            }
        }
    }
}

