/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.tomcat;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Properties;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.IDESettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.SettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.providers.scripted.AbstractScriptIntegrationProvider;
import org.netbeans.modules.profiler.attach.providers.scripted.ScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.TextScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.screen.WizardScreen;
import org.netbeans.modules.profiler.attach.wizard.steps.SimpleWizardStep;
import org.netbeans.modules.profiler.j2ee.tomcat.TomcatIntegrationPanel;
import org.openide.util.NbBundle;

public abstract class AbstractTomcatIntegrationProvider
extends AbstractScriptIntegrationProvider {
    protected static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.modules.profiler.j2ee.tomcat.Bundle");
    private static final String PROFILED_TOMCAT_CONSOLE_STRING = messages.getString("TomcatIntegrationProvider_ProfiledTomcatConsoleString");
    private static final String MANUAL_REMOTE_STEP3_MSG = messages.getString("TomcatIntegrationProvider_ManualRemoteStep3Msg");
    private static final String MANUAL_REMOTE_STEP4_MSG = messages.getString("TomcatIntegrationProvider_ManualRemoteStep4Msg");
    private static final String MANUAL_REMOTE_STEP5_MSG = messages.getString("TomcatIntegrationProvider_ManualRemoteStep5Msg");
    private static final String MANUAL_REMOTE_STEP6_MSG = messages.getString("TomcatIntegrationProvider_ManualRemoteStep6Msg");
    private static final String PATH_TO_JVM_DIR_TEXT = messages.getString("TomcatIntegrationProvider_PathToJvmDirText");
    private static final String MANUAL_DIRECT_DYNAMIC_STEP1_MSG = messages.getString("TomcatIntegrationProvider_ManualDirectDynamicStep1Msg");
    private static final String MANUAL_DIRECT_STEP2_MSG = messages.getString("TomcatIntegrationProvider_ManualDirectStep2Msg");
    private static final String MANUAL_DIRECT_DYNAMIC_STEP3_MSG = messages.getString("TomcatIntegrationProvider_ManualDirectDynamicStep3Msg");
    private static final String MANUAL_DIRECT_STEP4_MSG = messages.getString("TomcatIntegrationProvider_ManualDirectStep4Msg");
    private static final String MANUAL_DYNAMIC_STEP2_MSG = messages.getString("TomcatIntegrationProvider_ManualDynamicStep2Msg");
    private static final String MANUAL_DYNAMIC_STEP4_MSG = messages.getString("TomcatIntegrationProvider_ManualDynamicStep4Msg");
    private static final String DYNAMIC_WARNING_MESSAGE = messages.getString("TomcatIntegrationProvider_DynamicWarningMessage");
    private static final String ADDITIONAL_STEPS_STEP1_DIRECT_MSG = messages.getString("TomcatIntegrationProvider_AdditionalStepsStep1DirectMsg");
    private static final String ADDITIONAL_STEPS_STEP1_DYNAMIC_MSG = messages.getString("TomcatIntegrationProvider_AdditionalStepsStep1DynamicMsg");
    private static final String ADDITIONAL_STEPS_STEP2_MSG = messages.getString("TomcatIntegrationProvider_AdditionalStepsStep2Msg");
    private static final String ADDITIONAL_STEPS_STEP3_DIRECT_MSG = messages.getString("TomcatIntegrationProvider_AdditionalStepsStep3DirectMsg");
    private static final String ADDITIONAL_STEPS_STEP3_DYNAMIC_PID_MSG = messages.getString("TomcatIntegrationProvider_AdditionalStepsStep3DynamicPidMsg");
    private static final String ADDITIONAL_STEPS_AUTO_START_MSG = messages.getString("TomcatIntegrationProvider_AdditionalStepsAutoStartMsg");
    private static final String INTEGR_REVIEW_STEP1_MSG = messages.getString("TomcatIntegrationProvider_IntegrReviewStep1Msg");
    protected static final String INTEGR_REVIEW_STEP2_MSG = messages.getString("TomcatIntegrationProvider_IntegrReviewStep2Msg");
    private static final String VALIDATION_DIRNOEXIST_MSG = messages.getString("TomcatIntegrationProvider_PathNotExistsMsg");
    private static final String VALIDATION_HOME_INVALID_MSG = messages.getString("TomcatIntegrationProvider_InvalidCatalinaHomeMsg");
    private static final String VALIDATION_BASE_INVALID_MSG = messages.getString("TomcatIntegrationProvider_InvalidCatalinaBaseMsg");
    private static final String INSERTION_POINT_NOWIN_0_STRING = "#!/bin/sh";
    private static final String INSERTION_POINT_WIN_1_STRING = "rem Guess CATALINA_HOME";
    private static final String INSERTION_POINT_NOWIN_1_STRING = "# OS specific support.";
    private static final String INSERTION_POINT_2_STRING = "Get remaining unshifted";
    private static final String CATALINA_MOD_EXT_STRING = "_nbprofiler";
    private static final String CATALINA_HOME_VAR_STRING = "CATALINA_HOME";
    private static final String CATALINA_BASE_VAR_STRING = "CATALINA_BASE";
    private SettingsPersistor persistor;
    private String catalinaBase = "";

    public AbstractTomcatIntegrationProvider() {
        this.attachedWizard = new SimpleWizardStep(NbBundle.getMessage((Class)AbstractTomcatIntegrationProvider.class, (String)"AttachWizard_LocateRequiredFilesString"), (WizardScreen)new TomcatIntegrationPanel());
        this.persistor = new IDESettingsPersistor(){

            protected String getSettingsFileName() {
                return "TomcatIntegrationProvider.properties";
            }

            protected void parsePersistableSettings(Properties properties) {
                String string = properties.getProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", "");
                if (string != null && string.length() > 0) {
                    AbstractTomcatIntegrationProvider.this.setTargetJava(string);
                } else {
                    AbstractTomcatIntegrationProvider.this.setTargetJava(TargetPlatformEnum.JDK5.toString());
                }
                AbstractTomcatIntegrationProvider.this.setInstallationPath(properties.getProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_InstallDir", ""));
                AbstractTomcatIntegrationProvider.this.setCatalinaBase(properties.getProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_BaseDir", ""));
                if (AbstractTomcatIntegrationProvider.this.getInstallationPath() == null || AbstractTomcatIntegrationProvider.this.getInstallationPath().length() == 0) {
                    AbstractTomcatIntegrationProvider.this.setInstallationPath(AbstractTomcatIntegrationProvider.this.getDefaultInstallationPath());
                }
                if (AbstractTomcatIntegrationProvider.this.getCatalinaBase() == null || AbstractTomcatIntegrationProvider.this.getCatalinaBase().length() == 0) {
                    AbstractTomcatIntegrationProvider.this.setCatalinaBase(AbstractTomcatIntegrationProvider.this.getDefaultCatalinaBase());
                }
            }

            protected Properties preparePersistableSettings() {
                Properties properties = new Properties();
                properties.setProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", AbstractTomcatIntegrationProvider.this.getTargetJava());
                properties.setProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_InstallDir", AbstractTomcatIntegrationProvider.this.getInstallationPath());
                properties.setProperty("TomcatIntegrationProvider_" + AbstractTomcatIntegrationProvider.this.getMagicNumber() + "_BaseDir", AbstractTomcatIntegrationProvider.this.getCatalinaBase());
                return properties;
            }
        };
    }

    public IntegrationProvider.IntegrationHints getAfterInstallationHints(AttachSettings attachSettings, boolean bl) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        String string = attachSettings.getHostOS();
        if (attachSettings.isDirect()) {
            integrationHints.addStep(MessageFormat.format(ADDITIONAL_STEPS_STEP1_DIRECT_MSG, this.getModifiedScriptPath(string, true)));
        } else {
            integrationHints.addStep(MessageFormat.format(ADDITIONAL_STEPS_STEP1_DYNAMIC_MSG, this.getModifiedScriptPath(string, true), ""));
        }
        integrationHints.addStep(ADDITIONAL_STEPS_STEP2_MSG);
        if (attachSettings.isDirect()) {
            integrationHints.addStep(ADDITIONAL_STEPS_STEP3_DIRECT_MSG);
        } else {
            integrationHints.addStep(ADDITIONAL_STEPS_STEP3_DYNAMIC_PID_MSG);
            integrationHints.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        }
        integrationHints.addHint(ADDITIONAL_STEPS_AUTO_START_MSG);
        return integrationHints;
    }

    public void setCatalinaBase(String string) {
        this.catalinaBase = string;
    }

    public String getCatalinaBase() {
        return this.catalinaBase;
    }

    public IntegrationProvider.IntegrationHints getIntegrationReview(AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        String string = attachSettings.getHostOS();
        integrationHints.addStep(MessageFormat.format(INTEGR_REVIEW_STEP1_MSG, this.getScriptPath(string, true), this.getModifiedScriptPath(string, true), string));
        integrationHints.addStep(MessageFormat.format(INTEGR_REVIEW_STEP2_MSG, IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + "<br>" + IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)CATALINA_HOME_VAR_STRING, (String)this.getInstallationPath()) + "<br>" + (this.catalinaBase != null && this.catalinaBase.length() > 0 ? IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)CATALINA_BASE_VAR_STRING, (String)this.catalinaBase) + "<br>" : "") + (attachSettings.isDirect() ? IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"CATALINA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)false, (int)attachSettings.getPort())) + "<br>" : "")));
        return integrationHints;
    }

    public IntegrationProvider.IntegrationHints getModificationHints(AttachSettings attachSettings) {
        String string = attachSettings.getHostOS();
        if (attachSettings.isRemote()) {
            return this.getManualRemoteIntegrationStepsInstructions(string, attachSettings);
        }
        if (attachSettings.isDirect()) {
            return this.getManualLocalDirectIntegrationStepsInstructions(string, attachSettings);
        }
        return this.getManualLocalDynamicIntegrationStepsInstructions(string, attachSettings);
    }

    public SettingsPersistor getSettingsPersistor() {
        return this.persistor;
    }

    public ValidationResult validateCatalinaBase(String string) {
        if (string == null || string.length() == 0) {
            return new ValidationResult(true);
        }
        if (!new File(string).exists()) {
            return new ValidationResult(false, VALIDATION_DIRNOEXIST_MSG);
        }
        if (!this.validateCatalinaBasePath(string)) {
            return new ValidationResult(false, VALIDATION_BASE_INVALID_MSG);
        }
        return new ValidationResult(true);
    }

    public ValidationResult validateInstallation(String string, String string2) {
        String string3 = System.getProperty("file.separator");
        String string4 = IntegrationUtils.getBatchExtensionString((String)string);
        if (!new File(string2).exists()) {
            return new ValidationResult(false, VALIDATION_DIRNOEXIST_MSG);
        }
        if (!new File(string2 + string3 + "bin" + string3 + this.getCatalinaScriptName() + string4).exists()) {
            return new ValidationResult(false, VALIDATION_HOME_INVALID_MSG);
        }
        return new ValidationResult(true);
    }

    protected boolean isBackupRequired() {
        return false;
    }

    protected abstract String getCatalinaScriptName();

    protected ScriptHeaderModifier getHeaderModifier(String string) {
        return new TextScriptHeaderModifier(IntegrationUtils.getSilentScriptCommentSign((String)string));
    }

    protected abstract int getMagicNumber();

    protected IntegrationProvider.IntegrationHints getManualLocalDirectIntegrationStepsInstructions(String string, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        integrationHints.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP1_MSG, IntegrationUtils.getEnvVariableReference((String)CATALINA_HOME_VAR_STRING, (String)string), IntegrationUtils.getDirectorySeparator((String)string), "catalina", IntegrationUtils.getBatchExtensionString((String)string)));
        integrationHints.addStep(MessageFormat.format(MANUAL_DIRECT_STEP2_MSG, this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)string), IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_HOME", (String)MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()))) + "<br>" + IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"CATALINA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort()))));
        integrationHints.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP3_MSG, this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)string)));
        integrationHints.addStep(MANUAL_DIRECT_STEP4_MSG);
        integrationHints.addHint(this.REDUCE_OVERHEAD_MSG);
        return integrationHints;
    }

    protected IntegrationProvider.IntegrationHints getManualLocalDynamicIntegrationStepsInstructions(String string, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        integrationHints.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP1_MSG, IntegrationUtils.getEnvVariableReference((String)CATALINA_HOME_VAR_STRING, (String)string), IntegrationUtils.getDirectorySeparator((String)string), this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)string)));
        integrationHints.addStep(MessageFormat.format(MANUAL_DYNAMIC_STEP2_MSG, this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)string), IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_HOME", (String)MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())))));
        integrationHints.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP3_MSG, this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)string)));
        integrationHints.addStep(MANUAL_DYNAMIC_STEP4_MSG);
        integrationHints.addHint(this.REDUCE_OVERHEAD_MSG);
        integrationHints.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        return integrationHints;
    }

    protected IntegrationProvider.IntegrationHints getManualRemoteIntegrationStepsInstructions(String string, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        integrationHints.addStep(this.getManualRemoteStep1(string));
        integrationHints.addStep(this.getManualRemoteStep2(string));
        integrationHints.addStep(MessageFormat.format(MANUAL_REMOTE_STEP3_MSG, IntegrationUtils.getEnvVariableReference((String)"REMOTE_CATALINA_HOME", (String)string), IntegrationUtils.getDirectorySeparator((String)string), this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)string)));
        integrationHints.addStep(MessageFormat.format(MANUAL_REMOTE_STEP4_MSG, this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)string), IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_HOME", (String)MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()))) + "<br>" + IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"CATALINA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())), this.REMOTE_ABSOLUTE_PATH_HINT));
        integrationHints.addStep(MessageFormat.format(MANUAL_REMOTE_STEP5_MSG, this.getCatalinaScriptName(), IntegrationUtils.getBatchExtensionString((String)string)));
        integrationHints.addStep(MANUAL_REMOTE_STEP6_MSG);
        integrationHints.addHint(this.REDUCE_OVERHEAD_MSG);
        return integrationHints;
    }

    protected String getModifiedScriptPath(String string, boolean bl) {
        return this.getCatalinaScriptPath(string, CATALINA_MOD_EXT_STRING, bl);
    }

    protected String getScriptPath(String string, boolean bl) {
        return this.getCatalinaScriptPath(string, "", bl);
    }

    protected String getWinConsoleString() {
        return PROFILED_TOMCAT_CONSOLE_STRING;
    }

    protected void generateCommands(String string, Collection collection) {
        collection.add(this.getModifiedScriptPath(string, false));
        collection.add("run");
        if (!IntegrationUtils.isWindowsPlatform((String)string) && !IntegrationUtils.PLATFORM_MAC_OS.equals(string)) {
            collection.add(">&1");
        }
    }

    protected void modifyScriptFileForDirectAttach(String string, int n, boolean bl, StringBuffer stringBuffer) {
        String string2 = IntegrationUtils.getLineBreak((String)string);
        int n2 = IntegrationUtils.isWindowsPlatform((String)string) ? stringBuffer.indexOf(INSERTION_POINT_WIN_1_STRING) : stringBuffer.indexOf(INSERTION_POINT_NOWIN_1_STRING);
        int n3 = stringBuffer.indexOf(IntegrationUtils.getScriptCommentSign((String)string) + " " + INSERTION_POINT_2_STRING);
        String string3 = IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + string2;
        String string4 = IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)CATALINA_HOME_VAR_STRING, (String)this.getInstallationPath()) + string2;
        String string5 = IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)CATALINA_BASE_VAR_STRING, (String)this.catalinaBase) + string2;
        String string6 = IntegrationUtils.getAddProfilerLibrariesToPathString((String)string, (String)this.getTargetJava(), (boolean)false, (boolean)false) + string2;
        String string7 = this.getJavaOptions(string, this.getTargetJava(), n, ' ');
        int n4 = 0;
        stringBuffer.insert(n2 + n4, string3);
        stringBuffer.insert(n2 + (n4 += string3.length()), string4);
        n4 += string4.length();
        if (this.catalinaBase != null && !"".equals(this.catalinaBase.trim())) {
            stringBuffer.insert(n2 + n4, string5);
            n4 += string5.length();
        }
        int n5 = IntegrationUtils.isWindowsPlatform((String)string) ? n3 : n2;
        stringBuffer.insert(n5 + n4, string7);
    }

    protected void modifyScriptFileForDynamicAttach(String string, int n, boolean bl, StringBuffer stringBuffer) {
        String string2 = IntegrationUtils.getLineBreak((String)string);
        int n2 = IntegrationUtils.isWindowsPlatform((String)string) ? 0 : stringBuffer.indexOf(INSERTION_POINT_NOWIN_0_STRING) + INSERTION_POINT_NOWIN_0_STRING.length() + 1;
        int n3 = IntegrationUtils.isWindowsPlatform((String)string) ? stringBuffer.indexOf(INSERTION_POINT_WIN_1_STRING) : stringBuffer.indexOf(INSERTION_POINT_NOWIN_1_STRING);
        String string3 = IntegrationUtils.getProfilerModifiedFileHeader((String)string) + string2;
        String string4 = IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + string2;
        String string5 = IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)CATALINA_HOME_VAR_STRING, (String)this.getInstallationPath()) + string2;
        String string6 = IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)CATALINA_BASE_VAR_STRING, (String)this.catalinaBase) + string2;
        int n4 = 0;
        stringBuffer.insert(n2 + n4, string3);
        stringBuffer.insert(n3 + (n4 += string3.length()), string4);
        stringBuffer.insert(n3 + (n4 += string4.length()), string5);
        n4 += string5.length();
        if (this.catalinaBase != null && !"".equals(this.catalinaBase.trim())) {
            stringBuffer.insert(n3 + n4, string6);
        }
    }

    private String getCatalinaScriptPath(String string, String string2, boolean bl) {
        String string3 = System.getProperty("file.separator");
        String string4 = IntegrationUtils.getBatchExtensionString((String)string);
        String string5 = "";
        if (IntegrationUtils.isWindowsPlatform((String)string)) {
            string5 = "\"";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getInstallationPath());
        if (!this.getInstallationPath().endsWith(string3)) {
            stringBuffer.append(string3);
        }
        stringBuffer.append("bin").append(string3).append(this.getCatalinaScriptName()).append(string2).append(string4);
        if (bl && stringBuffer.indexOf(" ") > -1) {
            stringBuffer.insert(0, string5);
            stringBuffer.append(string5);
        }
        return stringBuffer.toString();
    }

    private String getDefaultCatalinaBase() {
        String string = "";
        try {
            File file;
            String string2 = System.getenv(CATALINA_BASE_VAR_STRING);
            if (string2 != null && string2.length() > 1 && (file = new File(string2)).exists() && file.isDirectory()) {
                string = string2;
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    private String getDefaultInstallationPath() {
        String string = "";
        try {
            File file;
            String string2 = System.getenv(CATALINA_HOME_VAR_STRING);
            if (string2 != null && string2.length() > 1 && (file = new File(string2)).exists() && file.isDirectory()) {
                string = string2;
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    private String getJavaOptions(String string, String string2, int n, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (System.getProperty("org.netbeans.lib.profiler.wireprotocol.WireIO.agent") != null) {
            bl = true;
            stringBuffer.append("-Dorg.netbeans.lib.profiler.wireprotocol.WireIO=true");
        }
        if (System.getProperty("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook") != null) {
            if (bl) {
                stringBuffer.append(c);
            }
            bl = true;
            stringBuffer.append("-Dorg.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook=true");
        }
        String string3 = IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)string2, (boolean)false, (int)n);
        string3.replaceAll("\\s-", c + "-");
        if (bl) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string3);
        return IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"CATALINA_OPTS", (String)stringBuffer.toString()) + IntegrationUtils.getLineBreak((String)string);
    }

    private boolean validateCatalinaBasePath(String string) {
        String string2 = System.getProperty("file.separator");
        return new File(string + string2 + "conf" + string2 + "server.xml").exists();
    }
}

