/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateResults;
import org.netbeans.modules.versioning.util.VersioningOutputManager;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateExecutor
extends ExecutorSupport {
    private Set<File> refreshedFiles = Collections.synchronizedSet(new HashSet());
    private boolean rwUpdate;
    private boolean mergeUpdate;
    private final String contextDisplayName;
    private long updateStartTimestamp;

    public static UpdateExecutor[] splitCommand(UpdateCommand updateCommand, CvsVersioningSystem cvsVersioningSystem, GlobalOptions globalOptions, String string) {
        Command[] commandArray = new Command[]{};
        if (updateCommand.getDisplayName() == null) {
            updateCommand.setDisplayName(NbBundle.getMessage(UpdateExecutor.class, (String)"MSG_UpdateExecutor_CmdDisplayName"));
        }
        try {
            commandArray = UpdateExecutor.prepareBasicCommand((BasicCommand)updateCommand);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        UpdateExecutor[] updateExecutorArray = new UpdateExecutor[commandArray.length];
        for (int i = 0; i < commandArray.length; ++i) {
            Command command = commandArray[i];
            updateExecutorArray[i] = new UpdateExecutor(cvsVersioningSystem, (UpdateCommand)command, globalOptions, string);
        }
        return updateExecutorArray;
    }

    private UpdateExecutor(CvsVersioningSystem cvsVersioningSystem, UpdateCommand updateCommand, GlobalOptions globalOptions, String string) {
        super(cvsVersioningSystem, (Command)updateCommand, globalOptions);
        this.contextDisplayName = string;
        this.rwUpdate = globalOptions == null || !globalOptions.isDoNoChanges();
        this.mergeUpdate = updateCommand.getMergeRevision1() != null;
    }

    @Override
    protected void setup() {
        super.setup();
        this.updateStartTimestamp = System.currentTimeMillis();
    }

    @Override
    public void fileInfoGenerated(FileInfoEvent fileInfoEvent) {
        super.fileInfoGenerated(fileInfoEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commandFinished(ClientRuntime.Result result) {
        UpdateCommand updateCommand = (UpdateCommand)this.cmd;
        if (updateCommand.getGlobalOptions() == null) {
            if (!this.cmd.hasFailed()) {
                Logger.getLogger("org.netbeans.modules.versioning.system.cvss").log(Level.INFO, "Warning: Update command did not fail but global options are null.");
            }
            return;
        }
        this.cvs.setParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING, Boolean.TRUE);
        File[] fileArray = updateCommand.getFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.cache.clearVirtualDirectoryContents(fileArray[i], updateCommand.isRecursive(), updateCommand.getGlobalOptions().getExclusions());
        }
        if (this.rwUpdate && this.contextDisplayName != null) {
            this.openOutputResults();
        }
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>(2);
        boolean bl = false;
        for (DefaultFileInfoContainer defaultFileInfoContainer : this.toRefresh) {
            File file = defaultFileInfoContainer.getFile();
            if (this.refreshedFiles.contains(file)) continue;
            int n = defaultFileInfoContainer.getType().charAt(0);
            if (n == 80) {
                n = 85;
            }
            if (this.rwUpdate) {
                if (n == 85) {
                    n = this.mergeUpdate ? 77 : 65536;
                }
                if (n == 71) {
                    n = 77;
                }
                if (n == 67) {
                    bl = true;
                }
            }
            this.cache.refreshNow(file, n, true);
            this.refreshedFiles.add(file);
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (updateCommand.isRecursive()) {
                this.refreshRecursively(fileArray[i]);
            } else {
                this.refreshFlat(fileArray[i]);
            }
            this.addFileSystem(hashSet, fileArray[i]);
            if (!fileArray[i].isFile()) continue;
            this.cache.refreshCached(fileArray[i].getParentFile(), 0);
        }
        this.cvs.setParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING, null);
        if (bl) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(UpdateExecutor.class, (String)"MSG_UpdateGeneratedConflicts_Prompt"), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        for (FileSystem fileSystem : hashSet) {
            Object var11_16;
            try {
                CvsVersioningSystem.ignoreFilesystemEvents(true);
                fileSystem.refresh(true);
                var11_16 = null;
            }
            catch (Throwable throwable) {
                var11_16 = null;
                CvsVersioningSystem.ignoreFilesystemEvents(false);
                throw throwable;
            }
            CvsVersioningSystem.ignoreFilesystemEvents(false);
            {
            }
        }
        if (updateCommand.getUpdateByRevision() != null || updateCommand.isResetStickyOnes()) {
            CvsVersioningSystem.getInstance().refreshAllAnnotations();
        }
    }

    private void openOutputResults() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UpdateResults updateResults = new UpdateResults(UpdateExecutor.this.toRefresh, UpdateExecutor.this.cmd.getGlobalOptions().getCVSRoot(), UpdateExecutor.this.contextDisplayName);
                VersioningOutputManager versioningOutputManager = VersioningOutputManager.getInstance();
                versioningOutputManager.addComponent(UpdateExecutor.this.cmd.getGlobalOptions().getCVSRoot() + "-UpdateExecutor", (JComponent)updateResults);
            }
        });
    }

    private void addFileSystem(Set<FileSystem> set, File file) {
        FileObject fileObject;
        while ((fileObject = FileUtil.toFileObject((File)file)) == null) {
            if ((file = file.getParentFile()) != null) continue;
            return;
        }
        try {
            set.add(fileObject.getFileSystem());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    private void refreshRecursively(File file) {
        try {
            if (this.cvs.isIgnoredFilename(file)) {
                return;
            }
            if (this.cmd.getGlobalOptions().isExcluded(file)) {
                return;
            }
            if (file.isDirectory()) {
                if (this.cache.getStatus(file).getStatus() == 2) {
                    return;
                }
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.refreshRecursively(fileArray[i]);
                }
                if (!this.refreshedFiles.contains(file)) {
                    this.cache.refreshCached(file, 0);
                }
            } else if (!this.refreshedFiles.contains(file)) {
                this.refreshFile(file);
            }
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
    }

    private void refreshFlat(File file) {
        if (this.cvs.isIgnoredFilename(file)) {
            return;
        }
        if (this.cmd.getGlobalOptions().isExcluded(file)) {
            return;
        }
        if (this.refreshedFiles.contains(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (this.cvs.isIgnoredFilename(fileArray[i])) {
                    return;
                }
                if (this.refreshedFiles.contains(fileArray[i])) {
                    return;
                }
                if (fileArray[i].isDirectory()) continue;
                this.refreshFile(fileArray[i]);
            }
            this.cache.refreshCached(file, 0);
        } else {
            this.refreshFile(file);
        }
    }

    private void refreshFile(File file) {
        long l = file.lastModified();
        if (!this.cmd.hasFailed() && this.cache.getStatus(file.getParentFile()).getStatus() == 8 && l > 0L && l < this.updateStartTimestamp) {
            this.cache.refreshCached(file, 65536);
        } else {
            this.cache.refreshCached(file, 0);
        }
    }
}

