/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.refactoring.ui.views.PackageView;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MoveFilePanel
extends JPanel
implements ActionListener,
DocumentListener,
CustomRefactoringPanel {
    private static final ListCellRenderer GROUP_CELL_RENDERER = new GroupCellRenderer();
    private static final ListCellRenderer PROJECT_CELL_RENDERER = new ProjectCellRenderer();
    private Project project;
    private ChangeListener parent;
    private FileObject fo;
    private SourceGroup[] groups;
    private String startPackage;
    private boolean initialized = false;
    protected JPanel bottomPanel;
    private JLabel labelHeadLine;
    private JLabel labelLocation;
    private JLabel labelPackage;
    private JLabel labelProject;
    private JComboBox packageComboBox;
    private JComboBox projectsComboBox;
    private JComboBox rootComboBox;
    private JCheckBox updateReferencesCheckBox;

    public MoveFilePanel(ChangeListener changeListener, String string, String string2, FileObject fileObject) {
        this.fo = fileObject;
        this.parent = changeListener;
        this.initComponents();
        this.setCombosEnabled(true);
        this.labelHeadLine.setText(string2);
        this.rootComboBox.setRenderer(GROUP_CELL_RENDERER);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.projectsComboBox.setRenderer(PROJECT_CELL_RENDERER);
        this.rootComboBox.addActionListener(this);
        this.packageComboBox.addActionListener(this);
        this.projectsComboBox.addActionListener(this);
        Component component = this.packageComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(this);
        }
        this.project = this.fo != null ? FileOwnerQuery.getOwner((FileObject)this.fo) : OpenProjects.getDefault().getOpenProjects()[0];
        this.startPackage = string;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initValues(this.startPackage);
        this.initialized = true;
    }

    public void initValues(String string) {
        Object object;
        Object object2;
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        List<Project> list = Arrays.asList(projectArray);
        ArrayList<Project> arrayList = new ArrayList<Project>();
        SubprojectProvider subprojectProvider = (SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class);
        Set set = subprojectProvider.getSubprojects();
        Iterator iterator = set.iterator();
        arrayList.add(this.project);
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = (Project)object2;
            if (!list.contains(object)) continue;
            arrayList.add((Project)object);
        }
        object2 = arrayList.toArray(new Project[arrayList.size()]);
        Arrays.sort(object2, new ProjectByDisplayNameComparator());
        object = new DefaultComboBoxModel((E[])object2);
        this.projectsComboBox.setModel(object);
        this.projectsComboBox.setSelectedItem(this.project);
        this.updateRoots();
        this.updatePackages();
        if (string != null) {
            this.packageComboBox.setSelectedItem(string);
        }
    }

    public void requestFocus() {
        this.setCombosEnabled(true);
        this.packageComboBox.requestFocus();
    }

    public FileObject getRootFolder() {
        return ((SourceGroup)this.rootComboBox.getSelectedItem()).getRootFolder();
    }

    public String getPackageName() {
        String string = this.packageComboBox.getEditor().getItem().toString();
        return string;
    }

    private void fireChange() {
        this.parent.stateChanged(null);
    }

    private void initComponents() {
        this.labelProject = new JLabel();
        this.projectsComboBox = new JComboBox();
        this.labelLocation = new JLabel();
        this.rootComboBox = new JComboBox();
        this.labelPackage = new JLabel();
        this.packageComboBox = new JComboBox();
        this.bottomPanel = new JPanel();
        this.labelHeadLine = new JLabel();
        this.updateReferencesCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.labelProject.setLabelFor(this.projectsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelProject, (String)NbBundle.getMessage(MoveFilePanel.class, (String)"LBL_Project"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelProject, gridBagConstraints);
        this.labelProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MoveFilePanel.class, (String)"DSC_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectsComboBox, gridBagConstraints);
        this.projectsComboBox.getAccessibleContext().setAccessibleDescription("null");
        this.labelLocation.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(MoveFilePanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelLocation, gridBagConstraints);
        this.labelLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MoveFilePanel.class, (String)"DSC_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription("null");
        this.labelPackage.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelPackage, (String)NbBundle.getMessage(MoveFilePanel.class, (String)"LBL_ToPackage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelPackage, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanel, gridBagConstraints);
        this.labelHeadLine.setBorder(BorderFactory.createEmptyBorder(1, 1, 6, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.labelHeadLine, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.updateReferencesCheckBox, (String)NbBundle.getBundle(MoveFilePanel.class).getString("LBL_MoveWithoutReferences"));
        this.updateReferencesCheckBox.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.updateReferencesCheckBox.setMargin(new Insets(2, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.updateReferencesCheckBox, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.projectsComboBox == actionEvent.getSource()) {
            this.project = (Project)this.projectsComboBox.getSelectedItem();
            this.updateRoots();
            this.updatePackages();
        } else if (this.rootComboBox == actionEvent.getSource()) {
            this.updatePackages();
        } else if (this.packageComboBox == actionEvent.getSource()) {
            // empty if block
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    private void updatePackages() {
        SourceGroup sourceGroup = (SourceGroup)this.rootComboBox.getSelectedItem();
        this.packageComboBox.setModel(PackageView.createListView(sourceGroup));
    }

    void setCombosEnabled(boolean bl) {
        this.packageComboBox.setEnabled(bl);
        this.rootComboBox.setEnabled(bl);
        this.projectsComboBox.setEnabled(bl);
        this.updateReferencesCheckBox.setVisible(!bl);
    }

    public boolean isUpdateReferences() {
        return !this.updateReferencesCheckBox.isVisible() || !this.updateReferencesCheckBox.isSelected();
    }

    private void updateRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        List<String> list = SharedUtils.getSourceGroups();
        for (String string : list) {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups(string);
            if (sourceGroupArray == null) continue;
            for (SourceGroup sourceGroup : sourceGroupArray) {
                arrayList.add(sourceGroup);
            }
        }
        this.groups = arrayList.toArray(new SourceGroup[arrayList.size()]);
        int n = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.fo == null) continue;
            try {
                if (!this.groups[i].contains(this.fo)) continue;
                n = i;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        this.rootComboBox.setSelectedIndex(n);
    }

    public Component getComponent() {
        return this;
    }

    private static class ProjectByDisplayNameComparator
    implements Comparator {
        private static Comparator COLLATOR = Collator.getInstance();

        private ProjectByDisplayNameComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof Project)) {
                return 1;
            }
            if (!(object2 instanceof Project)) {
                return -1;
            }
            Project project = (Project)object;
            Project project2 = (Project)object2;
            return COLLATOR.compare(ProjectUtils.getInformation((Project)project).getDisplayName(), ProjectUtils.getInformation((Project)project2).getDisplayName());
        }
    }

    static class ProjectCellRenderer
    extends BaseCellRenderer {
        ProjectCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            if (object != null) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                this.setText(projectInformation.getDisplayName());
                this.setIcon(projectInformation.getIcon());
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    static class GroupCellRenderer
    extends BaseCellRenderer {
        GroupCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            SourceGroup sourceGroup = (SourceGroup)object;
            this.setText(sourceGroup.getDisplayName());
            this.setIcon(sourceGroup.getIcon(false));
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private static abstract class BaseCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public BaseCellRenderer() {
            this.setOpaque(true);
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }
}

