/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring.ui.views;

import java.awt.Component;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

public class PackageView {
    private PackageView() {
    }

    public static ListCellRenderer listRenderer() {
        return new PackageListCellRenderer();
    }

    public static ComboBoxModel createListView(SourceGroup sourceGroup) {
        TreeSet treeSet = new TreeSet();
        PackageView.findNonExcludedPackages(treeSet, sourceGroup.getRootFolder(), sourceGroup);
        return new DefaultComboBoxModel(new Vector(treeSet));
    }

    private static void findNonExcludedPackages(Collection collection, FileObject fileObject, SourceGroup sourceGroup) {
        assert (fileObject.isFolder()) : "Package view only accepts folders";
        if (!VisibilityQuery.getDefault().isVisible(fileObject)) {
            return;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!VisibilityQuery.getDefault().isVisible(fileObjectArray[i])) continue;
            if (fileObjectArray[i].isFolder()) {
                PackageView.findNonExcludedPackages(collection, fileObjectArray[i], sourceGroup);
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if ((bl2 || !bl) && sourceGroup != null) {
            collection.add(new PackageItem(sourceGroup, fileObject, !bl2));
        }
    }

    private static final class PackageListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof PackageItem) {
                PackageItem packageItem = (PackageItem)object;
                super.getListCellRendererComponent((JList<?>)jList, packageItem.getLabel(), n, bl, bl2);
            } else {
                String string = (String)object;
                super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
            return this;
        }
    }

    static final class PackageItem
    implements Comparable {
        private static IdentityHashMap image2icon = new IdentityHashMap();
        private final boolean empty;
        private final FileObject pkg;
        private final String pkgname;
        private Icon icon;

        public PackageItem(SourceGroup sourceGroup, FileObject fileObject, boolean bl) {
            this.pkg = fileObject;
            this.empty = bl;
            String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
            assert (string != null) : "No " + fileObject + " in " + sourceGroup;
            this.pkgname = string.replace('/', '.');
        }

        public String toString() {
            return this.pkgname;
        }

        public String getLabel() {
            return this.pkgname;
        }

        public Icon getIcon() {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.pkg);
                Node node = dataObject.getNodeDelegate();
                return new ImageIcon(node.getIcon(1));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
        }

        public int compareTo(Object object) {
            return this.pkgname.compareTo(((PackageItem)object).pkgname);
        }
    }
}

