/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.model;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.api.model.AbstractModelComponent;
import com.sun.jersey.api.model.AbstractModelVisitor;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.api.model.Parameterized;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractResourceMethod
extends AbstractMethod
implements Parameterized,
AbstractModelComponent {
    private AbstractResource resource;
    private List<MediaType> consumeMimeList;
    private List<MediaType> produceMimeList;
    private List<Parameter> parameters;
    private String httpMethod;
    private Annotation[] annotations;

    public AbstractResourceMethod(AbstractResource resource, Method method, String httpMethod, Annotation[] annotations) {
        super(method);
        this.resource = resource;
        this.httpMethod = httpMethod.toUpperCase();
        this.consumeMimeList = new ArrayList<MediaType>();
        this.produceMimeList = new ArrayList<MediaType>();
        this.parameters = new ArrayList<Parameter>();
        this.annotations = annotations;
    }

    public AbstractResource getDeclaringResource() {
        return this.resource;
    }

    public List<MediaType> getSupportedInputTypes() {
        return this.consumeMimeList;
    }

    public List<MediaType> getSupportedOutputTypes() {
        return this.produceMimeList;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void accept(AbstractModelVisitor visitor) {
        visitor.visitAbstractResourceMethod(this);
    }

    @Override
    public List<AbstractModelComponent> getComponents() {
        return null;
    }

    public String toString() {
        return "AbstractResourceMethod(" + this.getMethod().getDeclaringClass().getSimpleName() + "#" + this.getMethod().getName() + ")";
    }
}

