/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.wadl.config;

import com.sun.jersey.api.wadl.config.WadlGeneratorDescription;
import com.sun.jersey.impl.wadl.WadlGenerator;
import com.sun.jersey.impl.wadl.WadlGeneratorImpl;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WadlGeneratorLoader {
    private static final Logger LOGGER = Logger.getLogger(WadlGeneratorLoader.class.getName());

    WadlGeneratorLoader() {
    }

    static WadlGenerator loadWadlGenerators(List<WadlGenerator> wadlGenerators) throws Exception {
        WadlGenerator wadlGenerator = new WadlGeneratorImpl();
        if (wadlGenerators != null && !wadlGenerators.isEmpty()) {
            for (WadlGenerator generator : wadlGenerators) {
                generator.setWadlGeneratorDelegate(wadlGenerator);
                wadlGenerator = generator;
            }
        }
        wadlGenerator.init();
        return wadlGenerator;
    }

    static WadlGenerator loadWadlGeneratorDescriptions(WadlGeneratorDescription ... wadlGeneratorDescriptions) throws Exception {
        List<WadlGeneratorDescription> list = wadlGeneratorDescriptions != null ? Arrays.asList(wadlGeneratorDescriptions) : null;
        return WadlGeneratorLoader.loadWadlGeneratorDescriptions(list);
    }

    static WadlGenerator loadWadlGeneratorDescriptions(List<WadlGeneratorDescription> wadlGeneratorDescriptions) throws Exception {
        WadlGenerator wadlGenerator = new WadlGeneratorImpl();
        if (wadlGeneratorDescriptions != null && !wadlGeneratorDescriptions.isEmpty()) {
            for (WadlGeneratorDescription wadlGeneratorDescription : wadlGeneratorDescriptions) {
                wadlGenerator = WadlGeneratorLoader.loadWadlGenerator(wadlGeneratorDescription, wadlGenerator);
            }
        }
        wadlGenerator.init();
        return wadlGenerator;
    }

    private static WadlGenerator loadWadlGenerator(WadlGeneratorDescription wadlGeneratorDescription, WadlGenerator wadlGeneratorDelegate) throws Exception {
        LOGGER.info("Loading wadlGenerator " + wadlGeneratorDescription.getGeneratorClass().getName());
        WadlGenerator generator = wadlGeneratorDescription.getGeneratorClass().newInstance();
        generator.setWadlGeneratorDelegate(wadlGeneratorDelegate);
        if (wadlGeneratorDescription.getProperties() != null && !wadlGeneratorDescription.getProperties().isEmpty()) {
            for (Map.Entry<Object, Object> entry : wadlGeneratorDescription.getProperties().entrySet()) {
                WadlGeneratorLoader.setProperty(generator, entry.getKey().toString(), entry.getValue());
            }
        }
        return generator;
    }

    private static void setProperty(Object generator, String propertyName, Object propertyValue) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException, URISyntaxException {
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method method = WadlGeneratorLoader.getMethodByName(methodName, generator.getClass());
        if (method.getParameterTypes().length != 1) {
            throw new RuntimeException("Method " + methodName + " is no setter, it does not expect exactly one parameter, but " + method.getParameterTypes().length);
        }
        Class<?> paramClazz = method.getParameterTypes()[0];
        if (paramClazz == propertyValue.getClass()) {
            method.invoke(generator, propertyValue);
        } else if (File.class.equals(paramClazz) && propertyValue instanceof String) {
            String filename = propertyValue.toString();
            if (filename.startsWith("classpath:")) {
                String strippedFilename = filename.substring("classpath:".length());
                URL resource = generator.getClass().getResource(strippedFilename);
                if (resource == null) {
                    throw new RuntimeException("The file '" + strippedFilename + "' does not exist in the classpath." + " It's loaded by the generator class, so if you use a relative filename it's relative to" + " the generator class, otherwise you might want to load it via an absolute classpath reference like" + " classpath:/somefile.xml");
                }
                File file = new File(resource.toURI());
                method.invoke(generator, file);
            } else {
                method.invoke(generator, new File(filename));
            }
        } else {
            Constructor<?> paramTypeConstructor = paramClazz.getConstructor(propertyValue.getClass());
            if (paramTypeConstructor != null) {
                Object typedPropertyValue = paramTypeConstructor.newInstance(propertyValue);
                method.invoke(generator, typedPropertyValue);
            } else {
                throw new RuntimeException("The property '" + propertyName + "' could not be set" + " because the expected parameter is neither of type " + propertyValue.getClass() + " nor of any type that provides a constructor expecting a " + propertyValue.getClass() + "." + " The expected parameter is of type " + paramClazz.getName());
            }
        }
    }

    private static Method getMethodByName(String methodName, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new RuntimeException("Method '" + methodName + "' not found for class " + clazz.getName());
    }
}

