/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.model.parameter.multivalued;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.impl.model.parameter.multivalued.BaseStringConstructorExtractor;
import com.sun.jersey.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CollectionStringConstructorExtractor<V extends Collection>
extends BaseStringConstructorExtractor
implements MultivaluedParameterExtractor {
    final String parameter;
    final Object defaultValue;

    protected CollectionStringConstructorExtractor(Constructor c, String parameter, String defaultValueString) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        super(c);
        this.parameter = parameter;
        this.defaultValue = defaultValueString != null ? this.getValue(defaultValueString) : null;
    }

    @Override
    public Object extract(MultivaluedMap<String, String> parameters) {
        List stringList = (List)parameters.get((Object)this.parameter);
        if (stringList != null) {
            V valueList = this.getInstance();
            for (String v : stringList) {
                try {
                    valueList.add((Object)this.getValue(v));
                }
                catch (Exception e) {
                    throw new ContainerException(e);
                }
            }
            return valueList;
        }
        if (this.defaultValue != null) {
            V valueList = this.getInstance();
            valueList.add((Object)this.defaultValue);
            return valueList;
        }
        return null;
    }

    protected abstract V getInstance();

    static MultivaluedParameterExtractor getInstance(Class c, Constructor con, String parameter, String defaultValueString) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (List.class == c) {
            return new ListString(con, parameter, defaultValueString);
        }
        if (Set.class == c) {
            return new SetString(con, parameter, defaultValueString);
        }
        if (SortedSet.class == c) {
            return new SortedSetString(con, parameter, defaultValueString);
        }
        throw new RuntimeException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SortedSetString
    extends CollectionStringConstructorExtractor<SortedSet> {
        SortedSetString(Constructor c, String parameter, String defaultValueString) throws InstantiationException, IllegalAccessException, InvocationTargetException {
            super(c, parameter, defaultValueString);
        }

        @Override
        protected SortedSet getInstance() {
            return new TreeSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SetString
    extends CollectionStringConstructorExtractor<Set> {
        SetString(Constructor c, String parameter, String defaultValueString) throws InstantiationException, IllegalAccessException, InvocationTargetException {
            super(c, parameter, defaultValueString);
        }

        @Override
        protected Set getInstance() {
            return new HashSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListString
    extends CollectionStringConstructorExtractor<List> {
        ListString(Constructor c, String parameter, String defaultValueString) throws InstantiationException, IllegalAccessException, InvocationTargetException {
            super(c, parameter, defaultValueString);
        }

        @Override
        protected List getInstance() {
            return new ArrayList();
        }
    }
}

