/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.wadl;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.wadl.config.WadlGeneratorConfigLoader;
import com.sun.jersey.impl.model.method.ResourceMethod;
import com.sun.jersey.impl.uri.PathPattern;
import com.sun.jersey.impl.wadl.WadlGenerator;
import com.sun.jersey.impl.wadl.WadlMethodFactory;
import com.sun.jersey.impl.wadl.WadlResource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WadlFactory {
    private static final Logger LOGGER = Logger.getLogger(WadlFactory.class.getName());
    private final boolean _jaxb = WadlFactory.checkForJAXB();
    private final WadlGenerator _wadlGenerator;

    public WadlFactory(ResourceConfig resourceConfig) {
        this._wadlGenerator = this._jaxb ? WadlGeneratorConfigLoader.loadWadlGeneratorsFromConfig(resourceConfig) : null;
    }

    public Object createWadlResource(Set<AbstractResource> rootResources) {
        if (!this._jaxb) {
            return null;
        }
        return new WadlResource(rootResources, this._wadlGenerator);
    }

    public ResourceMethod createWadlOptionsMethod(Map<String, List<ResourceMethod>> methods, AbstractResource resource, PathPattern p) {
        if (!this._jaxb) {
            return null;
        }
        if (p == null) {
            return new WadlMethodFactory.WadlOptionsMethod(methods, resource, null, this._wadlGenerator);
        }
        String path = p.getTemplate().getTemplate().substring(1);
        return new WadlMethodFactory.WadlOptionsMethod(methods, resource, path, this._wadlGenerator);
    }

    private static boolean checkForJAXB() {
        try {
            Class.forName("javax.xml.bind.JAXBElement");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.CONFIG, "WADL generation is disabled because JAXB jars are not included in the java class path. To enable WADL include JAXB 2.x jars in the java class path.");
            return false;
        }
    }
}

