/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.dd.loaders;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.j2ee.websphere6.dd.beans.DDXmi;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.DDUtils;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class WSMultiViewDataObject
extends XmlMultiViewDataObject {
    protected WSDesignView designView;
    protected ModelSynchronizer modelSynchronizer = new ModelSynchronizer(this);
    protected boolean changedFromUI;
    protected DDXmi ddBaseBean;
    private static final long serialVersionUID = 76675745399723L;
    public static final String DD_MULTIVIEW_POSTFIX = "_multiview_design";
    public static final String MULTIVIEW_WEBBND = "webbnd";
    public static final String MULTIVIEW_WEBEXT = "webext";
    public static final String MULTIVIEW_APPBND = "appbnd";
    public static final String MULTIVIEW_APPEXT = "appext";
    public static final String MULTIVIEW_EJBBND = "ejbbnd";
    public static final String MULTIVIEW_EJBEXT = "ejbext";

    public WSMultiViewDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException, IOException {
        super(fileObject, multiFileLoader);
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkXMLSupport = new CheckXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)checkXMLSupport);
        ValidateXMLSupport validateXMLSupport = new ValidateXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)validateXMLSupport);
        try {
            this.parseDocument();
        }
        catch (IOException iOException) {
            System.out.println("ex=" + iOException);
        }
    }

    protected String getPrefixMark() {
        return null;
    }

    protected InputStream getInputStream() {
        return this.getDataCache().createInputStream();
    }

    protected void parseDocument() throws IOException {
        if (this.ddBaseBean == null) {
            this.ddBaseBean = this.getDD();
        } else {
            try {
                SAXParseException sAXParseException = DDUtils.parse(new InputSource(this.getDataCache().createReader()));
                this.setSaxError(sAXParseException);
                DDXmi dDXmi = this.createDDXmiFromDataCache();
                if (dDXmi != null) {
                    this.ddBaseBean.merge(dDXmi, 3);
                }
            }
            catch (SAXException sAXException) {
                this.setSaxError(sAXException);
            }
        }
    }

    protected abstract DesignMultiViewDesc[] getMultiViewDesc();

    public WSDesignView getDesignView() {
        return this.designView;
    }

    public void modelUpdatedFromUI() {
        this.modelSynchronizer.requestUpdateData();
    }

    public boolean isChangedFromUI() {
        return this.changedFromUI;
    }

    public void setChangedFromUI(boolean bl) {
        this.changedFromUI = bl;
    }

    public abstract DDXmi getDD() throws IOException;

    protected abstract DDXmi createDDXmiFromDataCache();

    public XmlMultiViewDataSynchronizer getModelSynchronizer() {
        return this.modelSynchronizer;
    }

    public ToolBarMultiViewElement getActiveMultiViewElement0() {
        return (ToolBarMultiViewElement)super.getActiveMultiViewElement();
    }

    protected class ModelSynchronizer
    extends XmlMultiViewDataSynchronizer {
        public ModelSynchronizer(XmlMultiViewDataObject xmlMultiViewDataObject) {
            super(xmlMultiViewDataObject, 500);
        }

        protected boolean mayUpdateData(boolean bl) {
            return true;
        }

        public void updateData(FileLock fileLock, boolean bl) {
            super.updateData(fileLock, bl);
            try {
                WSMultiViewDataObject.this.parseDocument();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.WARNING, null, iOException);
            }
        }

        protected void updateDataFromModel(Object object, FileLock fileLock, boolean bl) {
            if (object == null) {
                return;
            }
            try {
                StringWriter stringWriter = new StringWriter();
                ((DDXmi)object).write(stringWriter);
                ((Writer)stringWriter).close();
                WSMultiViewDataObject.this.getDataCache().setData(fileLock, ((Object)stringWriter).toString(), bl);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
            catch (Schema2BeansException schema2BeansException) {
                Logger.getLogger("global").log(Level.INFO, null, schema2BeansException);
            }
        }

        protected Object getModel() {
            try {
                return WSMultiViewDataObject.this.getDD();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
                return null;
            }
        }

        protected void reloadModelFromData() {
            try {
                WSMultiViewDataObject.this.parseDocument();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
    }

    protected abstract class WSDesignView
    extends DesignMultiViewDesc {
        private static final long serialVersionUID = 71111745399723L;

        protected WSDesignView(WSMultiViewDataObject wSMultiViewDataObject2) {
            super((XmlMultiViewDataObject)wSMultiViewDataObject2, "Design");
        }

        public abstract MultiViewElement createElement();

        public abstract Image getIcon();

        public abstract String preferredID();
    }
}

