/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.websphere6.WSURIManager;
import org.netbeans.modules.j2ee.websphere6.j2ee.DeploymentManagerProperties;
import org.netbeans.modules.j2ee.websphere6.ui.Instance;
import org.netbeans.modules.j2ee.websphere6.ui.InstancesModel;
import org.netbeans.modules.j2ee.websphere6.ui.ServerProperties;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ConnectionTabVisualPanel
extends JPanel {
    private final DeploymentManagerProperties targetData;
    TabServerProperties tabServerProperties = null;
    private JTextField hostField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JComboBox localInstancesCombo;
    private JPasswordField passwordField;
    private JTextField portField;
    private JTextField profilePathField;
    private JComboBox serverTypeCombo;
    private JTextField userNameField;

    public ConnectionTabVisualPanel(DeploymentManagerProperties deploymentManagerProperties) {
        int n;
        this.targetData = deploymentManagerProperties;
        this.initComponents();
        this.tabServerProperties = new TabServerProperties(this.serverTypeCombo, this.localInstancesCombo, this.profilePathField, this.hostField, this.portField);
        InstanceProperties instanceProperties = this.targetData.getInstanceProperties();
        instanceProperties.refreshServerInstance();
        String string = instanceProperties.getProperty("url");
        string = WSURIManager.getUrlWithoutPrefix(string);
        this.localInstancesCombo.setModel(new InstancesModel(TabServerProperties.getServerInstances(this.targetData.getServerRoot())));
        for (n = 0; n < this.localInstancesCombo.getModel().getSize(); ++n) {
            if (!((Instance)this.localInstancesCombo.getItemAt(n)).getDomainPath().equals(this.targetData.getDomainRoot())) continue;
            this.localInstancesCombo.setSelectedIndex(n);
            break;
        }
        n = string.indexOf(":");
        String string2 = null;
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        this.hostField.setText(string2);
        this.userNameField.setText(this.targetData.getUserName());
        this.userNameField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                String string = ConnectionTabVisualPanel.this.userNameField.getText();
                ConnectionTabVisualPanel.this.targetData.setUserName(string);
            }
        });
        this.passwordField.setText(this.targetData.getPassword());
        this.passwordField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                String string = new String(ConnectionTabVisualPanel.this.passwordField.getPassword());
                ConnectionTabVisualPanel.this.targetData.setPassword(string);
            }
        });
        this.profilePathField.setText(this.targetData.getDomainRoot());
        this.portField.setText(this.targetData.getPort());
        Vector<String> vector = new Vector<String>();
        vector.add(NbBundle.getMessage(ConnectionTabVisualPanel.class, (String)"TXT_ServerTypeLocal"));
        vector.add(NbBundle.getMessage(ConnectionTabVisualPanel.class, (String)"TXT_ServerTypeRemote"));
        this.serverTypeCombo.setModel(new InstancesModel(vector));
        this.portField.setEditable(false);
        this.hostField.setEditable(false);
        this.serverTypeCombo.setSelectedItem(this.targetData.isLocal() ? NbBundle.getMessage(ConnectionTabVisualPanel.class, (String)"TXT_ServerTypeLocal") : NbBundle.getMessage(ConnectionTabVisualPanel.class, (String)"TXT_ServerTypeRemote"));
        this.setMnemonics(this.jLabel1);
        this.setMnemonics(this.jLabel2);
        this.setMnemonics(this.jLabel3);
        this.setMnemonics(this.jLabel4);
        this.setMnemonics(this.jLabel5);
        this.setMnemonics(this.jLabel6);
        this.setMnemonics(this.jLabel7);
    }

    private void setMnemonics(JLabel jLabel) {
        String string = jLabel.getText();
        int n = Mnemonics.findMnemonicAmpersand((String)string);
        if (n < 0) {
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
            jLabel.setDisplayedMnemonic(string.charAt(0));
        } else {
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)(string.substring(0, n) + string.substring(n + 1)));
            jLabel.setDisplayedMnemonic(string.charAt(n + 1));
        }
    }

    public boolean isValid() {
        if (this.serverTypeCombo.getSelectedItem().equals(NbBundle.getMessage(ConnectionTabVisualPanel.class, (String)"TXT_ServerTypeLocal"))) {
            if (!TabServerProperties.isValidDomainRoot(this.profilePathField.getText())) {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(ConnectionTabVisualPanel.class, (String)"ERR_InvalidDomainRoot"));
                return false;
            }
        }
        if (this.hostField.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(ConnectionTabVisualPanel.class, (String)"ERR_InvalidHost"));
            return false;
        }
        if (!this.portField.getText().trim().matches("[0-9]+")) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(ConnectionTabVisualPanel.class, (String)"ERR_InvalidPort"));
            return false;
        }
        this.targetData.setDomainRoot(this.profilePathField.getText());
        this.targetData.setHost(this.hostField.getText());
        this.targetData.setPort(this.portField.getText());
        this.targetData.setUserName(this.userNameField.getText());
        this.targetData.setPassword(new String(this.passwordField.getPassword()));
        this.targetData.setIsLocal(this.serverTypeCombo.getSelectedItem().equals(NbBundle.getMessage(ConnectionTabVisualPanel.class, (String)"TXT_ServerTypeLocal")) ? "true" : "false");
        this.targetData.setServerName(((Instance)this.localInstancesCombo.getSelectedItem()).getName());
        this.targetData.setConfigXmlPath(((Instance)this.localInstancesCombo.getSelectedItem()).getConfigXmlPath());
        this.targetData.getInstanceProperties().refreshServerInstance();
        return true;
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.serverTypeCombo = new JComboBox();
        this.jLabel3 = new JLabel();
        this.localInstancesCombo = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.hostField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.userNameField = new JTextField();
        this.passwordField = new JPasswordField();
        this.profilePathField = new JTextField();
        this.jLabel1 = new JLabel();
        this.portField = new JTextField();
        this.jLabel2.setLabelFor(this.serverTypeCombo);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/ui/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)resourceBundle.getString("LBL_LocalRemote"));
        this.serverTypeCombo.setEnabled(false);
        this.jLabel3.setLabelFor(this.localInstancesCombo);
        this.jLabel3.setText(resourceBundle.getString("LBL_LocalInstances"));
        this.localInstancesCombo.setEnabled(false);
        this.jLabel4.setLabelFor(this.hostField);
        this.jLabel4.setText(resourceBundle.getString("LBL_Host"));
        this.jLabel5.setLabelFor(this.portField);
        this.jLabel5.setText(resourceBundle.getString("LBL_Port"));
        this.hostField.setEditable(false);
        this.jLabel6.setLabelFor(this.userNameField);
        this.jLabel6.setText(resourceBundle.getString("LBL_Username"));
        this.jLabel7.setLabelFor(this.passwordField);
        this.jLabel7.setText(resourceBundle.getString("LBL_Password"));
        this.profilePathField.setEditable(false);
        this.jLabel1.setLabelFor(this.profilePathField);
        this.jLabel1.setText(resourceBundle.getString("LBL_ProfilePath"));
        this.portField.setEditable(false);
        this.portField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ConnectionTabVisualPanel.this.portFieldFocusLost(focusEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel3)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel5)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel6)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel7))).add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.serverTypeCombo, -2, 90, -2).add((Component)this.profilePathField, -1, 387, Short.MAX_VALUE).add((Component)this.hostField, -1, 387, Short.MAX_VALUE).add((Component)this.localInstancesCombo, 0, 387, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add(1, (Component)this.portField).add(1, (Component)this.passwordField).add(1, (Component)this.userNameField, -1, 117, Short.MAX_VALUE)))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.serverTypeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.localInstancesCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.profilePathField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.hostField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.portField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.userNameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.passwordField, -2, -1, -2)).addContainerGap()));
        this.serverTypeCombo.getAccessibleContext().setAccessibleName(resourceBundle.getString("TTL_AccessMethod"));
        this.serverTypeCombo.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("MSG_AccessMethodDescription"));
        this.jLabel3.getAccessibleContext().setAccessibleName("Local Instances Label");
        this.localInstancesCombo.getAccessibleContext().setAccessibleName(resourceBundle.getString("TTL_LocalInstances"));
        this.localInstancesCombo.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("MSG_LocalInstances"));
        this.jLabel4.getAccessibleContext().setAccessibleName("Host Label");
        this.jLabel5.getAccessibleContext().setAccessibleName("Port Label");
        this.hostField.getAccessibleContext().setAccessibleName(resourceBundle.getString("TTL_Host"));
        this.hostField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("MSG_Host"));
        this.jLabel6.getAccessibleContext().setAccessibleName("Username Label");
        this.jLabel7.getAccessibleContext().setAccessibleName("Password Label");
        this.userNameField.getAccessibleContext().setAccessibleName(resourceBundle.getString("TTL_Username"));
        this.userNameField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("MSG_Username"));
        this.passwordField.getAccessibleContext().setAccessibleName(resourceBundle.getString("TTL_Password"));
        this.passwordField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("MSG_Password"));
        this.profilePathField.getAccessibleContext().setAccessibleName(resourceBundle.getString("TTL_ProfilePath"));
        this.profilePathField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("MSG_ProfilePath"));
        this.portField.getAccessibleContext().setAccessibleName(resourceBundle.getString("TTL_Port"));
        this.portField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("MSG_Port"));
    }

    private void portFieldFocusLost(FocusEvent focusEvent) {
        String string = this.portField.getText();
        if (!string.trim().matches("[0-9]+")) {
            JOptionPane.showMessageDialog(this.portField, NbBundle.getMessage(ConnectionTabVisualPanel.class, (String)"ERR_InvalidPort"));
        } else if (new Integer(string) > 65535) {
            JOptionPane.showMessageDialog(this.portField, NbBundle.getMessage(ConnectionTabVisualPanel.class, (String)"ERR_InvalidPort"));
        } else {
            this.targetData.setPort(string);
        }
    }

    public void updateInstancesList() {
        this.localInstancesCombo.setModel(new InstancesModel(TabServerProperties.getServerInstances(this.targetData.getServerRoot())));
        this.updateInstanceInfo();
    }

    private void updateInstanceInfo() {
        Instance instance = (Instance)this.localInstancesCombo.getSelectedItem();
        this.profilePathField.setText(instance.getDomainPath());
        this.hostField.setText(instance.getHost());
        this.portField.setText(instance.getPort());
    }

    private class InstanceSelectionListener
    implements ActionListener {
        private InstanceSelectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConnectionTabVisualPanel.this.updateInstanceInfo();
        }
    }

    private class ServerTypeActionListener
    implements ActionListener {
        private ServerTypeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ConnectionTabVisualPanel.this.serverTypeCombo.getSelectedItem().equals(NbBundle.getMessage(ServerProperties.class, (String)"TXT_ServerTypeLocal"))) {
                Instance instance = (Instance)ConnectionTabVisualPanel.this.localInstancesCombo.getSelectedItem();
                ConnectionTabVisualPanel.this.localInstancesCombo.setEnabled(true);
                ConnectionTabVisualPanel.this.profilePathField.setEnabled(true);
                ConnectionTabVisualPanel.this.profilePathField.setEditable(false);
                ConnectionTabVisualPanel.this.hostField.setEnabled(true);
                ConnectionTabVisualPanel.this.hostField.setEditable(false);
                ConnectionTabVisualPanel.this.hostField.setText(instance.getHost());
                ConnectionTabVisualPanel.this.portField.setEnabled(true);
                ConnectionTabVisualPanel.this.portField.setEditable(false);
                ConnectionTabVisualPanel.this.portField.setText(instance.getPort());
            } else {
                ConnectionTabVisualPanel.this.localInstancesCombo.setEnabled(false);
                ConnectionTabVisualPanel.this.profilePathField.setEnabled(false);
                ConnectionTabVisualPanel.this.profilePathField.setEditable(false);
                ConnectionTabVisualPanel.this.hostField.setEnabled(true);
                ConnectionTabVisualPanel.this.hostField.setEditable(false);
                ConnectionTabVisualPanel.this.portField.setEnabled(true);
                ConnectionTabVisualPanel.this.portField.setEditable(true);
            }
            ConnectionTabVisualPanel.this.isValid();
        }
    }

    public class TabServerProperties
    extends ServerProperties {
        public TabServerProperties() {
        }

        public TabServerProperties(JComboBox jComboBox, JComboBox jComboBox2, JTextField jTextField, JTextField jTextField2, JTextField jTextField3) {
            super(jComboBox, jComboBox2, jTextField, jTextField2, jTextField3);
        }

        public class TabServerTypeActionListener
        extends ServerProperties.ServerTypeActionListener {
            public TabServerTypeActionListener() {
                super(TabServerProperties.this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                super.actionPerformed(actionEvent);
                ConnectionTabVisualPanel.this.isValid();
            }
        }
    }
}

