/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.libraries;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LibraryChooserGUI
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider,
LibraryChooser.Panel {
    private final LibraryManager manager;
    private final LibraryChooser.Filter filter;
    private final ExplorerManager explorer;
    private LibraryChooser.LibraryImportHandler importHandler;
    private JButton createButton;
    private JButton importButton;
    private JLabel librariesLabel;
    private JButton manageLibrariesButton;
    private BeanTreeView tree;

    private LibraryChooserGUI(LibraryManager libraryManager, LibraryChooser.Filter filter, LibraryChooser.LibraryImportHandler libraryImportHandler) {
        if (libraryManager == null) {
            libraryManager = LibraryManager.getDefault();
        }
        this.manager = libraryManager;
        this.filter = filter;
        this.importHandler = libraryImportHandler;
        this.explorer = new ExplorerManager();
        this.initComponents();
        this.tree.setDefaultActionAllowed(false);
    }

    public static LibraryChooser.Panel createPanel(LibraryManager libraryManager, LibraryChooser.Filter filter) {
        LibraryChooserGUI libraryChooserGUI = new LibraryChooserGUI(libraryManager, filter, null);
        libraryChooserGUI.configureForEmbedded();
        return libraryChooserGUI;
    }

    public static Set<Library> showChooser(LibraryManager libraryManager, LibraryChooser.Filter filter, LibraryChooser.LibraryImportHandler libraryImportHandler, boolean bl) {
        LibraryChooserGUI libraryChooserGUI = new LibraryChooserGUI(libraryManager, filter, libraryImportHandler);
        return libraryChooserGUI.showDialog(bl);
    }

    private Set<Library> showDialog(boolean bl) {
        String string;
        String string2;
        String string3;
        String string4;
        this.manageLibrariesButton.setVisible(false);
        this.importButton.setVisible(this.manager.getLocation() != null && this.importHandler != null);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 0, 12));
        jPanel.add(this);
        if (bl) {
            string4 = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.add.title");
            string3 = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.add.button");
            string2 = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.add.button");
            string = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.add.button.a11y.desc");
        } else {
            string4 = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.import.title");
            string3 = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.import.button");
            string2 = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.import.button");
            string = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.import.button.a11y.desc");
            this.createButton.setVisible(false);
        }
        jPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.AccessibleContext.accessibleName"));
        jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.accessibleDescription"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, string4);
        dialogDescriptor.setModal(true);
        final JButton jButton = new JButton(string3);
        jButton.setEnabled(false);
        jButton.setDefaultCapable(true);
        jButton.getAccessibleContext().setAccessibleName(string2);
        jButton.getAccessibleContext().setAccessibleDescription(string);
        this.explorer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jButton.setEnabled(!LibraryChooserGUI.this.getSelectedLibraries().isEmpty());
            }
        });
        dialogDescriptor.setOptions(new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION});
        dialogDescriptor.setClosingOptions(new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION});
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == jButton) {
            Set<Library> set = this.getSelectedLibraries();
            assert (!set.isEmpty());
            return set;
        }
        return null;
    }

    private void configureForEmbedded() {
        this.explorer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LibraryChooserGUI.this.firePropertyChange("selectedLibraries", null, null);
            }
        });
        this.createButton.setVisible(false);
        this.importButton.setVisible(false);
    }

    @Override
    public Set<Library> getSelectedLibraries() {
        HashSet<Library> hashSet = new HashSet<Library>();
        for (Node node : this.explorer.getSelectedNodes()) {
            Library library = (Library)node.getLookup().lookup(Library.class);
            if (library == null) {
                return Collections.emptySet();
            }
            hashSet.add(library);
        }
        return hashSet;
    }

    @Override
    public Component getVisualComponent() {
        return this;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorer;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(LibraryChooserGUI.class);
    }

    private void setRootNode() {
        this.explorer.setRootContext((Node)new AbstractNode((Children)new LibraryManagerChildren()));
        this.tree.expandAll();
        try {
            if (this.explorer.getRootContext().getChildren().getNodes(true).length > 0) {
                this.explorer.setSelectedNodes(new Node[]{this.explorer.getRootContext().getChildren().getNodes(true)[0]});
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            Exceptions.printStackTrace((Throwable)propertyVetoException);
        }
        this.tree.requestFocus();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setRootNode();
    }

    private void initComponents() {
        this.librariesLabel = new JLabel();
        this.tree = new BeanTreeView();
        this.createButton = new JButton();
        this.importButton = new JButton();
        this.manageLibrariesButton = new JButton();
        this.librariesLabel.setLabelFor((Component)this.tree);
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.librariesLabel"));
        this.tree.setBorder(BorderFactory.createEtchedBorder());
        this.tree.setPopupAllowed(false);
        this.tree.setRootVisible(false);
        Mnemonics.setLocalizedText((AbstractButton)this.createButton, (String)NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.createButton.text"));
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryChooserGUI.this.createButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.importButton, (String)NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.importButton.text"));
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryChooserGUI.this.importButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.manageLibrariesButton, (String)NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.manageLibrariesButton.text"));
        this.manageLibrariesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryChooserGUI.this.manageLibrariesButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.librariesLabel).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.tree, -1, 249, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.createButton).add((Component)this.importButton))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.manageLibrariesButton).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.librariesLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.createButton).addPreferredGap(0).add((Component)this.importButton)).add((Component)this.tree, -1, 284, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.manageLibrariesButton)));
        this.librariesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"ACSD_AvailableLibraries"));
        this.tree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"ACSD_AvailableLibrariesTree"));
        this.createButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.create.a11y.name"));
        this.createButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.create.a11y.desc"));
        this.importButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.import.a11y.name"));
        this.importButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.import.a11y.desc"));
        this.manageLibrariesButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"ACSD_ManageLibraries"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.accessibleDescription"));
    }

    private void manageLibrariesButtonActionPerformed(ActionEvent actionEvent) {
        if (LibrariesCustomizer.showCustomizer(null, this.manager)) {
            this.setRootNode();
        }
    }

    private void createButtonActionPerformed(ActionEvent actionEvent) {
        Library library = LibrariesCustomizer.showCreateNewLibraryCustomizer(this.manager);
        if (library != null) {
            this.setRootNode();
            this.selectLibrary(Collections.singleton(library));
        }
    }

    private void selectLibrary(Collection<Library> collection) {
        Node node = this.explorer.getRootContext();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Library library : collection) {
            String[] stringArray = new String[]{library.getManager().getDisplayName(), library.getName()};
            try {
                Node node2 = NodeOp.findPath((Node)node, (String[])stringArray);
                if (node2 == null) continue;
                arrayList.add(node2);
            }
            catch (NodeNotFoundException nodeNotFoundException) {}
        }
        try {
            this.explorer.setSelectedNodes(arrayList.toArray(new Node[arrayList.size()]));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void importButtonActionPerformed(ActionEvent actionEvent) {
        Set<Library> set = LibraryChooserGUI.showChooser(LibraryManager.getDefault(), new IgnoreAlreadyImportedLibrariesFilter(), null, false);
        if (set != null) {
            HashSet<Library> hashSet = new HashSet<Library>();
            try {
                for (Library library : set) {
                    hashSet.add(this.importHandler.importLibrary(library));
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            this.setRootNode();
            this.selectLibrary(hashSet);
        }
    }

    private class IgnoreAlreadyImportedLibrariesFilter
    implements LibraryChooser.Filter {
        private IgnoreAlreadyImportedLibrariesFilter() {
        }

        public boolean accept(Library library) {
            return LibraryChooserGUI.this.manager.getLibrary(library.getName()) == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LibraryChildren
    extends Children.Keys<Library> {
        LibraryChildren(List<Library> list) {
            this.setKeys(list);
        }

        protected Node[] createNodes(Library library) {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF, Lookups.singleton((Object)library));
            abstractNode.setName(library.getName());
            abstractNode.setDisplayName(library.getDisplayName());
            abstractNode.setShortDescription(library.getDescription());
            abstractNode.setIconBaseWithExtension("org/netbeans/modules/project/libraries/resources/libraries.gif");
            return new Node[]{abstractNode};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LibraryManagerChildren
    extends Children.Keys<LibraryManager> {
        private LibraryManagerChildren() {
        }

        protected void addNotify() {
            super.addNotify();
            if (LibraryChooserGUI.this.manager != null) {
                this.setKeys(Collections.singleton(LibraryChooserGUI.this.manager));
            }
        }

        protected Node[] createNodes(LibraryManager libraryManager) {
            ArrayList<Library> arrayList = new ArrayList<Library>();
            for (Library library : libraryManager.getLibraries()) {
                if (LibraryChooserGUI.this.filter != null && !LibraryChooserGUI.this.filter.accept(library)) continue;
                arrayList.add(library);
            }
            if (arrayList.isEmpty()) {
                return new Node[0];
            }
            Collections.sort(arrayList, new Comparator<Library>(){
                Collator COLL = Collator.getInstance();

                @Override
                public int compare(Library library, Library library2) {
                    return this.COLL.compare(library.getDisplayName(), library2.getDisplayName());
                }
            });
            AbstractNode abstractNode = new AbstractNode((Children)new LibraryChildren(arrayList)){
                Node iconDelegate;
                {
                    this.iconDelegate = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
                }

                public Image getIcon(int n) {
                    return this.iconDelegate.getIcon(n);
                }

                public Image getOpenedIcon(int n) {
                    return this.iconDelegate.getOpenedIcon(n);
                }
            };
            abstractNode.setName(libraryManager.getDisplayName());
            abstractNode.setDisplayName(libraryManager.getDisplayName());
            return new Node[]{abstractNode};
        }
    }
}

