/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Mutex;

public class SourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation {
    private Map<URL, Reference<SourceForBinaryQuery.Result>> url2Result = new WeakHashMap<URL, Reference<SourceForBinaryQuery.Result>>();
    private Map<SourceForBinaryQuery.Result, URL> result2URL = new WeakHashMap<SourceForBinaryQuery.Result, URL>();

    public SourceForBinaryQuery.Result findSourceRoots(final URL uRL) {
        return (SourceForBinaryQuery.Result)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceForBinaryQuery.Result>(){

            public SourceForBinaryQuery.Result run() {
                return SourceForBinaryQueryImpl.this.findSourceRootsImpl(uRL);
            }
        });
    }

    private synchronized SourceForBinaryQuery.Result findSourceRootsImpl(URL uRL) {
        SourceForBinaryQuery.Result result;
        Reference<SourceForBinaryQuery.Result> reference = this.url2Result.get(uRL);
        SourceForBinaryQuery.Result result2 = result = reference != null ? reference.get() : null;
        if (result != null) {
            return result;
        }
        String string = uRL.toExternalForm();
        URL[] uRLArray = null;
        if (string.startsWith("jar:file:")) {
            FileObject fileObject;
            uRLArray = this.checkForBinaryRoot(string, "/libs.javacapi/external/javac-api");
            if (uRLArray == null) {
                uRLArray = this.checkForBinaryRoot(string, "/libs.javacimpl/external/javac-impl");
            }
            FileObject fileObject2 = fileObject = uRLArray != null ? URLMapper.findFileObject((URL)uRLArray[0]) : null;
            if (fileObject != null) {
                FileObject fileObject3;
                FileObject fileObject4 = fileObject3 = uRLArray != null ? URLMapper.findFileObject((URL)uRLArray[1]) : null;
                if (fileObject3 != null) {
                    try {
                        ProjectManager.getDefault().findProject(fileObject3);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(SourceForBinaryQueryImpl.class.getName()).log(Level.FINE, null, iOException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logger.getLogger(SourceForBinaryQueryImpl.class.getName()).log(Level.FINE, null, illegalArgumentException);
                    }
                }
                SourceForBinaryQuery.Result result3 = new SourceForBinaryQuery.Result(){

                    public FileObject[] getRoots() {
                        return new FileObject[]{fileObject};
                    }

                    public void addChangeListener(ChangeListener changeListener) {
                    }

                    public void removeChangeListener(ChangeListener changeListener) {
                    }
                };
                this.url2Result.put(uRL, new WeakReference<2>(result3));
                this.result2URL.put(result3, uRL);
                return result3;
            }
        }
        return null;
    }

    private URL[] checkForBinaryRoot(String string, String string2) {
        if (string.endsWith(string2 + "-nb-7.0-b07.jar!/")) {
            try {
                String string3 = string.substring("jar:".length(), string.length() - string2.length() - "-nb-7.0-b07.jar!/".length());
                return new URL[]{new URL(string3 + "/nb-javac/src/share/classes"), new URL(string3 + "/nb-javac/make/netbeans/nb-javac")};
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger("global").log(Level.INFO, null, malformedURLException);
            }
        }
        return null;
    }
}

