/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofFieldValue;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LoadClass;

class ClassDump
extends HprofObject
implements JavaClass {
    final ClassDumpSegment classDumpSegment;
    private int instances;
    private long loadClassOffset;
    static final /* synthetic */ boolean $assertionsDisabled;

    ClassDump(ClassDumpSegment classDumpSegment, long l) {
        super(l);
        this.classDumpSegment = classDumpSegment;
        if (!$assertionsDisabled && this.getHprofBuffer().get(l) != 32) {
            throw new AssertionError();
        }
    }

    public int getAllInstancesSize() {
        if (this.isArray()) {
            return (Integer)this.classDumpSegment.arrayMap.get(this);
        }
        return this.getInstancesCount() * this.getInstanceSize();
    }

    public boolean isArray() {
        return this.classDumpSegment.arrayMap.get(this) != null;
    }

    public Instance getClassLoader() {
        long l = this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.classLoaderIDOffset);
        return this.getHprof().getInstanceByID(l);
    }

    public Field getField(String string) {
        Iterator iterator = this.getFields().iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!field.getName().equals(string)) continue;
            return field;
        }
        return null;
    }

    public List getFields() {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        long l = this.fileOffset + (long)this.getInstanceFieldOffset();
        int n = hprofByteBuffer.getShort(l);
        ArrayList<HprofField> arrayList = new ArrayList<HprofField>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new HprofField(this, l + 2L + (long)(i * this.classDumpSegment.fieldSize)));
        }
        return arrayList;
    }

    public int getInstanceSize() {
        if (this.isArray()) {
            return -1;
        }
        return this.classDumpSegment.getMinimumInstanceSize() + this.getHprofBuffer().getInt(this.fileOffset + (long)this.classDumpSegment.instanceSizeOffset);
    }

    public List getInstances() {
        return this.getHprof().computeInstances(this);
    }

    public int getInstancesCount() {
        if (this.instances == 0) {
            this.getHprof().computeInstances();
        }
        return this.instances;
    }

    public long getJavaClassId() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.classIDOffset);
    }

    public String getName() {
        return this.getLoadClass().getName();
    }

    public List getStaticFieldValues() {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        long l = this.fileOffset + (long)this.getStaticFieldOffset();
        HprofHeap hprofHeap = this.getHprof();
        int n = hprofByteBuffer.getShort(l);
        l += 2L;
        ArrayList<HprofFieldObjectValue> arrayList = new ArrayList<HprofFieldObjectValue>(n);
        for (int i = 0; i < n; ++i) {
            byte by = hprofByteBuffer.get(l + (long)this.classDumpSegment.fieldTypeOffset);
            int n2 = this.classDumpSegment.fieldSize + hprofHeap.getValueSize(by);
            HprofFieldValue hprofFieldValue = by == 2 ? new HprofFieldObjectValue(this, l) : new HprofFieldValue(this, l);
            arrayList.add((HprofFieldObjectValue)hprofFieldValue);
            l += (long)n2;
        }
        return arrayList;
    }

    public Collection getSubClasses() {
        List list = this.classDumpSegment.hprofHeap.getAllClasses();
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>(list.size() / 10);
        HashMap<ClassDump, Boolean> hashMap = new HashMap<ClassDump, Boolean>(list.size() * 4 / 3);
        hashMap.put(this, Boolean.TRUE);
        for (int i = 0; i < list.size(); ++i) {
            JavaClass javaClass = (JavaClass)list.get(i);
            Boolean bl = (Boolean)hashMap.get(javaClass);
            if (bl == null) {
                bl = ClassDump.isSubClass(javaClass, hashMap);
            }
            if (bl != Boolean.TRUE || javaClass == this) continue;
            arrayList.add(javaClass);
        }
        return arrayList;
    }

    public JavaClass getSuperClass() {
        long l = this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.superClassIDOffset);
        return this.classDumpSegment.getClassDumpByID(l);
    }

    public Object getValueOfStaticField(String string) {
        Iterator iterator = this.getStaticFieldValues().iterator();
        while (iterator.hasNext()) {
            FieldValue fieldValue = (FieldValue)iterator.next();
            if (!fieldValue.getField().getName().equals(string)) continue;
            if (fieldValue instanceof HprofFieldObjectValue) {
                return ((HprofFieldObjectValue)fieldValue).getInstance();
            }
            return ((HprofFieldValue)fieldValue).getTypeValue();
        }
        return null;
    }

    List getAllInstanceFields() {
        ArrayList arrayList = new ArrayList(50);
        for (JavaClass javaClass = this; javaClass != null; javaClass = javaClass.getSuperClass()) {
            arrayList.addAll(javaClass.getFields());
        }
        return arrayList;
    }

    void setClassLoadOffset(long l) {
        this.loadClassOffset = l;
    }

    int getConstantPoolSize() {
        long l = this.fileOffset + (long)this.classDumpSegment.constantPoolSizeOffset;
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        int n = hprofByteBuffer.getShort(l);
        HprofHeap hprofHeap = this.getHprof();
        l += 2L;
        for (int i = 0; i < n; ++i) {
            byte by = hprofByteBuffer.get(l + 2L);
            int n2 = hprofHeap.getValueSize(by);
            l += (long)(3 + n2);
        }
        return (int)(l - (this.fileOffset + (long)this.classDumpSegment.constantPoolSizeOffset));
    }

    HprofHeap getHprof() {
        return this.classDumpSegment.hprofHeap;
    }

    HprofByteBuffer getHprofBuffer() {
        return this.classDumpSegment.hprofHeap.dumpBuffer;
    }

    int getInstanceFieldOffset() {
        int n = this.getStaticFieldOffset();
        return n + this.getStaticFiledSize(n);
    }

    LoadClass getLoadClass() {
        return new LoadClass(this.getHprof().getLoadClassSegment(), this.loadClassOffset);
    }

    List getReferences() {
        return this.getHprof().findReferencesFor(this.getJavaClassId());
    }

    int getStaticFieldOffset() {
        return this.classDumpSegment.constantPoolSizeOffset + this.getConstantPoolSize();
    }

    int getStaticFiledSize(int n) {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        int n2 = hprofByteBuffer.getIDSize();
        long l = this.fileOffset + (long)n;
        int n3 = this.getHprofBuffer().getShort(l);
        HprofHeap hprofHeap = this.getHprof();
        l += 2L;
        for (int i = 0; i < n3; ++i) {
            byte by = hprofByteBuffer.get(l + (long)n2);
            int n4 = hprofHeap.getValueSize(by);
            l += (long)(n2 + 1 + n4);
        }
        return (int)(l - (long)n - this.fileOffset);
    }

    void findStaticReferencesFor(long l, List list) {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        int n = hprofByteBuffer.getIDSize();
        long l2 = this.fileOffset + (long)this.getStaticFieldOffset();
        int n2 = this.getHprofBuffer().getShort(l2);
        List list2 = null;
        HprofHeap hprofHeap = this.getHprof();
        l2 += 2L;
        for (int i = 0; i < n2; ++i) {
            byte by = hprofByteBuffer.get(l2 + (long)n);
            int n3 = hprofHeap.getValueSize(by);
            if (by == 2 && l == hprofByteBuffer.getID(l2 + (long)n + 1L)) {
                if (list2 == null) {
                    list2 = this.getStaticFieldValues();
                }
                list.add(list2.get(i));
            }
            l2 += (long)(n + 1 + n3);
        }
    }

    void incrementInstance() {
        ++this.instances;
    }

    private static Boolean isSubClass(JavaClass javaClass, Map map) {
        Boolean bl;
        JavaClass javaClass2 = javaClass.getSuperClass();
        if (javaClass2 == null) {
            bl = Boolean.FALSE;
        } else {
            bl = (Boolean)map.get(javaClass2);
            if (bl == null) {
                bl = ClassDump.isSubClass(javaClass2, map);
            }
        }
        map.put(javaClass, bl);
        return bl;
    }

    static {
        $assertionsDisabled = !ClassDump.class.desiredAssertionStatus();
    }
}

