/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.ComputedSummary;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.HprofArrayValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofGCRoot;
import org.netbeans.lib.profiler.heap.HprofInstanceObjectValue;
import org.netbeans.lib.profiler.heap.HprofProxy;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LoadClassSegment;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.NearestGCRoot;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.PrimitiveArrayDump;
import org.netbeans.lib.profiler.heap.StringSegment;
import org.netbeans.lib.profiler.heap.Summary;
import org.netbeans.lib.profiler.heap.TagBounds;
import org.netbeans.lib.profiler.heap.Value;

class HprofHeap
implements Heap {
    static final int STRING = 1;
    static final int LOAD_CLASS = 2;
    private static final int UNLOAD_CLASS = 3;
    private static final int STACK_FRAME = 4;
    private static final int STACK_TRACE = 5;
    private static final int ALLOC_SITES = 6;
    static final int HEAP_SUMMARY = 7;
    private static final int START_THREAD = 10;
    private static final int END_THREAD = 11;
    private static final int HEAP_DUMP = 12;
    private static final int HEAP_DUMP_SEGMENT = 28;
    private static final int HEAP_DUMP_END = 44;
    private static final int CPU_SAMPLES = 13;
    private static final int CONTROL_SETTINGS = 14;
    static final int ROOT_UNKNOWN = 255;
    static final int ROOT_JNI_GLOBAL = 1;
    static final int ROOT_JNI_LOCAL = 2;
    static final int ROOT_JAVA_FRAME = 3;
    static final int ROOT_NATIVE_STACK = 4;
    static final int ROOT_STICKY_CLASS = 5;
    static final int ROOT_THREAD_BLOCK = 6;
    static final int ROOT_MONITOR_USED = 7;
    static final int ROOT_THREAD_OBJECT = 8;
    static final int CLASS_DUMP = 32;
    private static final int INSTANCE_DUMP = 33;
    static final int OBJECT_ARRAY_DUMP = 34;
    static final int PRIMITIVE_ARRAY_DUMP = 35;
    static final int OBJECT = 2;
    static final int BOOLEAN = 4;
    static final int CHAR = 5;
    static final int FLOAT = 6;
    static final int DOUBLE = 7;
    static final int BYTE = 8;
    static final int SHORT = 9;
    static final int INT = 10;
    static final int LONG = 11;
    private static final boolean DEBUG = false;
    HprofByteBuffer dumpBuffer;
    LongMap idToOffsetMap;
    NearestGCRoot nearestGCRoot;
    private ComputedSummary computedSummary;
    private Map gcRoots;
    private Object gcRootLock = new Object();
    private TagBounds allInstanceDumpBounds;
    private TagBounds heapDumpSegment;
    private TagBounds[] heapTagBounds;
    private TagBounds[] tagBounds = new TagBounds[255];
    private boolean instancesCountComputed;
    private boolean referencesComputed;
    private int idMapSize;
    private int segment;
    static final /* synthetic */ boolean $assertionsDisabled;

    HprofHeap(File file, int n) throws FileNotFoundException, IOException {
        this.dumpBuffer = HprofByteBuffer.createHprofByteBuffer(file);
        this.segment = n;
        this.fillTagBounds(this.dumpBuffer.getHeaderSize());
        this.heapDumpSegment = this.computeHeapDumpStart();
        if (this.heapDumpSegment != null) {
            this.fillHeapTagBounds();
        }
        this.idToOffsetMap = new LongMap(this.idMapSize, this.dumpBuffer.getIDSize(), this.dumpBuffer.getFoffsetSize());
        this.nearestGCRoot = new NearestGCRoot(this);
    }

    public List getAllClasses() {
        if (this.heapDumpSegment == null) {
            return Collections.EMPTY_LIST;
        }
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        if (classDumpSegment == null) {
            return Collections.EMPTY_LIST;
        }
        return classDumpSegment.createClassCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GCRoot getGCRoot(Instance instance) {
        Object object = this.gcRootLock;
        synchronized (object) {
            Long l = instance.getInstanceId();
            if (this.gcRoots == null) {
                this.getGCRoots();
            }
            return (GCRoot)this.gcRoots.get(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getGCRoots() {
        Object object = this.gcRootLock;
        synchronized (object) {
            if (this.heapDumpSegment == null) {
                return Collections.EMPTY_LIST;
            }
            if (this.gcRoots == null) {
                this.gcRoots = this.computeGCRootsFor(this.heapTagBounds[255]);
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[1]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[2]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[3]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[4]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[5]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[6]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[7]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[8]));
            }
            return this.gcRoots.values();
        }
    }

    public Instance getInstanceByID(long l) {
        if (l == 0L) {
            return null;
        }
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        int n = this.dumpBuffer.getIDSize();
        int n2 = 0;
        LongMap.Entry entry = this.idToOffsetMap.get(l);
        if (entry == null) {
            return null;
        }
        long l2 = entry.getOffset();
        if (!$assertionsDisabled && l2 == 0L) {
            throw new AssertionError();
        }
        long[] lArray = new long[]{l2};
        int n3 = this.readDumpTag(lArray);
        if (n3 == 33) {
            n2 = n + 4;
        } else if (n3 == 34) {
            n2 = n + 4 + 4;
        } else if (n3 == 35) {
            n2 = n + 4 + 4;
        }
        if (n3 == 35) {
            ClassDump classDump = classDumpSegment.getPrimitiveArrayClass(this.dumpBuffer.get(l2 + 1L + (long)n2));
            return new PrimitiveArrayDump(classDump, l2);
        }
        long l3 = this.dumpBuffer.getID(l2 + 1L + (long)n2);
        ClassDump classDump = classDumpSegment.getClassDumpByID(l3);
        if (n3 == 33) {
            return new InstanceDump(classDump, l2);
        }
        if (n3 == 34) {
            return new ObjectArrayDump(classDump, l2);
        }
        if (n3 == 32) {
            return new ClassDumpInstance(classDump);
        }
        throw new IllegalArgumentException("Illegal tag " + n3);
    }

    public JavaClass getJavaClassByID(long l) {
        return this.getClassDumpSegment().getClassDumpByID(l);
    }

    public JavaClass getJavaClassByName(String string) {
        if (this.heapDumpSegment == null) {
            return null;
        }
        return this.getClassDumpSegment().getJavaClassByName(string);
    }

    public synchronized HeapSummary getSummary() {
        TagBounds tagBounds = this.tagBounds[7];
        if (tagBounds != null) {
            return new Summary(this.dumpBuffer, tagBounds.startOffset);
        }
        if (this.computedSummary == null) {
            this.computedSummary = new ComputedSummary(this);
        }
        return this.computedSummary;
    }

    public Properties getSystemProperties() {
        JavaClass javaClass = this.getJavaClassByName("java.lang.System");
        if (javaClass != null) {
            Instance instance = (Instance)javaClass.getValueOfStaticField("props");
            return HprofProxy.getProperties(instance);
        }
        return null;
    }

    ClassDumpSegment getClassDumpSegment() {
        return (ClassDumpSegment)this.heapTagBounds[32];
    }

    LoadClassSegment getLoadClassSegment() {
        return (LoadClassSegment)this.tagBounds[2];
    }

    StringSegment getStringSegment() {
        return (StringSegment)this.tagBounds[1];
    }

    int getValueSize(byte by) {
        switch (by) {
            case 2: {
                return this.dumpBuffer.getIDSize();
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Invalid type " + by);
    }

    List computeInstances(ClassDump classDump) {
        int n = classDump.getInstancesCount();
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        long l = classDump.getJavaClassId();
        int n2 = this.dumpBuffer.getIDSize();
        ArrayList<InstanceDump> arrayList = new ArrayList<InstanceDump>(n);
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        long[] lArray = new long[]{this.allInstanceDumpBounds.startOffset};
        while (lArray[0] < this.allInstanceDumpBounds.endOffset) {
            InstanceDump instanceDump;
            long l2 = lArray[0];
            int n3 = 0;
            long l3 = 0L;
            int n4 = this.readDumpTag(lArray);
            if (n4 == 33) {
                n3 = n2 + 4;
            } else if (n4 == 34) {
                n3 = n2 + 4 + 4;
            } else if (n4 == 35) {
                byte by = this.dumpBuffer.get(l2 + 1L + (long)n2 + 4L + 4L);
                l3 = classDumpSegment.getPrimitiveArrayClass(by).getJavaClassId();
            }
            if (n3 != 0) {
                l3 = this.dumpBuffer.getID(l2 + 1L + (long)n3);
            }
            if (l3 != l) continue;
            if (n4 == 33) {
                instanceDump = new InstanceDump(classDump, l2);
            } else if (n4 == 34) {
                instanceDump = new ObjectArrayDump(classDump, l2);
            } else if (n4 == 35) {
                instanceDump = new PrimitiveArrayDump(classDump, l2);
            } else {
                throw new IllegalArgumentException("Illegal tag " + n4);
            }
            arrayList.add(instanceDump);
            if (--n != 0) continue;
            return arrayList;
        }
        return arrayList;
    }

    synchronized void computeInstances() {
        if (this.instancesCountComputed) {
            return;
        }
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        int n = this.dumpBuffer.getIDSize();
        long[] lArray = new long[]{this.allInstanceDumpBounds.startOffset};
        Map map = classDumpSegment.getClassIdToClassMap();
        while (lArray[0] < this.allInstanceDumpBounds.endOffset) {
            int n2 = 0;
            int n3 = 0;
            ClassDump classDump = null;
            long l = lArray[0];
            int n4 = this.readDumpTag(lArray);
            long l2 = 0L;
            if (n4 == 33) {
                n3 = 1;
                n2 = n + 4;
            } else if (n4 == 34) {
                n3 = 1;
                n2 = n + 4 + 4;
            } else if (n4 == 35) {
                byte by = this.dumpBuffer.get(l + 1L + (long)n + 4L + 4L);
                n3 = 1;
                classDump = classDumpSegment.getPrimitiveArrayClass(by);
            }
            if (n3 != 0) {
                l2 = this.dumpBuffer.getID(l + (long)n3);
                this.idToOffsetMap.put(l2, l);
            }
            if (n2 != 0) {
                long l3 = this.dumpBuffer.getID(l + 1L + (long)n2);
                classDump = (ClassDump)map.get(new Long(l3));
            }
            if (classDump == null) continue;
            classDump.incrementInstance();
            this.idToOffsetMap.get(l2).setIndex(classDump.getInstancesCount());
            classDumpSegment.addInstanceSize(classDump, n4, l);
        }
        this.instancesCountComputed = true;
    }

    List findReferencesFor(long l) {
        if (!$assertionsDisabled && l == 0L) {
            throw new AssertionError((Object)"InstanceID is null");
        }
        this.computeReferences();
        ArrayList<Value> arrayList = new ArrayList<Value>();
        List list = this.idToOffsetMap.get(l).getReferences();
        Iterator iterator = list.iterator();
        int n = this.dumpBuffer.getIDSize();
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        long[] lArray = new long[1];
        while (iterator.hasNext()) {
            Object object;
            long l2;
            long l3 = (Long)iterator.next();
            lArray[0] = this.idToOffsetMap.get(l3).getOffset();
            int n2 = 0;
            boolean bl = false;
            long l4 = lArray[0];
            int n3 = this.readDumpTag(lArray);
            if (n3 == 33) {
                n2 = n + 4;
                int n4 = this.dumpBuffer.getInt(l4 + 1L + (long)n + 4L + (long)n);
                byte[] byArray = new byte[n4];
                this.dumpBuffer.get(l4 + 1L + (long)n + 4L + (long)n + 4L, byArray);
                l2 = this.dumpBuffer.getID(l4 + 1L + (long)n + 4L);
                ClassDump classDump = classDumpSegment.getClassDumpByID(l2);
                InstanceDump instanceDump = new InstanceDump(classDump, l4);
                object = instanceDump.getFieldValues().iterator();
                while (object.hasNext()) {
                    HprofInstanceObjectValue hprofInstanceObjectValue;
                    Object e = object.next();
                    if (!(e instanceof HprofInstanceObjectValue) || (hprofInstanceObjectValue = (HprofInstanceObjectValue)e).getInstanceId() != l) continue;
                    arrayList.add(hprofInstanceObjectValue);
                }
                continue;
            }
            if (n3 == 34) {
                int n5 = this.dumpBuffer.getInt(l4 + 1L + (long)n + 4L);
                l2 = l4 + 1L + (long)n + 4L + 4L + (long)n;
                int n6 = 0;
                while (n6 < n5) {
                    if (this.dumpBuffer.getID(l2) == l) {
                        long l5 = this.dumpBuffer.getID(l4 + 1L + (long)n + 4L + 4L);
                        object = classDumpSegment.getClassDumpByID(l5);
                        arrayList.add(new HprofArrayValue((ClassDump)object, l4, n6));
                    }
                    ++n6;
                    l2 += (long)n;
                }
                continue;
            }
            if (n3 != 32) continue;
            ClassDump classDump = classDumpSegment.getClassDumpByID(l3);
            classDump.findStaticReferencesFor(l, arrayList);
        }
        return arrayList;
    }

    synchronized void computeReferences() {
        if (this.referencesComputed) {
            return;
        }
        ClassDumpSegment classDumpSegment = this.getClassDumpSegment();
        int n = this.dumpBuffer.getIDSize();
        long[] lArray = new long[]{this.allInstanceDumpBounds.startOffset};
        Map map = classDumpSegment.getClassIdToClassMap();
        while (lArray[0] < this.allInstanceDumpBounds.endOffset) {
            Object object;
            long l;
            long l2;
            long l3 = lArray[0];
            int n2 = this.readDumpTag(lArray);
            if (n2 == 33) {
                l2 = this.dumpBuffer.getID(l3 + 1L + (long)n + 4L);
                ClassDump classDump = (ClassDump)map.get(new Long(l2));
                l = this.dumpBuffer.getID(l3 + 1L);
                long l4 = l3 + 1L + (long)n + 4L + (long)n + 4L;
                List list = classDump.getAllInstanceFields();
                object = list.iterator();
                while (object.hasNext()) {
                    LongMap.Entry entry;
                    long l5;
                    HprofField hprofField = (HprofField)object.next();
                    if (hprofField.getVauleType() == 2 && (l5 = this.dumpBuffer.getID(l4)) != 0L && (entry = this.idToOffsetMap.get(l5)) != null) {
                        entry.addReference(l);
                    }
                    l4 += (long)hprofField.getValueSize();
                }
                continue;
            }
            if (n2 != 34) continue;
            l2 = this.dumpBuffer.getID(l3 + 1L);
            int n3 = this.dumpBuffer.getInt(l3 + 1L + (long)n + 4L);
            l = l3 + 1L + (long)n + 4L + 4L + (long)n;
            int n4 = 0;
            while (n4 < n3) {
                long l6 = this.dumpBuffer.getID(l);
                if (l6 != 0L && (object = this.idToOffsetMap.get(l6)) != null) {
                    ((LongMap.Entry)object).addReference(l2);
                }
                ++n4;
                l += (long)n;
            }
        }
        Iterator iterator = this.getClassDumpSegment().createClassCollection().iterator();
        while (iterator.hasNext()) {
            ClassDump classDump = (ClassDump)iterator.next();
            List list = classDump.getStaticFieldValues();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                LongMap.Entry entry;
                long l;
                Object e = iterator2.next();
                if (!(e instanceof HprofFieldObjectValue) || (l = ((HprofFieldObjectValue)e).getInstanceID()) == 0L || (entry = this.idToOffsetMap.get(l)) == null) continue;
                entry.addReference(classDump.getJavaClassId());
            }
        }
        this.referencesComputed = true;
    }

    int readDumpTag(long[] lArray) {
        long l = lArray[0];
        int n = this.dumpBuffer.get(l++);
        int n2 = 0;
        long l2 = l;
        int n3 = this.dumpBuffer.getIDSize();
        switch (n) {
            case -1: 
            case 255: {
                n2 = n3;
                n = 255;
                break;
            }
            case 1: {
                n2 = 2 * n3;
                break;
            }
            case 2: {
                n2 = n3 + 8;
                break;
            }
            case 3: {
                n2 = n3 + 8;
                break;
            }
            case 4: {
                n2 = n3 + 4;
                break;
            }
            case 5: {
                n2 = n3;
                break;
            }
            case 6: {
                n2 = n3 + 4;
                break;
            }
            case 7: {
                n2 = n3;
                break;
            }
            case 8: {
                n2 = n3 + 8;
                break;
            }
            case 32: {
                int n4 = n3 + 4 + 6 * n3 + 4;
                lArray[0] = l + (long)n4;
                int n5 = this.readConstantPool(lArray);
                int n6 = this.readStaticFields(lArray);
                int n7 = this.readInstanceFields(lArray);
                n2 = n4 + n5 + n6 + n7;
                break;
            }
            case 33: {
                int n8 = this.dumpBuffer.getInt(l + (long)n3 + 4L + (long)n3);
                n2 = n3 + 4 + n3 + 4 + n8;
                break;
            }
            case 34: {
                int n9 = this.dumpBuffer.getInt(l + (long)n3 + 4L);
                n2 = n3 + 4 + 4 + n3 + n9 * n3;
                break;
            }
            case 35: {
                int n10 = this.dumpBuffer.getInt(l + (long)n3 + 4L);
                byte by = this.dumpBuffer.get(l + (long)n3 + 4L + 4L);
                n2 = n3 + 4 + 4 + 1 + n10 * this.getValueSize(by);
                break;
            }
            case 28: {
                n2 = 8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid dump tag " + n + " at position " + (l - 1L));
            }
        }
        lArray[0] = l2 + (long)n2;
        return n;
    }

    int readTag(long[] lArray) {
        long l = lArray[0];
        byte by = this.dumpBuffer.get(l);
        long l2 = (long)this.dumpBuffer.getInt(l + 1L + 4L) & 0xFFFFFFFFL;
        lArray[0] = l + 1L + 4L + 4L + l2;
        return by;
    }

    private Map computeGCRootsFor(TagBounds tagBounds) {
        HashMap<Long, HprofGCRoot> hashMap = new HashMap<Long, HprofGCRoot>();
        if (tagBounds != null) {
            int n = tagBounds.tag;
            long[] lArray = new long[]{tagBounds.startOffset};
            while (lArray[0] < tagBounds.endOffset) {
                long l = lArray[0];
                if (this.readDumpTag(lArray) != n) continue;
                HprofGCRoot hprofGCRoot = new HprofGCRoot(this, l);
                hashMap.put(hprofGCRoot.getInstanceId(), hprofGCRoot);
            }
        }
        return hashMap;
    }

    private TagBounds computeHeapDumpStart() throws IOException {
        TagBounds tagBounds = this.tagBounds[12];
        if (tagBounds != null) {
            long l = tagBounds.startOffset;
            long[] lArray = new long[]{l};
            int n = 0;
            while (n <= this.segment && l < tagBounds.endOffset) {
                int n2 = this.readTag(lArray);
                if (n2 == 12) {
                    if (n == this.segment) {
                        return new TagBounds(12, l, lArray[0]);
                    }
                    ++n;
                }
                l = lArray[0];
            }
            throw new IOException("Invalid segment " + this.segment);
        }
        TagBounds tagBounds2 = this.tagBounds[28];
        if (tagBounds2 != null) {
            long l = tagBounds2.startOffset;
            long l2 = tagBounds2.endOffset;
            return new TagBounds(12, l, l2);
        }
        return null;
    }

    private boolean contains(byte[] byArray, byte[] byArray2) {
        byte by = byArray[0];
        for (int i = 0; i < byArray2.length - byArray.length + 1; ++i) {
            int n;
            if (byArray2[i] != by) continue;
            for (n = 1; n < byArray.length && byArray[n] == byArray2[i + n]; ++n) {
            }
            if (n != byArray.length) continue;
            return true;
        }
        return false;
    }

    private void fillHeapTagBounds() {
        if (this.heapTagBounds != null) {
            return;
        }
        this.heapTagBounds = new TagBounds[256];
        long[] lArray = new long[]{this.heapDumpSegment.startOffset + 1L + 4L + 4L};
        while (lArray[0] < this.heapDumpSegment.endOffset) {
            long l = lArray[0];
            int n = this.readDumpTag(lArray);
            TagBounds tagBounds = this.heapTagBounds[n];
            long l2 = lArray[0];
            if (tagBounds == null) {
                TagBounds tagBounds2 = n == 32 ? new ClassDumpSegment(this, l, l2) : new TagBounds(n, l, l2);
                this.heapTagBounds[n] = tagBounds2;
            } else {
                tagBounds.endOffset = l2;
            }
            if (n != 32 && n != 33 && n != 34 && n != 35) continue;
            ++this.idMapSize;
        }
        TagBounds tagBounds = this.heapTagBounds[33];
        TagBounds tagBounds3 = this.heapTagBounds[34];
        TagBounds tagBounds4 = this.heapTagBounds[35];
        this.allInstanceDumpBounds = tagBounds.union(tagBounds3);
        this.allInstanceDumpBounds = this.allInstanceDumpBounds.union(tagBounds4);
    }

    private void fillTagBounds(long l) {
        long[] lArray = new long[]{l};
        while (lArray[0] < this.dumpBuffer.capacity()) {
            long l2 = lArray[0];
            int n = this.readTag(lArray);
            TagBounds tagBounds = this.tagBounds[n];
            long l3 = lArray[0];
            if (tagBounds == null) {
                TagBounds tagBounds2 = n == 2 ? new LoadClassSegment(this, l2, l3) : (n == 1 ? new StringSegment(this, l2, l3) : new TagBounds(n, l2, l3));
                this.tagBounds[n] = tagBounds2;
                continue;
            }
            tagBounds.endOffset = l3;
        }
    }

    private int readConstantPool(long[] lArray) {
        long l = lArray[0];
        int n = this.dumpBuffer.getShort(l);
        lArray[0] = lArray[0] + 2L;
        for (int i = 0; i < n; ++i) {
            lArray[0] = lArray[0] + 2L;
            this.readValue(lArray);
        }
        return (int)(lArray[0] - l);
    }

    private int readInstanceFields(long[] lArray) {
        long l = lArray[0];
        short s = this.dumpBuffer.getShort(lArray[0]);
        lArray[0] = lArray[0] + 2L;
        lArray[0] = lArray[0] + (long)(s * (this.dumpBuffer.getIDSize() + 1));
        return (int)(lArray[0] - l);
    }

    private int readStaticFields(long[] lArray) {
        long l = lArray[0];
        int n = this.dumpBuffer.getShort(l);
        lArray[0] = lArray[0] + 2L;
        int n2 = this.dumpBuffer.getIDSize();
        for (int i = 0; i < n; ++i) {
            lArray[0] = lArray[0] + (long)n2;
            byte by = this.readValue(lArray);
        }
        return (int)(lArray[0] - l);
    }

    private byte readValue(long[] lArray) {
        long l = lArray[0];
        lArray[0] = l + 1L;
        byte by = this.dumpBuffer.get(l);
        lArray[0] = lArray[0] + (long)this.getValueSize(by);
        return by;
    }

    static {
        $assertionsDisabled = !HprofHeap.class.desiredAssertionStatus();
    }
}

