/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.ArrayList;
import java.util.Hashtable;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.classfile.PlaceholderClassInfo;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.ClassRewriter;
import org.netbeans.lib.profiler.instrumentation.DynamicConstantPoolExtension;
import org.netbeans.lib.profiler.instrumentation.HandleServletDoMethodCallInjector;
import org.netbeans.lib.profiler.instrumentation.InstrumentationFactory;
import org.netbeans.lib.profiler.instrumentation.RootMethods;

public abstract class RecursiveMethodInstrumentor
extends ClassManager {
    protected Hashtable instrClasses = new Hashtable();
    protected InstrumentationFilter instrFilter;
    protected byte[] codeBytes;
    protected boolean dontInstrumentEmptyMethods;
    protected boolean dontScanGetterSetterMethods;
    protected boolean instrumentClinit;
    protected boolean instrumentSpawnedThreads;
    protected boolean reflectInvokeInstrumented = false;
    protected int markerInjectionType;
    protected int nInstrClasses;
    protected int nInstrMethods;
    protected int normalInjectionType;
    protected int offset;
    protected int rootInjectionType;
    RootMethods rootMethods;
    private ProfilerEngineSettings engineSettings;

    protected RecursiveMethodInstrumentor(ProfilingSessionStatus profilingSessionStatus, ProfilerEngineSettings profilerEngineSettings) {
        super(profilingSessionStatus);
        switch (profilingSessionStatus.currentInstrType) {
            case 2: {
                this.normalInjectionType = 0;
                this.rootInjectionType = 1;
                this.markerInjectionType = 2;
                break;
            }
            case 3: {
                this.normalInjectionType = 3;
                this.rootInjectionType = 4;
                this.markerInjectionType = 5;
            }
        }
        this.reflectInvokeInstrumented = false;
        this.dontScanGetterSetterMethods = !profilerEngineSettings.getInstrumentGetterSetterMethods();
        this.dontInstrumentEmptyMethods = !profilerEngineSettings.getInstrumentEmptyMethods();
        this.instrumentSpawnedThreads = profilerEngineSettings.getInstrumentSpawnedThreads();
        this.instrFilter = profilerEngineSettings.getInstrumentationFilter();
        this.engineSettings = profilerEngineSettings;
    }

    abstract Object[] getInitialMethodsToInstrument(String[] var1, int[] var2, byte[][] var3, RootMethods var4);

    public abstract Object[] getMethodsToInstrumentUponClassLoad(String var1, int var2, boolean var3);

    public abstract Object[] getMethodsToInstrumentUponMethodInvocation(String var1, int var2, String var3, String var4);

    public abstract Object[] getMethodsToInstrumentUponReflectInvoke(String var1, int var2, String var3, String var4);

    protected void initInstrMethodData() {
        this.instrClasses.clear();
        this.nInstrMethods = 0;
        this.nInstrClasses = 0;
        this.instrumentClinit = false;
    }

    protected static boolean rootClassNameIsReal(String string) {
        return !string.equals("*NO_CLASS_NAME*");
    }

    protected void addToSubclassList(DynamicClassInfo dynamicClassInfo, DynamicClassInfo dynamicClassInfo2) {
        String[] stringArray;
        String string = dynamicClassInfo.getSuperclassName();
        int n = dynamicClassInfo.getLoaderId();
        DynamicClassInfo dynamicClassInfo3 = RecursiveMethodInstrumentor.javaClassForName(string, n);
        dynamicClassInfo.setSuperClass(dynamicClassInfo3);
        if (dynamicClassInfo3 != null && !dynamicClassInfo.isInterface()) {
            dynamicClassInfo3.addSubclass(dynamicClassInfo2);
            if (dynamicClassInfo2 != null) {
                this.findAndMarkOverridingMethodsReachable(dynamicClassInfo3, dynamicClassInfo2);
            }
            if (string != "java/lang/Object") {
                this.addToSubclassList(dynamicClassInfo3, dynamicClassInfo2);
            }
        }
        if ((stringArray = dynamicClassInfo.getInterfaceNames()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                DynamicClassInfo dynamicClassInfo4 = RecursiveMethodInstrumentor.javaClassForName(stringArray[i], n);
                dynamicClassInfo.setSuperInterface(dynamicClassInfo4, i);
                if (dynamicClassInfo4 == null) continue;
                dynamicClassInfo4.addSubclass(dynamicClassInfo2);
                if (dynamicClassInfo2 != null) {
                    this.findAndMarkOverridingMethodsReachable(dynamicClassInfo4, dynamicClassInfo2);
                }
                this.addToSubclassList(dynamicClassInfo4, dynamicClassInfo2);
            }
        }
    }

    protected abstract void findAndMarkOverridingMethodsReachable(DynamicClassInfo var1, DynamicClassInfo var2);

    protected abstract void processInvoke(DynamicClassInfo var1, boolean var2, int var3);

    protected final int at(int n) {
        return this.codeBytes[this.offset + n] & 0xFF;
    }

    protected final long intAt(int n, int n2) {
        int n3 = n + (n2 << 2);
        return this.codeBytes[n3] << 24 | (this.codeBytes[n3 + 1] & 0xFF) << 16 | (this.codeBytes[n3 + 2] & 0xFF) << 8 | this.codeBytes[n3 + 3] & 0xFF;
    }

    protected void scanMethod(DynamicClassInfo dynamicClassInfo, int n) {
        byte[] byArray = dynamicClassInfo.getMethodBytecode(n);
        this.scanBytecode(dynamicClassInfo, byArray);
    }

    protected final int shortAt(int n) {
        int n2 = this.offset + n;
        return (this.codeBytes[n2] & 0xFF) << 8 | this.codeBytes[n2 + 1] & 0xFF;
    }

    protected boolean scanBytecode(DynamicClassInfo dynamicClassInfo, byte[] byArray) {
        this.codeBytes = byArray;
        this.offset = 0;
        block6: while (this.offset < this.codeBytes.length) {
            int n = this.at(0);
            if (n == 196) {
                n = this.at(1);
                if (n >= 21 && n <= 25 || n >= 54 && n <= 58 || n == 169) {
                    this.offset += 4;
                    continue;
                }
                if (n == 132) {
                    this.offset += 6;
                    continue;
                }
                ++this.offset;
                continue;
            }
            switch (n) {
                case 170: {
                    int n2 = this.offset + 1 + 3 & 0xFFFFFFFC;
                    long l = this.intAt(n2, 0);
                    long l2 = this.intAt(n2, 1);
                    long l3 = this.intAt(n2, 2);
                    this.offset = (n2 += 12) + (int)(l3 - l2 + 1L << 2);
                    continue block6;
                }
                case 171: {
                    int n2 = this.offset + 1 + 3 & 0xFFFFFFFC;
                    long l = this.intAt(n2, 0);
                    int n3 = (int)this.intAt(n2, 1);
                    int n4 = n3 * 2;
                    this.offset = (n2 += 8) + (n4 << 2);
                    continue block6;
                }
                case 182: 
                case 183: 
                case 184: {
                    if (dynamicClassInfo == null) {
                        return false;
                    }
                    int n2 = this.shortAt(1);
                    this.processInvoke(dynamicClassInfo, n == 182, n2);
                    this.offset += 3;
                    continue block6;
                }
                case 185: {
                    if (dynamicClassInfo == null) {
                        return false;
                    }
                    int n2 = this.shortAt(1);
                    this.processInvoke(dynamicClassInfo, true, n2);
                    this.offset += 5;
                    continue block6;
                }
            }
            this.offset += opc_length[n];
        }
        return true;
    }

    protected abstract boolean tryInstrumentSpawnedThreads(DynamicClassInfo var1);

    protected static boolean isEmptyMethod(byte[] byArray) {
        return byArray.length == 1;
    }

    protected static boolean isGetterSetterMethod(byte[] byArray) {
        return byArray.length == 5 ? (byArray[0] & 0xFF) == 42 && (byArray[1] & 0xFF) == 180 && (byArray[4] & 0xFF) >= 172 && (byArray[4] & 0xFF) <= 176 : byArray.length == 6 && (byArray[0] & 0xFF) == 42 && (byArray[1] & 0xFF) >= 27 && (byArray[1] & 0xFF) <= 43 && (byArray[2] & 0xFF) == 181 && (byArray[5] & 0xFF) == 177;
    }

    protected boolean isLeafMethod(byte[] byArray) {
        return this.scanBytecode(null, byArray);
    }

    protected Object[] createInstrumentedMethodPack() {
        if (this.nInstrMethods == 0) {
            return null;
        }
        return this.createInstrumentedMethodPack15();
    }

    protected Object[] createInstrumentedMethodPack(DynamicClassInfo dynamicClassInfo) {
        if (this.nInstrMethods == 0 && RecursiveMethodInstrumentor.getRuntimeProfilingPoints(this.engineSettings.getRuntimeProfilingPoints(), dynamicClassInfo).length == 0) {
            return null;
        }
        if (dynamicClassInfo.isInterface()) {
            return null;
        }
        return this.createInstrumentedMethodPack15(dynamicClassInfo);
    }

    protected void markAllMethodsMarker(DynamicClassInfo dynamicClassInfo) {
        dynamicClassInfo.setAllMethodsMarkers();
    }

    protected void markAllMethodsRoot(DynamicClassInfo dynamicClassInfo) {
        dynamicClassInfo.setAllMethodsRoots();
    }

    protected void markClassAndMethodForInstrumentation(DynamicClassInfo dynamicClassInfo, int n) {
        if (this.status.getStartingMethodId() + this.nInstrMethods < 65535) {
            String string = dynamicClassInfo.getNameAndLoader();
            if (!this.instrClasses.containsKey(string)) {
                this.instrClasses.put(string, dynamicClassInfo);
                ++this.nInstrClasses;
            }
            ++this.nInstrMethods;
        } else {
            dynamicClassInfo.setMethodInstrumented(n);
        }
    }

    protected boolean markMethod(DynamicClassInfo dynamicClassInfo, int n) {
        String string = this.rootMethods.methodNames[n];
        String string2 = this.rootMethods.methodSignatures[n];
        boolean bl = this.rootMethods.markerMethods[n];
        int n2 = dynamicClassInfo.getMethodIndex(string, string2);
        if (n2 == -1) {
            return false;
        }
        if (bl) {
            dynamicClassInfo.setMethodMarker(n2);
        } else {
            dynamicClassInfo.setMethodRoot(n2);
        }
        return true;
    }

    protected boolean markMethodMarker(DynamicClassInfo dynamicClassInfo, String string, String string2) {
        int n = dynamicClassInfo.getMethodIndex(string, string2);
        if (n == -1) {
            return false;
        }
        dynamicClassInfo.setMethodMarker(n);
        return true;
    }

    protected boolean markMethodRoot(DynamicClassInfo dynamicClassInfo, String string, String string2) {
        int n = dynamicClassInfo.getMethodIndex(string, string2);
        if (n == -1) {
            return false;
        }
        dynamicClassInfo.setMethodRoot(n);
        return true;
    }

    protected boolean matchesWildcard(String string, String string2) {
        boolean bl = false;
        if (string.endsWith("*")) {
            string = string.substring(0, string.length() - 1);
            bl = true;
        }
        if (!string2.startsWith(string)) {
            return false;
        }
        return bl || string2.indexOf(47, string.length()) == -1;
    }

    private Object[] createInstrumentedMethodPack15() {
        Object object;
        int n;
        int n2;
        Object object2;
        Object object3;
        int n3 = -1;
        if (!this.reflectInvokeInstrumented) {
            int n4 = 0;
            object3 = this.instrClasses.elements();
            while (object3.hasMoreElements()) {
                object2 = (DynamicClassInfo)object3.nextElement();
                if (((BaseClassInfo)object2).getName() == "java/lang/reflect/Method") {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
            if (n3 == -1) {
                ++this.nInstrClasses;
            }
        }
        String[] stringArray = new String[this.nInstrClasses];
        object3 = new int[this.nInstrClasses];
        object2 = new boolean[this.nInstrMethods];
        byte[][] byArrayArray = new byte[this.nInstrClasses][];
        int n5 = this.status.getStartingMethodId();
        int n6 = 0;
        int n7 = 0;
        Object object4 = this.instrClasses.elements();
        while (object4.hasMoreElements()) {
            DynamicClassInfo dynamicClassInfo = (DynamicClassInfo)object4.nextElement();
            int n8 = dynamicClassInfo.getMethodNames().length;
            stringArray[n6] = dynamicClassInfo.getName().replace('/', '.').intern();
            n2 = dynamicClassInfo.hasUninstrumentedRootMethods();
            boolean bl = dynamicClassInfo.hasUninstrumentedMarkerMethods();
            DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, this.normalInjectionType);
            if (n2 != 0) {
                DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, this.rootInjectionType);
            }
            if (bl) {
                DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, this.markerInjectionType);
            }
            n = 0;
            object = new byte[n8][];
            RuntimeProfilingPoint[] runtimeProfilingPointArray = RecursiveMethodInstrumentor.getRuntimeProfilingPoints(this.engineSettings.getRuntimeProfilingPoints(), dynamicClassInfo);
            for (int i = 0; i < n8; ++i) {
                RuntimeProfilingPoint[] runtimeProfilingPointArray2 = RecursiveMethodInstrumentor.getRuntimeProfilingPoints(runtimeProfilingPointArray, i);
                if (!dynamicClassInfo.isMethodInstrumented(i)) {
                    if (dynamicClassInfo.isMethodReachable(i) && !dynamicClassInfo.isMethodUnscannable(i)) {
                        dynamicClassInfo.setMethodInstrumented(i);
                        object2[n7] = dynamicClassInfo.isMethodLeaf(i);
                        object[i] = InstrumentationFactory.instrumentMethod(dynamicClassInfo, i, this.normalInjectionType, this.rootInjectionType, this.markerInjectionType, n5++, runtimeProfilingPointArray2);
                        dynamicClassInfo.saveMethodInfo(i, object[i]);
                        this.status.updateInstrMethodsInfo(stringArray[n6], dynamicClassInfo.getLoaderId(), dynamicClassInfo.getMethodNames()[i], dynamicClassInfo.getMethodSignatures()[i]);
                        ++n;
                        ++n7;
                        continue;
                    }
                    if (runtimeProfilingPointArray2.length <= 0) continue;
                    object[i] = InstrumentationFactory.instrumentAsProiflePointHitMethod(dynamicClassInfo, i, this.normalInjectionType, runtimeProfilingPointArray2);
                    dynamicClassInfo.saveMethodInfo(i, object[i]);
                    continue;
                }
                object[i] = dynamicClassInfo.getMethodInfo(i);
                ++n;
            }
            this.instrumentServletDoMethods(dynamicClassInfo, (byte[][])object);
            if (n > 0) {
                if (n2 != 0) {
                    dynamicClassInfo.setHasUninstrumentedRootMethods(false);
                }
                if (bl) {
                    dynamicClassInfo.setHasUninstrumentedMarkerMethods(false);
                }
                DynamicConstantPoolExtension dynamicConstantPoolExtension = DynamicConstantPoolExtension.getAllAddedCPFragments(dynamicClassInfo);
                int n9 = dynamicConstantPoolExtension.getNEntries();
                byte[] byArray = dynamicConstantPoolExtension.getContents();
                byArrayArray[n6] = ClassRewriter.rewriteClassFile(dynamicClassInfo, object, n9, byArray);
            }
            object3[n6] = dynamicClassInfo.getLoaderId();
            ++n6;
        }
        if (!this.reflectInvokeInstrumented) {
            object4 = RecursiveMethodInstrumentor.javaClassForName("java.lang.reflect.Method", 0);
            int n10 = ((ClassInfo)object4).getMethodNames().length;
            byte[][] byArrayArray2 = new byte[n10][];
            if (n3 == -1) {
                stringArray[n6] = "java.lang.reflect.Method";
                object3[n6] = false;
            } else {
                n6 = n3;
                for (n2 = 0; n2 < n10; ++n2) {
                    byArrayArray2[n2] = ((DynamicClassInfo)object4).getMethodInfo(n2);
                }
            }
            n2 = ((ClassInfo)object4).getMethodIndex("invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
            DynamicConstantPoolExtension.getCPFragment((DynamicClassInfo)object4, 6);
            byArrayArray2[n2] = InstrumentationFactory.instrumentAsReflectInvokeMethod((DynamicClassInfo)object4, n2);
            DynamicConstantPoolExtension dynamicConstantPoolExtension = DynamicConstantPoolExtension.getAllAddedCPFragments((DynamicClassInfo)object4);
            n = dynamicConstantPoolExtension.getNEntries();
            object = dynamicConstantPoolExtension.getContents();
            byArrayArray[n6] = ClassRewriter.rewriteClassFile((DynamicClassInfo)object4, byArrayArray2, n, (byte[])object);
            ((DynamicClassInfo)object4).saveMethodInfo(n2, byArrayArray2[n2]);
            this.reflectInvokeInstrumented = true;
        }
        return new Object[]{stringArray, object3, object2, byArrayArray};
    }

    private Object[] createInstrumentedMethodPack15(DynamicClassInfo dynamicClassInfo) {
        String string;
        String[] stringArray = dynamicClassInfo.getMethodNames();
        String[] stringArray2 = new String[1];
        int[] nArray = new int[]{dynamicClassInfo.getLoaderId()};
        stringArray2[0] = string = dynamicClassInfo.getName().replace('/', '.').intern();
        boolean[] blArray = new boolean[this.nInstrMethods];
        int n = this.status.getStartingMethodId();
        int n2 = 0;
        boolean bl = dynamicClassInfo.hasUninstrumentedRootMethods();
        boolean bl2 = dynamicClassInfo.hasUninstrumentedMarkerMethods();
        boolean bl3 = dynamicClassInfo.getName() == "java/lang/reflect/Method";
        DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, this.normalInjectionType);
        if (bl) {
            DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, this.rootInjectionType);
        }
        if (bl2) {
            DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, this.markerInjectionType);
        }
        byte[][] byArrayArray = new byte[stringArray.length][];
        RuntimeProfilingPoint[] runtimeProfilingPointArray = RecursiveMethodInstrumentor.getRuntimeProfilingPoints(this.engineSettings.getRuntimeProfilingPoints(), dynamicClassInfo);
        for (int i = 0; i < stringArray.length; ++i) {
            RuntimeProfilingPoint[] runtimeProfilingPointArray2 = RecursiveMethodInstrumentor.getRuntimeProfilingPoints(runtimeProfilingPointArray, i);
            if (!dynamicClassInfo.isMethodInstrumented(i)) {
                if (dynamicClassInfo.isMethodReachable(i) && !dynamicClassInfo.isMethodUnscannable(i) || this.instrumentClinit && stringArray[i] == "<clinit>") {
                    dynamicClassInfo.setMethodInstrumented(i);
                    blArray[n2++] = dynamicClassInfo.isMethodLeaf(i);
                    byArrayArray[i] = InstrumentationFactory.instrumentMethod(dynamicClassInfo, i, this.normalInjectionType, this.rootInjectionType, this.markerInjectionType, n++, runtimeProfilingPointArray2);
                    dynamicClassInfo.saveMethodInfo(i, byArrayArray[i]);
                    this.status.updateInstrMethodsInfo(stringArray2[0], dynamicClassInfo.getLoaderId(), dynamicClassInfo.getMethodNames()[i], dynamicClassInfo.getMethodSignatures()[i]);
                    continue;
                }
                if (runtimeProfilingPointArray2.length <= 0) continue;
                byArrayArray[i] = InstrumentationFactory.instrumentAsProiflePointHitMethod(dynamicClassInfo, i, this.normalInjectionType, runtimeProfilingPointArray2);
                dynamicClassInfo.saveMethodInfo(i, byArrayArray[i]);
                continue;
            }
            byArrayArray[i] = dynamicClassInfo.getMethodInfo(i);
        }
        this.instrumentServletDoMethods(dynamicClassInfo, byArrayArray);
        if (bl) {
            dynamicClassInfo.setHasUninstrumentedRootMethods(false);
        }
        if (bl2) {
            dynamicClassInfo.setHasUninstrumentedMarkerMethods(false);
        }
        DynamicConstantPoolExtension dynamicConstantPoolExtension = DynamicConstantPoolExtension.getAllAddedCPFragments(dynamicClassInfo);
        int n3 = dynamicConstantPoolExtension.getNEntries();
        byte[] byArray = dynamicConstantPoolExtension.getContents();
        byte[] byArray2 = ClassRewriter.rewriteClassFile(dynamicClassInfo, byArrayArray, n3, byArray);
        return new Object[]{stringArray2, nArray, blArray, new byte[][]{byArray2}};
    }

    private void instrumentServletDoMethods(DynamicClassInfo dynamicClassInfo, byte[][] byArray) {
        if (!Boolean.getBoolean("org.netbeans.lib.profiler.servletTracking")) {
            return;
        }
        if (dynamicClassInfo.isServletDoMethodScanned()) {
            return;
        }
        dynamicClassInfo.setServletDoMethodScanned();
        if (!dynamicClassInfo.isSubclassOf(HandleServletDoMethodCallInjector.getClassName())) {
            return;
        }
        DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, 7);
        String[] stringArray = HandleServletDoMethodCallInjector.getMethodNames();
        String[] stringArray2 = HandleServletDoMethodCallInjector.getMethodSignatures();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = dynamicClassInfo.getMethodIndex(stringArray[i], stringArray2[i]);
            if (n == -1) continue;
            byArray[n] = InstrumentationFactory.instrumentAsServletDoMethod(dynamicClassInfo, n);
            dynamicClassInfo.saveMethodInfo(n, byArray[n]);
        }
    }

    protected static class ReachableMethodPlaceholder
    extends PlaceholderClassInfo {
        protected ArrayList methodNamesAndSigs = new ArrayList();

        ReachableMethodPlaceholder(String string, int n) {
            super(string, n);
        }

        public void registerReachableMethod(String string, String string2) {
            int n = this.methodNamesAndSigs.indexOf(string);
            if (n != -1 && this.methodNamesAndSigs.get(n + 1).equals(string2)) {
                return;
            }
            this.methodNamesAndSigs.add(string);
            this.methodNamesAndSigs.add(string2);
        }
    }
}

