/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerBacked;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeFree;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.TimedCPUCCTNode;

public class CPUCCTContainer {
    private static final Logger LOGGER = Logger.getLogger(CPUCCTContainer.class.getName());
    protected static final int OFS_METHODID = 0;
    protected static final int OFS_NCALLS = 2;
    protected static final int OFS_TIME0 = 6;
    protected static final int OFS_SELFTIME0 = 11;
    protected static final int OFS_TIME1 = 16;
    protected static final int OFS_SELFTIME1 = 21;
    protected static final int OFS_NSUBNODES1 = 16;
    protected static final int OFS_NSUBNODES2 = 26;
    protected static final int OFS_SUBNODE01 = 18;
    protected static final int OFS_SUBNODE02 = 28;
    protected static final int CHILD_OFS_SIZE_3 = 3;
    protected static final int CHILD_OFS_SIZE_4 = 4;
    private static double timeInInjectedCodeInMS;
    private static double wholeGraphGrossTimeAbsInMS;
    protected CPUResultsSnapshot cpuResSnapshot;
    protected FlatProfileContainer cachedFlatProfile;
    protected PrestimeCPUCCTNode rootNode;
    protected String threadName;
    protected byte[] compactData;
    protected int[] invPerMethodId;
    protected long[] timePerMethodId0;
    protected long[] timePerMethodId1;
    protected boolean collectingTwoTimeStamps;
    protected boolean displayWholeThreadCPUTime;
    protected double timeInInjectedCodeInAbsCounts;
    protected double timeInInjectedCodeInThreadCPUCounts;
    protected int childOfsSize = -1;
    protected int nodeSize;
    protected int threadId;
    protected long wholeGraphGrossTimeAbs;
    protected long wholeGraphGrossTimeThreadCPU;
    protected long wholeGraphNetTime0;
    protected long wholeGraphNetTime1;
    protected long wholeGraphPureTimeAbs;
    protected long wholeGraphPureTimeThreadCPU;
    private InstrumentationFilter filter;
    private PrestimeCPUCCTNodeFree reverseCCTRootNode;
    private ProfilingSessionStatus status;
    private int[] nodeStack;
    private int childTotalNCalls;
    private int currentNodeStackSize;
    private int nodeStackPtr;
    private int selectedMethodId;
    private long childTotalTime0InTimerUnits;
    private long childTotalTime1InTimerUnits;
    private long totalInvNo;

    public CPUCCTContainer(TimedCPUCCTNode timedCPUCCTNode, CPUResultsSnapshot cPUResultsSnapshot, ProfilingSessionStatus profilingSessionStatus, InstrumentationFilter instrumentationFilter, int n, double[] dArray, int n2, String string) {
        this(cPUResultsSnapshot);
        this.threadId = n2;
        this.threadName = string;
        this.status = profilingSessionStatus;
        this.filter = instrumentationFilter;
        this.collectingTwoTimeStamps = cPUResultsSnapshot.isCollectingTwoTimeStamps();
        this.generateCompactData(timedCPUCCTNode, n);
        this.calculateThreadActiveTimesInMS(dArray, profilingSessionStatus);
        this.rootNode = new PrestimeCPUCCTNodeBacked(this, null, 0);
        if (timedCPUCCTNode.isRoot()) {
            this.rootNode.setThreadNode();
        }
    }

    protected CPUCCTContainer(CPUResultsSnapshot cPUResultsSnapshot) {
        this.cpuResSnapshot = cPUResultsSnapshot;
    }

    public CPUResultsSnapshot getCPUResSnapshot() {
        return this.cpuResSnapshot;
    }

    public int getChildOfsForNodeOfs(int n, int n2) {
        if (this.childOfsSize == 4) {
            return this.get4Bytes(n + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * n2);
        }
        return this.get3Bytes(n + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * n2);
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public FlatProfileContainer getFlatProfile() {
        return this.generateFlatProfile();
    }

    public String[] getMethodClassNameAndSig(int n) {
        return this.cpuResSnapshot.getMethodClassNameAndSig(n, 0);
    }

    public int getMethodIdForNodeOfs(int n) {
        return this.get2Bytes(n + 0);
    }

    public int getNCallsForNodeOfs(int n) {
        return this.get4Bytes(n + 2);
    }

    public int getNChildrenForNodeOfs(int n) {
        return this.get2Bytes(n + (this.collectingTwoTimeStamps ? 26 : 16));
    }

    public PrestimeCPUCCTNode getReverseCCT(int n) {
        return this.generateReverseCCT(n);
    }

    public PrestimeCPUCCTNode getRootNode() {
        return this.rootNode;
    }

    public long getSelfTime0ForNodeOfs(int n) {
        return this.get5Bytes(n + 11);
    }

    public long getSelfTime1ForNodeOfs(int n) {
        return this.get5Bytes(n + 21);
    }

    public long getSleepTime0ForNodeOfs(int n) {
        return 0L;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public static double getTimeInInjectedCodeForDisplayedThread() {
        return timeInInjectedCodeInMS;
    }

    public long getTotalTime0ForNodeOfs(int n) {
        return this.get5Bytes(n + 6);
    }

    public long getTotalTime1ForNodeOfs(int n) {
        return this.get5Bytes(n + 16);
    }

    public long getWaitTime0ForNodeOfs(int n) {
        return 0L;
    }

    public static double getWholeGraphGrossTimeAbsForDisplayedThread() {
        return wholeGraphGrossTimeAbsInMS;
    }

    public long getWholeGraphNetTime0() {
        return this.wholeGraphNetTime0;
    }

    public long getWholeGraphNetTime1() {
        return this.wholeGraphNetTime1;
    }

    public long getWholeGraphPureTimeAbs() {
        return this.wholeGraphPureTimeAbs;
    }

    public long getWholeGraphPureTimeThreadCPU() {
        return this.wholeGraphPureTimeThreadCPU;
    }

    public boolean canDisplayWholeGraphCPUTime() {
        return this.displayWholeThreadCPUTime;
    }

    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        this.threadId = dataInputStream.readInt();
        this.threadName = dataInputStream.readUTF();
        this.collectingTwoTimeStamps = dataInputStream.readBoolean();
        int n = dataInputStream.readInt();
        this.compactData = new byte[n];
        this.childOfsSize = this.compactData.length > 0xFFFFFF ? 4 : 3;
        dataInputStream.readFully(this.compactData);
        this.nodeSize = dataInputStream.readInt();
        this.wholeGraphGrossTimeAbs = dataInputStream.readLong();
        this.wholeGraphGrossTimeThreadCPU = dataInputStream.readLong();
        this.timeInInjectedCodeInAbsCounts = dataInputStream.readDouble();
        this.timeInInjectedCodeInThreadCPUCounts = dataInputStream.readDouble();
        this.wholeGraphPureTimeAbs = dataInputStream.readLong();
        this.wholeGraphPureTimeThreadCPU = dataInputStream.readLong();
        this.wholeGraphNetTime0 = dataInputStream.readLong();
        this.wholeGraphNetTime1 = dataInputStream.readLong();
        this.totalInvNo = dataInputStream.readLong();
        this.displayWholeThreadCPUTime = dataInputStream.readBoolean();
        this.rootNode = new PrestimeCPUCCTNodeBacked(this, null, 0);
        if (this.getMethodIdForNodeOfs(0) == 0) {
            this.rootNode.setThreadNode();
        }
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.threadId);
        dataOutputStream.writeUTF(this.threadName);
        dataOutputStream.writeBoolean(this.collectingTwoTimeStamps);
        dataOutputStream.writeInt(this.compactData.length);
        dataOutputStream.write(this.compactData);
        dataOutputStream.writeInt(this.nodeSize);
        dataOutputStream.writeLong(this.wholeGraphGrossTimeAbs);
        dataOutputStream.writeLong(this.wholeGraphGrossTimeThreadCPU);
        dataOutputStream.writeDouble(this.timeInInjectedCodeInAbsCounts);
        dataOutputStream.writeDouble(this.timeInInjectedCodeInThreadCPUCounts);
        dataOutputStream.writeLong(this.wholeGraphPureTimeAbs);
        dataOutputStream.writeLong(this.wholeGraphPureTimeThreadCPU);
        dataOutputStream.writeLong(this.wholeGraphNetTime0);
        dataOutputStream.writeLong(this.wholeGraphNetTime1);
        dataOutputStream.writeLong(this.totalInvNo);
        dataOutputStream.writeBoolean(this.displayWholeThreadCPUTime);
    }

    protected void setChildOfsForNodeOfs(int n, int n2, int n3) {
        if (this.childOfsSize == 4) {
            this.store4Bytes(n + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * n2, n3);
        } else {
            this.store3Bytes(n + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * n2, n3);
        }
    }

    protected void setMethodIdForNodeOfs(int n, int n2) {
        this.store2Bytes(n + 0, n2);
    }

    protected void setNCallsForNodeOfs(int n, int n2) {
        this.store4Bytes(n + 2, n2);
    }

    protected void setNChildrenForNodeOfs(int n, int n2) {
        this.store2Bytes(n + (this.collectingTwoTimeStamps ? 26 : 16), n2);
    }

    protected void setSelfTime0ForNodeOfs(int n, long l) {
        this.store5Bytes(n + 11, l);
    }

    protected void setSelfTime1ForNodeOfs(int n, long l) {
        this.store5Bytes(n + 21, l);
    }

    protected void setSleepTime0ForNodeOfs(int n, long l) {
    }

    protected void setTotalTime0ForNodeOfs(int n, long l) {
        this.store5Bytes(n + 6, l);
    }

    protected void setTotalTime1ForNodeOfs(int n, long l) {
        this.store5Bytes(n + 16, l);
    }

    protected void setWaitTime0ForNodeOfs(int n, long l) {
    }

    protected void addFlatProfTimeForNode(int n) {
        int n2;
        int n3 = this.getNChildrenForNodeOfs(n);
        if (n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = this.getChildOfsForNodeOfs(n, n2);
                this.addFlatProfTimeForNode(n4);
            }
        }
        int n5 = n2 = this.getMethodIdForNodeOfs(n);
        this.timePerMethodId0[n5] = this.timePerMethodId0[n5] + this.getSelfTime0ForNodeOfs(n);
        if (this.collectingTwoTimeStamps) {
            int n6 = n2;
            this.timePerMethodId1[n6] = this.timePerMethodId1[n6] + this.getSelfTime1ForNodeOfs(n);
        }
        int n7 = n2;
        this.invPerMethodId[n7] = this.invPerMethodId[n7] + this.getNCallsForNodeOfs(n);
    }

    protected void addToReverseCCT(PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree, int n) {
        this.selectedMethodId = n;
        this.reverseCCTRootNode = prestimeCPUCCTNodeFree;
        this.currentNodeStackSize = 320;
        this.nodeStack = new int[this.currentNodeStackSize];
        this.nodeStackPtr = 0;
        this.checkStraightGraphNode(0);
        this.nodeStack = null;
        this.reverseCCTRootNode = null;
    }

    protected void checkStraightGraphNode(int n) {
        if (this.nodeStackPtr >= this.currentNodeStackSize) {
            int[] nArray = new int[this.currentNodeStackSize * 2];
            System.arraycopy(this.nodeStack, 0, nArray, 0, this.currentNodeStackSize);
            this.nodeStack = nArray;
            this.currentNodeStackSize *= 2;
        }
        this.nodeStack[this.nodeStackPtr++] = n;
        if (this.getMethodIdForNodeOfs(n) == this.selectedMethodId) {
            this.addReversePath();
        }
        int n2 = this.getNChildrenForNodeOfs(n);
        for (int i = 0; i < n2; ++i) {
            this.checkStraightGraphNode(this.getChildOfsForNodeOfs(n, i));
        }
        --this.nodeStackPtr;
    }

    protected FlatProfileContainer generateFlatProfile() {
        this.preGenerateFlatProfile();
        this.addFlatProfTimeForNode(0);
        return this.postGenerateFlatProfile();
    }

    protected PrestimeCPUCCTNodeFree generateReverseCCT(int n) {
        this.selectedMethodId = n;
        this.currentNodeStackSize = 320;
        this.nodeStack = new int[this.currentNodeStackSize];
        this.nodeStackPtr = 0;
        this.checkStraightGraphNode(0);
        PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree = this.reverseCCTRootNode;
        this.nodeStack = null;
        this.reverseCCTRootNode = null;
        return prestimeCPUCCTNodeFree;
    }

    protected int get2Bytes(int n) {
        return (this.compactData[n] & 0xFF) << 8 | this.compactData[n + 1] & 0xFF;
    }

    protected int get3Bytes(int n) {
        return (this.compactData[n++] & 0xFF) << 16 | (this.compactData[n++] & 0xFF) << 8 | this.compactData[n++] & 0xFF;
    }

    protected int get4Bytes(int n) {
        return (this.compactData[n++] & 0xFF) << 24 | (this.compactData[n++] & 0xFF) << 16 | (this.compactData[n++] & 0xFF) << 8 | this.compactData[n++] & 0xFF;
    }

    protected long get5Bytes(int n) {
        return ((long)this.compactData[n++] & 0xFFL) << 32 | ((long)this.compactData[n++] & 0xFFL) << 24 | ((long)this.compactData[n++] & 0xFFL) << 16 | ((long)this.compactData[n++] & 0xFFL) << 8 | (long)this.compactData[n++] & 0xFFL;
    }

    protected FlatProfileContainer postGenerateFlatProfile() {
        FlatProfileContainerBacked flatProfileContainerBacked = new FlatProfileContainerBacked(this, this.timePerMethodId0, this.timePerMethodId1, this.invPerMethodId, this.timePerMethodId0.length);
        this.timePerMethodId1 = null;
        this.timePerMethodId0 = null;
        this.invPerMethodId = null;
        return flatProfileContainerBacked;
    }

    protected void preGenerateFlatProfile() {
        int n = this.cpuResSnapshot.getNInstrMethods();
        this.timePerMethodId0 = new long[n];
        if (this.collectingTwoTimeStamps) {
            this.timePerMethodId1 = new long[n];
        }
        this.invPerMethodId = new int[n];
        this.timePerMethodId0[0] = -1L;
    }

    protected void store2Bytes(int n, int n2) {
        this.compactData[n] = (byte)(n2 >> 8 & 0xFF);
        this.compactData[n + 1] = (byte)(n2 & 0xFF);
    }

    protected void store3Bytes(int n, int n2) {
        int n3 = n;
        this.compactData[n3++] = (byte)(n2 >> 16 & 0xFF);
        this.compactData[n3++] = (byte)(n2 >> 8 & 0xFF);
        this.compactData[n3++] = (byte)(n2 & 0xFF);
    }

    protected void store4Bytes(int n, int n2) {
        int n3 = n;
        this.compactData[n3++] = (byte)(n2 >> 24 & 0xFF);
        this.compactData[n3++] = (byte)(n2 >> 16 & 0xFF);
        this.compactData[n3++] = (byte)(n2 >> 8 & 0xFF);
        this.compactData[n3++] = (byte)(n2 & 0xFF);
    }

    protected void store5Bytes(int n, long l) {
        int n2 = n;
        this.compactData[n2++] = (byte)(l >> 32 & 0xFFL);
        this.compactData[n2++] = (byte)(l >> 24 & 0xFFL);
        this.compactData[n2++] = (byte)(l >> 16 & 0xFFL);
        this.compactData[n2++] = (byte)(l >> 8 & 0xFFL);
        this.compactData[n2++] = (byte)(l & 0xFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChild(TimedCPUCCTNode timedCPUCCTNode, TimedCPUCCTNode timedCPUCCTNode2) {
        if (timedCPUCCTNode == null || timedCPUCCTNode2 == null) {
            return;
        }
        TimedCPUCCTNode timedCPUCCTNode3 = null;
        TimedCPUCCTNode timedCPUCCTNode4 = null;
        int n = timedCPUCCTNode.getFilteredStatus();
        if (!(timedCPUCCTNode instanceof MethodCPUCCTNode)) {
            n = 2;
        }
        switch (n) {
            case 2: {
                timedCPUCCTNode3 = timedCPUCCTNode2;
                break;
            }
            case 1: {
                Object object;
                if (timedCPUCCTNode instanceof MethodCPUCCTNode) {
                    this.status.beginTrans(false);
                    try {
                        object = this.status.getInstrMethodClasses()[((MethodCPUCCTNode)timedCPUCCTNode).getMethodId()].replace('.', '/');
                        if (!this.filter.passesFilter((String)object)) {
                            timedCPUCCTNode3 = timedCPUCCTNode2;
                            break;
                        }
                        timedCPUCCTNode3 = timedCPUCCTNode4 = (TimedCPUCCTNode)timedCPUCCTNode.clone();
                        break;
                    }
                    finally {
                        this.status.endTrans();
                    }
                }
                timedCPUCCTNode3 = timedCPUCCTNode2;
                break;
            }
            case 0: {
                Object object = MethodCPUCCTNode.Locator.locate(((MethodCPUCCTNode)timedCPUCCTNode).getMethodId(), timedCPUCCTNode2.getChildren());
                if (object == null) {
                    timedCPUCCTNode4 = (TimedCPUCCTNode)timedCPUCCTNode.clone();
                } else {
                    timedCPUCCTNode4 = null;
                    ((TimedCPUCCTNode)object).addNCalls(timedCPUCCTNode.getNCalls());
                    ((TimedCPUCCTNode)object).addNCallsDiff(timedCPUCCTNode.getNCallsDiff());
                    ((TimedCPUCCTNode)object).addNetTime0(timedCPUCCTNode.getNetTime0());
                    ((TimedCPUCCTNode)object).addNetTime1(timedCPUCCTNode.getNetTime1());
                    ((TimedCPUCCTNode)object).addSleepTime0(timedCPUCCTNode.getSleepTime0());
                    ((TimedCPUCCTNode)object).addWaitTime0(timedCPUCCTNode.getWaitTime0());
                }
                timedCPUCCTNode3 = timedCPUCCTNode4;
                break;
            }
            default: {
                ProfilerLogger.warning("Unknown filtered status (" + n + ") for " + timedCPUCCTNode);
            }
        }
        int n2 = timedCPUCCTNode.getChildren() != null ? timedCPUCCTNode.getChildren().size() : 0;
        for (int i = 0; i < n2; ++i) {
            this.addChild((TimedCPUCCTNode)timedCPUCCTNode.getChildren().getChildAt(i), timedCPUCCTNode3);
        }
        if (timedCPUCCTNode4 != null) {
            timedCPUCCTNode2.attachNodeAsChild(timedCPUCCTNode4);
        } else if (!timedCPUCCTNode2.isRoot()) {
            timedCPUCCTNode2.addNetTime0(timedCPUCCTNode.getNetTime0());
            timedCPUCCTNode2.addNCallsDiff(timedCPUCCTNode.getNCalls());
            if (this.collectingTwoTimeStamps) {
                timedCPUCCTNode2.addNetTime1(timedCPUCCTNode.getNetTime1());
            }
        }
    }

    private void addReversePath() {
        int n;
        Object object = null;
        for (int i = n = this.nodeStackPtr - 1; i >= 0; --i) {
            int n2;
            Object object2;
            int n3 = this.nodeStack[i];
            int n4 = this.getMethodIdForNodeOfs(n3);
            if (n4 == 0) {
                return;
            }
            boolean bl = false;
            if (i < n) {
                object2 = (PrestimeCPUCCTNodeFree[])((PrestimeCPUCCTNodeFree)object).getChildren();
                if (object2 != null) {
                    for (int j = 0; j < ((PrestimeCPUCCTNodeFree[])object2).length; ++j) {
                        if (object2[j].getMethodId() != n4) continue;
                        object = object2[j];
                        if (((PrestimeCPUCCTNode)object).isContextCallsNode()) {
                            n2 = this.nodeStack[i + 1];
                            this.mergeBySelfTime((PrestimeCPUCCTNodeFree)object, n2);
                            object = (PrestimeCPUCCTNodeFree)((PrestimeCPUCCTNodeFree)object).getChildren()[0];
                        }
                        this.mergeBySelfTime((PrestimeCPUCCTNodeFree)object, n3);
                        bl = true;
                        break;
                    }
                }
            } else {
                object = this.reverseCCTRootNode;
                if (object == null) {
                    object = this.createChildlessCopyBySelfTime(n3);
                    this.reverseCCTRootNode = object;
                } else {
                    this.mergeBySelfTime((PrestimeCPUCCTNodeFree)object, n3);
                }
                bl = true;
            }
            if (bl) continue;
            object2 = this.createChildlessCopyBySelfTime(n3);
            PrestimeCPUCCTNodeFree[] prestimeCPUCCTNodeFreeArray = (PrestimeCPUCCTNodeFree[])((PrestimeCPUCCTNodeFree)object).getChildren();
            if (prestimeCPUCCTNodeFreeArray != null) {
                PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree;
                n2 = this.nodeStack[i + 1];
                if (prestimeCPUCCTNodeFreeArray.length == 1) {
                    prestimeCPUCCTNodeFree = prestimeCPUCCTNodeFreeArray[0];
                    PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree2 = ((PrestimeCPUCCTNodeFree)object).createChildlessCopy();
                    this.subtractNodeDataBySelfTime(prestimeCPUCCTNodeFree2, n2);
                    prestimeCPUCCTNodeFree2.setMethodId(prestimeCPUCCTNodeFree.getMethodId());
                    prestimeCPUCCTNodeFree2.setContextCallsNode();
                    prestimeCPUCCTNodeFreeArray[0] = prestimeCPUCCTNodeFree2;
                    prestimeCPUCCTNodeFree2.parent = object;
                    prestimeCPUCCTNodeFree2.addChild(prestimeCPUCCTNodeFree);
                    prestimeCPUCCTNodeFree.parent = prestimeCPUCCTNodeFree2;
                }
                prestimeCPUCCTNodeFree = this.createChildlessCopyBySelfTime(n2);
                prestimeCPUCCTNodeFree.setMethodId(this.getMethodIdForNodeOfs(n3));
                prestimeCPUCCTNodeFree.setContextCallsNode();
                ((PrestimeCPUCCTNodeFree)object).addChild(prestimeCPUCCTNodeFree);
                prestimeCPUCCTNodeFree.parent = object;
                object = prestimeCPUCCTNodeFree;
            }
            ((PrestimeCPUCCTNodeFree)object).addChild((PrestimeCPUCCTNodeFree)object2);
            ((PrestimeCPUCCTNodeFree)object2).parent = object;
            object = object2;
        }
    }

    private void calculateThreadActiveTimesInMS(double[] dArray, ProfilingSessionStatus profilingSessionStatus) {
        this.wholeGraphGrossTimeAbs = (long)dArray[0];
        this.wholeGraphGrossTimeThreadCPU = (long)dArray[1];
        this.timeInInjectedCodeInAbsCounts = dArray[2];
        this.timeInInjectedCodeInThreadCPUCounts = dArray[3];
        wholeGraphGrossTimeAbsInMS += (double)this.wholeGraphGrossTimeAbs * 1000.0 / (double)profilingSessionStatus.timerCountsInSecond[0];
        timeInInjectedCodeInMS += this.timeInInjectedCodeInAbsCounts * 1000.0 / (double)profilingSessionStatus.timerCountsInSecond[0];
        this.wholeGraphPureTimeAbs += (long)((int)(((double)this.wholeGraphGrossTimeAbs - this.timeInInjectedCodeInAbsCounts) * 1000000.0 / (double)profilingSessionStatus.timerCountsInSecond[0]));
        if (this.wholeGraphGrossTimeThreadCPU > 0L) {
            this.displayWholeThreadCPUTime = true;
            this.wholeGraphPureTimeThreadCPU += (long)((int)(((double)this.wholeGraphGrossTimeThreadCPU - this.timeInInjectedCodeInThreadCPUCounts) * 1000000.0 / (double)profilingSessionStatus.timerCountsInSecond[1]));
        } else {
            this.displayWholeThreadCPUTime = false;
        }
        if (this.wholeGraphPureTimeAbs < 0L) {
            this.wholeGraphPureTimeAbs = 0L;
        }
        if (this.wholeGraphPureTimeThreadCPU < 0L) {
            this.wholeGraphPureTimeThreadCPU = 0L;
        }
        this.wholeGraphNetTime0 += this.get5Bytes(6);
        if (this.collectingTwoTimeStamps) {
            this.wholeGraphNetTime1 += this.get5Bytes(16);
        }
    }

    private PrestimeCPUCCTNodeFree createChildlessCopyBySelfTime(int n) {
        PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree = new PrestimeCPUCCTNodeFree(this, null, this.getMethodIdForNodeOfs(n));
        this.mergeBySelfTime(prestimeCPUCCTNodeFree, n);
        return prestimeCPUCCTNodeFree;
    }

    private TimedCPUCCTNode filterCCT(TimedCPUCCTNode timedCPUCCTNode) {
        TimedCPUCCTNode timedCPUCCTNode2 = (TimedCPUCCTNode)timedCPUCCTNode.clone();
        int n = timedCPUCCTNode.getChildren() != null ? timedCPUCCTNode.getChildren().size() : 0;
        for (int i = 0; i < n; ++i) {
            this.addChild((TimedCPUCCTNode)timedCPUCCTNode.getChildren().getChildAt(i), timedCPUCCTNode2);
        }
        timedCPUCCTNode2.setNetTime0(0L);
        if (this.collectingTwoTimeStamps) {
            timedCPUCCTNode2.setNetTime1(0L);
        }
        return timedCPUCCTNode2;
    }

    private void generateCompactData(TimedCPUCCTNode timedCPUCCTNode, int n) {
        this.nodeSize = this.collectingTwoTimeStamps ? 28 : 18;
        this.childOfsSize = 3;
        int n2 = this.nodeSize * n + this.childOfsSize * (n - 1);
        if (n2 > 0xFFFFFF) {
            this.childOfsSize = 4;
            n2 = this.nodeSize * n + this.childOfsSize * (n - 1);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("generateCompact data: nNodes " + n);
            LOGGER.finest("generateCompact data: node size " + this.nodeSize);
            LOGGER.finest("generateCompact data: array size " + n2);
            LOGGER.finest("generateCompact data: child offset " + this.childOfsSize);
        }
        this.compactData = new byte[n2];
        timedCPUCCTNode = this.filterCCT(timedCPUCCTNode);
        this.generateMirrorNode(timedCPUCCTNode, 0);
    }

    private int generateMirrorNode(TimedCPUCCTNode timedCPUCCTNode, int n) {
        long l;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Generate mirror node for ofs: " + n + ", node: " + timedCPUCCTNode);
        }
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        int n3 = 0;
        this.generateNodeBase(timedCPUCCTNode, n);
        this.totalInvNo += (long)timedCPUCCTNode.getNCalls();
        RuntimeCPUCCTNode.Children children = timedCPUCCTNode.getChildren();
        int n4 = children != null ? children.size() : 0;
        int n5 = n + this.nodeSize + n4 * this.childOfsSize;
        n2 += timedCPUCCTNode.getNCallsDiff();
        if (n4 > 0) {
            int n6 = 0;
            for (int i = 0; i < n4; ++i) {
                RuntimeCPUCCTNode runtimeCPUCCTNode = children.getChildAt(i);
                if (!(runtimeCPUCCTNode instanceof MethodCPUCCTNode)) continue;
                this.setChildOfsForNodeOfs(n, n6, n5);
                n5 = this.generateMirrorNode((MethodCPUCCTNode)runtimeCPUCCTNode, n5);
                l2 += this.childTotalTime0InTimerUnits;
                if (this.collectingTwoTimeStamps) {
                    l3 += this.childTotalTime1InTimerUnits;
                }
                n2 += ((MethodCPUCCTNode)runtimeCPUCCTNode).getNCalls();
                n3 += this.childTotalNCalls;
                ++n6;
            }
        }
        if ((l = (long)TimingAdjusterOld.getDefault(this.status).adjustTime(timedCPUCCTNode.getNetTime0(), timedCPUCCTNode.getNCalls(), n2, false)) < 0L) {
            l = 0L;
        }
        this.setSelfTime0ForNodeOfs(n, l);
        this.setWaitTime0ForNodeOfs(n, timedCPUCCTNode.getWaitTime0());
        this.setSleepTime0ForNodeOfs(n, timedCPUCCTNode.getSleepTime0());
        this.childTotalTime0InTimerUnits = l2 += timedCPUCCTNode.getNetTime0();
        l = (long)TimingAdjusterOld.getDefault(this.status).adjustTime(l2, timedCPUCCTNode.getNCalls(), n3, false);
        if (l < 0L) {
            l = 0L;
        }
        this.setTotalTime0ForNodeOfs(n, l);
        if (this.collectingTwoTimeStamps) {
            l = (long)TimingAdjusterOld.getDefault(this.status).adjustTime(timedCPUCCTNode.getNetTime1(), timedCPUCCTNode.getNCalls(), n2, true);
            if (l < 0L) {
                l = 0L;
            }
            this.setSelfTime1ForNodeOfs(n, l);
            this.childTotalTime1InTimerUnits = l3 += timedCPUCCTNode.getNetTime1();
            l = (long)TimingAdjusterOld.getDefault(this.status).adjustTime(l3, timedCPUCCTNode.getNCalls(), n3, true);
            if (l < 0L) {
                l = 0L;
            }
            this.setTotalTime1ForNodeOfs(n, l);
        }
        this.childTotalNCalls = n3 + timedCPUCCTNode.getNCalls();
        return n5;
    }

    private void generateNodeBase(TimedCPUCCTNode timedCPUCCTNode, int n) {
        int n2 = timedCPUCCTNode instanceof MethodCPUCCTNode ? ((MethodCPUCCTNode)timedCPUCCTNode).getMethodId() : 0;
        int n3 = timedCPUCCTNode.getNCalls();
        int n4 = timedCPUCCTNode.getChildren() != null ? timedCPUCCTNode.getChildren().size() : 0;
        this.setMethodIdForNodeOfs(n, n2);
        this.setNCallsForNodeOfs(n, n3);
        this.setNChildrenForNodeOfs(n, n4);
    }

    private void mergeBySelfTime(PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree, int n) {
        prestimeCPUCCTNodeFree.addNCalls(this.getNCallsForNodeOfs(n));
        prestimeCPUCCTNodeFree.addTotalTime0(this.getSelfTime0ForNodeOfs(n));
        if (this.collectingTwoTimeStamps) {
            prestimeCPUCCTNodeFree.addTotalTime1(this.getSelfTime1ForNodeOfs(n));
        }
        prestimeCPUCCTNodeFree.addWaitTime0(this.getWaitTime0ForNodeOfs(n));
        prestimeCPUCCTNodeFree.addSleepTime0(this.getSleepTime0ForNodeOfs(n));
    }

    private void subtractNodeDataBySelfTime(PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree, int n) {
        prestimeCPUCCTNodeFree.addNCalls(-this.getNCallsForNodeOfs(n));
        prestimeCPUCCTNodeFree.addTotalTime0(-this.getSelfTime0ForNodeOfs(n));
        if (this.collectingTwoTimeStamps) {
            prestimeCPUCCTNodeFree.addTotalTime1(-this.getSelfTime1ForNodeOfs(n));
        }
        prestimeCPUCCTNodeFree.addWaitTime0(-this.getWaitTime0ForNodeOfs(n));
        prestimeCPUCCTNodeFree.addSleepTime0(-this.getSleepTime0ForNodeOfs(n));
    }
}

