/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.faces.dt.converter;

import com.sun.rave.designtime.DesignProperty;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.netbeans.modules.visualweb.faces.dt.converter.NumberPatternPropertyEditor;
import org.openide.util.NbBundle;

public class NumberPatternPanel
extends JPanel {
    private DesignProperty designProperty;
    private NumberPatternPropertyEditor propertyEditor;
    private JButton btnTest;
    private JComboBox cmbExample;
    private JComboBox cmbPattern;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JLabel lblExample;
    private JLabel lblPattern;
    private JLabel lblResults;
    private JPanel pnlExample;
    private JTextPane txtExampleInstructions;
    private JTextField txtResults;

    public NumberPatternPanel(NumberPatternPropertyEditor numberPatternPropertyEditor, DesignProperty designProperty) {
        this.propertyEditor = numberPatternPropertyEditor;
        this.designProperty = designProperty;
        this.initComponents();
        NumberFormat numberFormat = NumberFormat.getInstance();
        NumberFormat numberFormat2 = NumberFormat.getIntegerInstance();
        NumberFormat numberFormat3 = NumberFormat.getCurrencyInstance();
        NumberFormat numberFormat4 = NumberFormat.getPercentInstance();
        this.cmbPattern.setModel(new DefaultComboBoxModel<String>(new String[]{"", ((DecimalFormat)numberFormat).toPattern(), ((DecimalFormat)numberFormat2).toPattern(), ((DecimalFormat)numberFormat3).toPattern(), ((DecimalFormat)numberFormat4).toPattern()}));
        this.cmbExample.setModel(new DefaultComboBoxModel<String>(new String[]{"1234.56", "-1234.56", "123.4567", "0.123", "01234"}));
        if (this.designProperty != null) {
            this.cmbPattern.setSelectedItem(this.designProperty.getValue());
        }
    }

    public void addPatternListener(ActionListener actionListener) {
        this.cmbPattern.addActionListener(actionListener);
    }

    private boolean upateSampleResult() {
        double d = 0.0;
        try {
            if (this.cmbExample.getSelectedItem() == null || ((String)this.cmbExample.getSelectedItem()).trim().length() == 0) {
                return true;
            }
            d = Double.parseDouble((String)this.cmbExample.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            this.txtResults.setText(NbBundle.getMessage(NumberPatternPanel.class, (String)"notANumber", (Object)((String)this.cmbExample.getSelectedItem())));
            return false;
        }
        try {
            if (this.cmbPattern.getSelectedItem() == null || ((String)this.cmbPattern.getSelectedItem()).trim().length() == 0) {
                return true;
            }
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance();
            decimalFormat.applyPattern(((String)this.cmbPattern.getSelectedItem()).trim());
            this.txtResults.setText(decimalFormat.format(d));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.txtResults.setText(NbBundle.getMessage(NumberPatternPanel.class, (String)"badPattern", (Object)((String)this.cmbPattern.getSelectedItem())));
            return false;
        }
        return true;
    }

    private void initComponents() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/faces/dt/converter/Bundle");
        this.lblPattern = new JLabel();
        this.cmbPattern = new JComboBox();
        this.pnlExample = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.lblExample = new JLabel();
        this.txtResults = new JTextField();
        this.lblResults = new JLabel();
        this.cmbExample = new JComboBox();
        this.btnTest = new JButton();
        this.txtExampleInstructions = new JTextPane();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblPattern.setLabelFor(this.cmbPattern);
        this.lblPattern.setText(resourceBundle.getString("pattern"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.lblPattern, gridBagConstraints);
        this.lblPattern.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("pattern"));
        this.cmbPattern.setEditable(true);
        this.cmbPattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberPatternPanel.this.cmbPatternActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.cmbPattern, gridBagConstraints);
        this.cmbPattern.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("pattern"));
        this.pnlExample.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.pnlExample.add((Component)this.jSeparator1, gridBagConstraints);
        this.lblExample.setDisplayedMnemonic(resourceBundle.getString("example_mnemonic").charAt(0));
        this.lblExample.setLabelFor(this.cmbExample);
        this.lblExample.setText(resourceBundle.getString("example"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.pnlExample.add((Component)this.lblExample, gridBagConstraints);
        this.lblExample.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("example"));
        this.txtResults.setEditable(false);
        this.txtResults.setText("1234.56");
        this.txtResults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberPatternPanel.this.txtResultsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.pnlExample.add((Component)this.txtResults, gridBagConstraints);
        this.txtResults.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("results"));
        this.lblResults.setDisplayedMnemonic(resourceBundle.getString("result_mnemonic").charAt(0));
        this.lblResults.setLabelFor(this.txtResults);
        this.lblResults.setText(resourceBundle.getString("results"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.pnlExample.add((Component)this.lblResults, gridBagConstraints);
        this.lblResults.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("results"));
        this.cmbExample.setEditable(true);
        this.cmbExample.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberPatternPanel.this.cmbExampleActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.pnlExample.add((Component)this.cmbExample, gridBagConstraints);
        this.cmbExample.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("example"));
        this.btnTest.setMnemonic(resourceBundle.getString("testBtn_mnemonic").charAt(0));
        this.btnTest.setText(resourceBundle.getString("testText"));
        this.btnTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberPatternPanel.this.btnTestActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.pnlExample.add((Component)this.btnTest, gridBagConstraints);
        this.btnTest.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("testText"));
        this.txtExampleInstructions.setBackground(this.getBackground());
        this.txtExampleInstructions.setBorder(null);
        this.txtExampleInstructions.setEditable(false);
        this.txtExampleInstructions.setText(resourceBundle.getString("exampleInstructionsText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 11);
        this.pnlExample.add((Component)this.txtExampleInstructions, gridBagConstraints);
        this.txtExampleInstructions.getAccessibleContext().setAccessibleName(resourceBundle.getString("exampleInstructionsText"));
        this.txtExampleInstructions.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("exampleInstructionsText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.pnlExample, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void txtResultsActionPerformed(ActionEvent actionEvent) {
    }

    private void cmbExampleActionPerformed(ActionEvent actionEvent) {
        this.upateSampleResult();
    }

    private void btnTestActionPerformed(ActionEvent actionEvent) {
        this.upateSampleResult();
    }

    private void cmbPatternActionPerformed(ActionEvent actionEvent) {
        if (this.upateSampleResult()) {
            this.propertyEditor.setAsText((String)this.cmbPattern.getSelectedItem());
        }
    }
}

