/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.wizard;

import java.util.Collection;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.localized.LocalizedTemplate;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.NotificationOperation;
import org.netbeans.modules.xml.wsdl.model.OneWayOperation;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.SolicitResponseOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.model.StringAttribute;
import org.netbeans.modules.xml.wsdl.ui.wizard.Command;
import org.netbeans.modules.xml.wsdl.ui.wizard.WsdlGenerationUtil;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

public class BindingOperationGenerator
implements Command {
    private WSDLModel mModel;
    private WsdlGenerationUtil mUtil;
    private Binding mBinding;
    private String namespace;
    private Operation[] mOperations;
    private BindingOperation lastAddedBindingOperation;

    public BindingOperationGenerator(Binding binding, String string, Operation[] operationArray) {
        this.mModel = binding.getModel();
        this.mUtil = new WsdlGenerationUtil(this.mModel);
        this.namespace = string;
        this.mOperations = operationArray;
        this.mBinding = binding;
    }

    public BindingOperation getBindingOperation() {
        return this.lastAddedBindingOperation;
    }

    public void execute() {
        LocalizedTemplate localizedTemplate = null;
        if (localizedTemplate != null) {
            for (Operation operation : this.mOperations) {
                BindingOperation bindingOperation = this.mModel.getFactory().createBindingOperation();
                this.mBinding.addBindingOperation(bindingOperation);
                NamedComponentReference namedComponentReference = bindingOperation.createReferenceTo((ReferenceableWSDLComponent)operation, Operation.class);
                bindingOperation.setOperation((Reference)namedComponentReference);
                this.createAndAddBindingOperationProtocolElements(bindingOperation, localizedTemplate, operation);
                this.lastAddedBindingOperation = bindingOperation;
            }
        } else {
            for (Operation operation : this.mOperations) {
                BindingOperation bindingOperation = this.mModel.getFactory().createBindingOperation();
                if (operation != null) {
                    Object object;
                    bindingOperation.setName(operation.getName());
                    Input input = operation.getInput();
                    Output output = operation.getOutput();
                    Collection collection = operation.getFaults();
                    if (input != null) {
                        object = this.mModel.getFactory().createBindingInput();
                        if (input.getName() != null) {
                            object.setName(input.getName());
                        }
                        bindingOperation.setBindingInput((BindingInput)object);
                    }
                    if (output != null) {
                        object = this.mModel.getFactory().createBindingOutput();
                        if (output.getName() != null) {
                            object.setName(output.getName());
                        }
                        bindingOperation.setBindingOutput((BindingOutput)object);
                    }
                    if (collection != null) {
                        for (Fault fault : collection) {
                            BindingFault bindingFault = this.mModel.getFactory().createBindingFault();
                            if (fault.getName() != null) {
                                bindingFault.setName(fault.getName());
                            }
                            bindingOperation.addBindingFault(bindingFault);
                        }
                    }
                }
                this.mBinding.addBindingOperation(bindingOperation);
                this.lastAddedBindingOperation = bindingOperation;
            }
        }
    }

    private void createAndAddBindingOperationProtocolElements(BindingOperation bindingOperation, LocalizedTemplate localizedTemplate, Operation operation) {
        Output output;
        this.mUtil.createAndAddExtensionElementAndAttribute("BindingOperation", localizedTemplate, (WSDLComponent)bindingOperation);
        if (operation instanceof RequestResponseOperation) {
            Object object;
            Input input = operation.getInput();
            Output output2 = operation.getOutput();
            Collection collection = operation.getFaults();
            if (input != null) {
                object = this.createAndAddBindingOperationInput(bindingOperation, localizedTemplate);
                if (input.getAttribute((Attribute)new StringAttribute("name")) != null) {
                    object.setName(input.getName());
                }
            }
            if (output2 != null) {
                object = this.createAndAddBindingOperationOutput(bindingOperation, localizedTemplate);
                if (output2.getAttribute((Attribute)new StringAttribute("name")) != null) {
                    object.setName(output2.getName());
                }
            }
            if (collection != null) {
                for (Fault fault : collection) {
                    BindingFault bindingFault = this.createAndAddBindingOperationFault(bindingOperation, localizedTemplate);
                    bindingFault.setName(fault.getName());
                }
            }
        } else if (operation instanceof OneWayOperation) {
            Input input = operation.getInput();
            if (input != null) {
                BindingInput bindingInput = this.createAndAddBindingOperationInput(bindingOperation, localizedTemplate);
                if (input.getAttribute((Attribute)new StringAttribute("name")) != null) {
                    bindingInput.setName(input.getName());
                }
            }
        } else if (operation instanceof SolicitResponseOperation) {
            Object object;
            Input input = operation.getInput();
            Output output3 = operation.getOutput();
            Collection collection = operation.getFaults();
            if (input != null) {
                object = this.createAndAddBindingOperationInput(bindingOperation, localizedTemplate);
                if (input.getAttribute((Attribute)new StringAttribute("name")) != null) {
                    object.setName(input.getName());
                }
            }
            if (output3 != null) {
                object = this.createAndAddBindingOperationOutput(bindingOperation, localizedTemplate);
                if (output3.getAttribute((Attribute)new StringAttribute("name")) != null) {
                    object.setName(output3.getName());
                }
            }
            if (collection != null) {
                for (Fault fault : collection) {
                    BindingFault bindingFault = this.createAndAddBindingOperationFault(bindingOperation, localizedTemplate);
                    bindingFault.setName(fault.getName());
                }
            }
        } else if (operation instanceof NotificationOperation && (output = operation.getOutput()) != null) {
            BindingOutput bindingOutput = this.createAndAddBindingOperationOutput(bindingOperation, localizedTemplate);
            if (output.getAttribute((Attribute)new StringAttribute("name")) != null) {
                bindingOutput.setName(output.getName());
            }
        }
    }

    private BindingInput createAndAddBindingOperationInput(BindingOperation bindingOperation, LocalizedTemplate localizedTemplate) {
        BindingInput bindingInput = this.mModel.getFactory().createBindingInput();
        bindingOperation.setBindingInput(bindingInput);
        this.mUtil.createAndAddExtensionElementAndAttribute("BindingOperationInput", localizedTemplate, (WSDLComponent)bindingInput);
        return bindingInput;
    }

    private BindingOutput createAndAddBindingOperationOutput(BindingOperation bindingOperation, LocalizedTemplate localizedTemplate) {
        BindingOutput bindingOutput = this.mModel.getFactory().createBindingOutput();
        bindingOperation.setBindingOutput(bindingOutput);
        this.mUtil.createAndAddExtensionElementAndAttribute("BindingOperationOutput", localizedTemplate, (WSDLComponent)bindingOutput);
        return bindingOutput;
    }

    private BindingFault createAndAddBindingOperationFault(BindingOperation bindingOperation, LocalizedTemplate localizedTemplate) {
        BindingFault bindingFault = this.mModel.getFactory().createBindingFault();
        bindingOperation.addBindingFault(bindingFault);
        this.mUtil.createAndAddExtensionElementAndAttribute("BindingOperationFault", localizedTemplate, (WSDLComponent)bindingFault);
        return bindingFault;
    }
}

