/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.componentssupport.ui.UIUtils;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.CustomComponentVisualPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.EditableListModel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.JavaMELibsVisualPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NewComponentDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DescriptorsVisualPanel
extends JPanel {
    private static final String CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String DLD_DELETE_TITLE = "MSG_ComponentDeleteTitle";
    private static final String DLD_DELETE_MSG = "MSG_ComponentDeleteMsg";
    private static final String ACSN_DESC_PANEL = "ACSN_DescPanel";
    private static final String ACSD_DESC_PANEL = "ACSD_DescPanel";
    private JScrollPane jScrollPane1;
    private JButton myAddButton;
    private JLabel myCompDescrLabel;
    private JList myCompDescrList;
    private JButton myRemoveButton;
    private WizardDescriptor myWizardDescriptor;
    private WizardDescriptor myInnerDescriptor;

    public DescriptorsVisualPanel() {
        this.initComponents();
        this.initAccessibility();
        this.myCompDescrList.setModel(new CompDescriptorsListModel());
        this.myCompDescrList.getSelectionModel().setSelectionMode(0);
        this.myCompDescrList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DescriptorsVisualPanel.this.updateRemoveButton();
            }
        });
        this.updateRemoveButton();
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(DescriptorsVisualPanel.class);
    }

    private void updateRemoveButton() {
        if (this.myCompDescrList.isSelectionEmpty()) {
            this.myRemoveButton.setEnabled(false);
        } else {
            this.myRemoveButton.setEnabled(true);
        }
    }

    void readData(WizardDescriptor wizardDescriptor) {
        this.myWizardDescriptor = wizardDescriptor;
        CompDescriptorsListModel compDescriptorsListModel = (CompDescriptorsListModel)this.myCompDescrList.getModel();
        List list = (List)this.myWizardDescriptor.getProperty("customComponents");
        compDescriptorsListModel.updateModel(list);
    }

    void storeData(WizardDescriptor wizardDescriptor) {
    }

    private void initComponents() {
        this.myCompDescrLabel = new JLabel();
        this.myAddButton = new JButton();
        this.myRemoveButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.myCompDescrList = new JList();
        this.myCompDescrLabel.setLabelFor(this.myCompDescrList);
        Mnemonics.setLocalizedText((JLabel)this.myCompDescrLabel, (String)NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"LBL_AddedComponentDescriptors"));
        Mnemonics.setLocalizedText((AbstractButton)this.myAddButton, (String)NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"BTN_AddComponentDescr"));
        this.myAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DescriptorsVisualPanel.this.addPressed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.myRemoveButton, (String)NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"BTN_RemoveComponentDescr"));
        this.myRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DescriptorsVisualPanel.this.removePressed(actionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.myCompDescrList);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.myCompDescrLabel).add((Component)this.jScrollPane1, -1, 321, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.myAddButton, -1, -1, Short.MAX_VALUE).add((Component)this.myRemoveButton, -1, -1, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.myCompDescrLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.myAddButton).addPreferredGap(0).add((Component)this.myRemoveButton).addContainerGap(228, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 280, Short.MAX_VALUE))));
        this.myCompDescrLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"ACSN_AddedComponentDescriptors"));
        this.myCompDescrLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"ACSD_AddedComponentDescriptors"));
        this.myAddButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"ACSN_AddComponentDescr"));
        this.myAddButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"ACSD_AddComponentDescr"));
        this.myRemoveButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"ACSN_RemoveComponentDescr"));
        this.myRemoveButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DescriptorsVisualPanel.class, (String)"ACSD_RemoveComponentDescr"));
    }

    private void addPressed(ActionEvent actionEvent) {
        NewComponentDescriptor newComponentDescriptor = new NewComponentDescriptor(this.myWizardDescriptor);
        this.myInnerDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)newComponentDescriptor);
        this.myInnerDescriptor.putProperty(AUTO_WIZARD_STYLE, (Object)true);
        this.myInnerDescriptor.putProperty(CONTENT_DISPLAYED, (Object)true);
        this.myInnerDescriptor.putProperty(CONTENT_NUMBERED, (Object)true);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.myInnerDescriptor);
        dialog.setVisible(true);
        this.readData(this.myWizardDescriptor);
    }

    private void removePressed(ActionEvent actionEvent) {
        int n = this.myCompDescrList.getSelectedIndex();
        List list = (List)this.myWizardDescriptor.getProperty("customComponents");
        String string = (String)((Map)list.get(n)).get("prefix");
        String string2 = DescriptorsVisualPanel.getMessage(DLD_DELETE_TITLE, new Object[0]);
        String string3 = DescriptorsVisualPanel.getMessage(DLD_DELETE_MSG, string);
        if (!UIUtils.userConfirmOkCancel(string2, string3)) {
            return;
        }
        ((CompDescriptorsListModel)this.myCompDescrList.getModel()).remove(n);
        list.remove(n);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)ACSN_DESC_PANEL));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)ACSD_DESC_PANEL));
    }

    private static String getMessage(String string, Object ... objectArray) {
        return NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)string, (Object[])objectArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompDescriptorsListModel
    extends EditableListModel {
        private CompDescriptorsListModel() {
        }

        public void updateModel(List<Map<String, Object>> list) {
            if (list == null) {
                return;
            }
            this.removeAllElements();
            for (Map<String, Object> map : list) {
                String string = (String)map.get("prefix");
                String string2 = (String)map.get("compDescrTypeId");
                assert (string != null && string2 != null) : "Component data is not consistent";
                this.addElement(string + " [ " + string2 + " ]");
            }
        }
    }
}

