/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentEvent;
import com.nwoods.jgo.JGoUndoManager;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class JGoDocumentChangedEdit
extends AbstractUndoableEdit {
    private JGoUndoManager myUndoManager;
    private boolean myIsBeforeChanging;
    private JGoDocument myDoc;
    private int myHint;
    private int myFlags;
    private Object myObject;
    private int myOldValueInt;
    private Object myOldValue;
    private int myNewValueInt;
    private Object myNewValue;

    public JGoDocumentChangedEdit(JGoDocumentEvent e, JGoUndoManager mgr, boolean isbefore) {
        this.myUndoManager = mgr;
        this.myIsBeforeChanging = isbefore;
        this.myDoc = (JGoDocument)e.getSource();
        this.myHint = e.getHint();
        this.myFlags = e.getFlags();
        this.myObject = e.getObject();
        this.myOldValueInt = e.getPreviousValueInt();
        this.myOldValue = e.getPreviousValue();
        this.myDoc.copyOldValueForUndo(this);
        this.myDoc.copyNewValueForRedo(this);
    }

    public void die() {
        super.die();
        this.myUndoManager = null;
        this.myDoc = null;
        this.myObject = null;
        this.myOldValue = null;
        this.myNewValue = null;
    }

    public String toString() {
        String classname;
        if (this.getObject() != null) {
            classname = this.getObject().getClass().getName();
            classname = classname.substring(classname.lastIndexOf(46) + 1);
        } else {
            classname = "(null)";
        }
        return (this.isBeforeChanging() ? "B " : "") + Integer.toString(this.getHint()) + ": " + Integer.toString(this.getFlags()) + " " + classname + " " + Integer.toString(this.getOldValueInt()) + "/" + (this.getOldValue() != null ? this.getOldValue().toString() : "null") + " --> " + Integer.toString(this.getNewValueInt()) + "/" + (this.getNewValue() != null ? this.getNewValue().toString() : "null");
    }

    public String getPresentationName() {
        return Integer.toString(this.getHint());
    }

    public boolean canUndo() {
        return super.canUndo() && this.myDoc != null;
    }

    public boolean canRedo() {
        return super.canRedo() && this.myDoc != null;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        if (!this.isBeforeChanging()) {
            this.myDoc.changeValue(this, true);
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        if (!this.isBeforeChanging()) {
            this.myDoc.changeValue(this, false);
        }
    }

    public boolean isBeforeChanging() {
        return this.myIsBeforeChanging;
    }

    public JGoDocumentChangedEdit findBeforeChangingEdit() {
        if (this.isBeforeChanging()) {
            return null;
        }
        Vector edits = this.getUndoManager().getCurrentEditVector();
        for (int i = edits.size() - 1; i >= 0; --i) {
            JGoDocumentChangedEdit e;
            UndoableEdit uedit = (UndoableEdit)edits.elementAt(i);
            if (!(uedit instanceof JGoDocumentChangedEdit) || !(e = (JGoDocumentChangedEdit)uedit).isBeforeChanging() || e.getDoc() != this.getDoc() || e.getHint() != this.getHint() || e.getFlags() != this.getFlags() || e.getObject() != this.getObject()) continue;
            return e;
        }
        return null;
    }

    public JGoUndoManager getUndoManager() {
        return this.myUndoManager;
    }

    public JGoDocument getDoc() {
        return this.myDoc;
    }

    public int getHint() {
        return this.myHint;
    }

    public int getFlags() {
        return this.myFlags;
    }

    public Object getObject() {
        return this.myObject;
    }

    public int getValueInt(boolean undo) {
        if (undo) {
            return this.getOldValueInt();
        }
        return this.getNewValueInt();
    }

    public boolean getValueBoolean(boolean undo) {
        if (undo) {
            return this.getOldValueBoolean();
        }
        return this.getNewValueBoolean();
    }

    public Object getValue(boolean undo) {
        if (undo) {
            return this.getOldValue();
        }
        return this.getNewValue();
    }

    public double getValueDouble(boolean undo) {
        if (undo) {
            return this.getOldValueDouble();
        }
        return this.getNewValueDouble();
    }

    public int getOldValueInt() {
        return this.myOldValueInt;
    }

    public void setOldValueInt(int i) {
        this.myOldValueInt = i;
    }

    public boolean getOldValueBoolean() {
        return this.myOldValueInt != 0;
    }

    public void setOldValueBoolean(boolean b) {
        this.myOldValueInt = b ? 1 : 0;
    }

    public Object getOldValue() {
        return this.myOldValue;
    }

    public void setOldValue(Object x) {
        this.myOldValue = x;
    }

    public double getOldValueDouble() {
        return (Double)this.myOldValue;
    }

    public void setOldValueDouble(double d) {
        this.myOldValue = new Double(d);
    }

    public int getNewValueInt() {
        return this.myNewValueInt;
    }

    public void setNewValueInt(int i) {
        this.myNewValueInt = i;
    }

    public boolean getNewValueBoolean() {
        return this.myNewValueInt != 0;
    }

    public void setNewValueBoolean(boolean b) {
        this.myNewValueInt = b ? 1 : 0;
    }

    public Object getNewValue() {
        return this.myNewValue;
    }

    public void setNewValue(Object x) {
        this.myNewValue = x;
    }

    public double getNewValueDouble() {
        return (Double)this.myNewValue;
    }

    public void setNewValueDouble(double d) {
        this.myNewValue = new Double(d);
    }
}

