/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoObject;
import java.awt.Rectangle;
import java.util.EventObject;

public class JGoDocumentEvent
extends EventObject {
    public static final int UPDATE_ALL = 100;
    public static final int STARTED_TRANSACTION = 104;
    public static final int FINISHED_TRANSACTION = 105;
    public static final int ABORTED_TRANSACTION = 106;
    public static final int STARTING_UNDO = 107;
    public static final int FINISHED_UNDO = 108;
    public static final int STARTING_REDO = 109;
    public static final int FINISHED_REDO = 110;
    static final int FIRST_STATE_CHANGED_HINT = 200;
    public static final int INSERTED = 202;
    public static final int CHANGED = 203;
    public static final int REMOVED = 204;
    public static final int SIZE_CHANGED = 205;
    public static final int PAPER_COLOR_CHANGED = 206;
    public static final int MODIFIABLE_CHANGED = 208;
    public static final int TOPLEFT_CHANGED = 209;
    public static final int LAYER_INSERTED = 210;
    public static final int LAYER_REMOVED = 211;
    public static final int LAYER_MOVED = 212;
    public static final int LAYER_VISIBLE_CHANGED = 213;
    public static final int LAYER_MODIFIABLE_CHANGED = 214;
    public static final int LAYER_TRANSPARENCY_CHANGED = 215;
    public static final int LAYER_IDENTIFIER_CHANGED = 217;
    public static final int ARRANGED = 218;
    public static final int MAINTAINS_PARTID_CHANGED = 219;
    public static final int VALID_CYCLE_CHANGED = 220;
    public static final int BEFORE_CHANGING = 32768;
    public static final int LAST = 65535;
    private int myHint;
    private int myFlags;
    private Object myObj;
    private Object myPreviousValue;
    private int myPreviousValueInt;
    private transient Rectangle myTempRectangle = null;

    public JGoDocumentEvent(JGoDocument source, int hint, int flags, Object obj) {
        super(source);
        this.myHint = hint;
        this.myFlags = flags;
        this.myObj = obj;
        this.myPreviousValue = null;
        this.myPreviousValueInt = 0;
    }

    public JGoDocumentEvent(JGoDocument source, int hint, int flags, Object obj, int prevInt, Object prevObj) {
        super(source);
        this.myHint = hint;
        this.myFlags = flags;
        this.myObj = obj;
        this.myPreviousValue = prevObj;
        this.myPreviousValueInt = prevInt;
    }

    public int getHint() {
        return this.myHint & 0xFFFF7FFF;
    }

    void setHint(int hint) {
        this.myHint = hint;
    }

    public int getFlags() {
        return this.myFlags;
    }

    void setFlags(int flags) {
        this.myFlags = flags;
    }

    public JGoObject getJGoObject() {
        if (this.myObj instanceof JGoObject) {
            return (JGoObject)this.myObj;
        }
        return null;
    }

    public Object getObject() {
        return this.myObj;
    }

    void setObject(Object obj) {
        this.myObj = obj;
    }

    public Object getPreviousValue() {
        return this.myPreviousValue;
    }

    public int getPreviousValueInt() {
        return this.myPreviousValueInt;
    }

    public boolean isBeforeChanging() {
        return (this.myHint & 0x8000) != 0;
    }

    void setPreviousValue(Object obj) {
        this.myPreviousValue = obj;
    }

    void setPreviousValueInt(int i) {
        this.myPreviousValueInt = i;
    }

    Rectangle getTempRectangle() {
        if (this.myTempRectangle == null) {
            this.myTempRectangle = new Rectangle(0, 0, 0, 0);
        }
        return this.myTempRectangle;
    }
}

