/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectImporterWizard;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

final class SelectionPanel
extends JPanel {
    private String errorMessage;
    private ButtonGroup buttonGroup;
    private JLabel jLabel1;
    private JLabel note;
    private JButton projectBrowse;
    private JRadioButton projectButton;
    private JButton projectDestBrowse;
    private JTextField projectDestDir;
    private JLabel projectDestLBL;
    private JTextField projectDir;
    private JLabel projectLBL;
    private JLabel workSpaceLBL;
    private JRadioButton workspaceButton;
    private JTextField workspaceDir;
    private JButton worskpaceBrowse;

    public SelectionPanel() {
        this.initComponents();
        this.workspaceDir.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SelectionPanel.this.workspaceChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SelectionPanel.this.workspaceChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.projectDir.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SelectionPanel.this.projectChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SelectionPanel.this.projectChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.projectDestDir.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SelectionPanel.this.projectChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SelectionPanel.this.projectChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.setWorkspaceEnabled(this.workspaceButton.isSelected());
    }

    File getWorkspaceDir() {
        String string = this.workspaceDir.getText();
        if (string != null && string.trim().length() > 0) {
            return FileUtil.normalizeFile((File)new File(string.trim()));
        }
        return null;
    }

    private void workspaceChanged() {
        File file = this.getWorkspaceDir();
        if (file == null) {
            this.setErrorMessage(ProjectImporterWizard.getMessage("MSG_ChooseWorkspace"));
            return;
        }
        boolean bl = EclipseUtils.isRegularWorkSpace(file);
        this.setErrorMessage(bl ? null : ProjectImporterWizard.getMessage("MSG_NotRegularWorkspace", file));
    }

    private void projectChanged() {
        String string = this.getProjectDir();
        if ("".equals(string)) {
            this.setErrorMessage(ProjectImporterWizard.getMessage("MSG_ChooseProject"));
            return;
        }
        File file = new File(string);
        if (!EclipseUtils.isRegularProject(file)) {
            this.setErrorMessage(ProjectImporterWizard.getMessage("MSG_NotRegularProject", string));
            return;
        }
        String string2 = this.projectDestDir.getText().trim();
        if ("".equals(string2)) {
            this.setErrorMessage(ProjectImporterWizard.getMessage("MSG_ChooseProjectDestination"));
            return;
        }
        File file2 = new File(string2, file.getName());
        if (!file2.equals(file) && file2.exists()) {
            this.setErrorMessage(ProjectImporterWizard.getMessage("MSG_ProjectExist", file2.getName()));
            return;
        }
        this.setErrorMessage(null);
    }

    void setErrorMessage(String string) {
        String string2 = this.errorMessage;
        this.errorMessage = string;
        this.firePropertyChange("errorMessage", string2, string);
    }

    boolean isWorkspaceChosen() {
        return this.workspaceButton.isSelected();
    }

    public String getProjectDir() {
        return this.projectDir.getText().trim();
    }

    public String getProjectDestinationDir() {
        if (this.projectDestDir.getText().trim().equals(this.projectDir.getText().trim())) {
            return null;
        }
        return this.projectDestDir.getText().trim();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.workspaceDir = new JTextField();
        this.worskpaceBrowse = new JButton();
        this.workSpaceLBL = new JLabel();
        this.projectDir = new JTextField();
        this.projectBrowse = new JButton();
        this.projectLBL = new JLabel();
        this.projectButton = new JRadioButton();
        this.workspaceButton = new JRadioButton();
        this.projectDestLBL = new JLabel();
        this.projectDestDir = new JTextField();
        this.projectDestBrowse = new JButton();
        this.jLabel1 = new JLabel();
        this.note = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.worskpaceBrowse, (String)NbBundle.getMessage(SelectionPanel.class, (String)"CTL_BrowseButton_B"));
        this.worskpaceBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionPanel.this.worskpaceBrowseActionPerformed(actionEvent);
            }
        });
        this.workSpaceLBL.setLabelFor(this.workspaceDir);
        Mnemonics.setLocalizedText((JLabel)this.workSpaceLBL, (String)NbBundle.getMessage(SelectionPanel.class, (String)"LBL_Workspace"));
        Mnemonics.setLocalizedText((AbstractButton)this.projectBrowse, (String)NbBundle.getMessage(SelectionPanel.class, (String)"CTL_BrowseButton_R"));
        this.projectBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionPanel.this.projectBrowseActionPerformed(actionEvent);
            }
        });
        this.projectLBL.setLabelFor(this.projectDir);
        Mnemonics.setLocalizedText((JLabel)this.projectLBL, (String)NbBundle.getMessage(SelectionPanel.class, (String)"LBL_Project"));
        this.buttonGroup.add(this.projectButton);
        Mnemonics.setLocalizedText((AbstractButton)this.projectButton, (String)NbBundle.getMessage(SelectionPanel.class, (String)"CTL_ProjectButton"));
        this.projectButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionPanel.this.projectButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup.add(this.workspaceButton);
        this.workspaceButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.workspaceButton, (String)NbBundle.getMessage(SelectionPanel.class, (String)"CTL_WorkspaceButton"));
        this.workspaceButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.workspaceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionPanel.this.workspaceButtonActionPerformed(actionEvent);
            }
        });
        this.projectDestLBL.setLabelFor(this.projectDestDir);
        Mnemonics.setLocalizedText((JLabel)this.projectDestLBL, (String)NbBundle.getMessage(SelectionPanel.class, (String)"LBL_ProjectDestination"));
        Mnemonics.setLocalizedText((AbstractButton)this.projectDestBrowse, (String)NbBundle.getMessage(SelectionPanel.class, (String)"CTL_BrowseButton_S"));
        this.projectDestBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionPanel.this.projectDestBrowseActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SelectionPanel.class, (String)"LBL_SpecifyWorkspaceDescription"));
        Mnemonics.setLocalizedText((JLabel)this.note, (String)NbBundle.getMessage(SelectionPanel.class, (String)"LBL_NoteAboutWorkspaceAdvantage"));
        this.note.setVerticalAlignment(1);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, 0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.note, -1, 509, Short.MAX_VALUE).add((Component)this.jLabel1, -1, 509, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.workSpaceLBL).addPreferredGap(0).add((Component)this.workspaceDir, -1, 278, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.worskpaceBrowse)).add((Component)this.workspaceButton).add((Component)this.projectButton).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectDestLBL).add((Component)this.projectLBL)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.projectDir, -1, 289, Short.MAX_VALUE).add((Component)this.projectDestDir, -1, 289, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.projectBrowse).add(2, (Component)this.projectDestBrowse))))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.workspaceButton).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.workSpaceLBL, -2, 29, -2).add((Component)this.worskpaceBrowse).add((Component)this.workspaceDir, -2, -1, -2)).addPreferredGap(0).add((Component)this.projectButton).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLBL, -2, 29, -2).add((Component)this.projectBrowse).add((Component)this.projectDir, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectDestLBL, -2, 29, -2).add((Component)this.projectDestBrowse).add((Component)this.projectDestDir, -2, -1, -2)).add(18, 18, 18).add((Component)this.note, -2, 130, -2).add(0, 0, Short.MAX_VALUE)));
        this.workspaceDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.worskpaceBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.workSpaceLBL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectLBL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.workspaceButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectDestLBL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectDestDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectDestBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.note.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
    }

    private void projectDestBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.projectDestDir.getText());
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setFileHidingEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.projectDestDir.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void projectButtonActionPerformed(ActionEvent actionEvent) {
        this.setWorkspaceEnabled(false);
        this.projectChanged();
        this.projectDir.requestFocusInWindow();
        this.firePropertyChange("workspaceChoosen", true, false);
    }

    private void workspaceButtonActionPerformed(ActionEvent actionEvent) {
        this.setWorkspaceEnabled(true);
        this.workspaceChanged();
        this.firePropertyChange("workspaceChoosen", false, true);
    }

    private void setWorkspaceEnabled(boolean bl) {
        this.workSpaceLBL.setEnabled(bl);
        this.worskpaceBrowse.setEnabled(bl);
        this.workspaceDir.setEnabled(bl);
        this.projectLBL.setEnabled(!bl);
        this.projectBrowse.setEnabled(!bl);
        this.projectDir.setEnabled(!bl);
        this.projectDestBrowse.setEnabled(!bl);
        this.projectDestDir.setEnabled(!bl);
        this.projectDestLBL.setEnabled(!bl);
        this.note.setVisible(!bl);
    }

    private void projectBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.projectDir.getText());
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setFileHidingEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.projectDir.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void worskpaceBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.getWorkspaceDir());
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setFileHidingEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.workspaceDir.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }
}

