/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.refactoring.xsd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.visitor.ChildVisitor;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLVisitor;
import org.netbeans.modules.xml.wsdl.refactoring.WSDLRefactoringElement;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.ErrorManager;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindSchemaUsageVisitor
extends ChildVisitor
implements WSDLVisitor {
    private ReferenceableSchemaComponent referenced;
    private Model model;
    List<WSDLRefactoringElement> elements = new ArrayList<WSDLRefactoringElement>();
    RefactoringSession session;
    XMLRefactoringTransaction transaction;

    public List<WSDLRefactoringElement> findUsages(ReferenceableSchemaComponent referenceableSchemaComponent, Definitions definitions, RefactoringSession refactoringSession, XMLRefactoringTransaction xMLRefactoringTransaction) {
        this.referenced = referenceableSchemaComponent;
        this.model = definitions.getModel();
        this.session = refactoringSession;
        definitions.accept((WSDLVisitor)this);
        return this.elements;
    }

    public void visit(Types types) {
        Collection collection = types.getSchemas();
        if (collection == null || collection.size() == 0) {
            return;
        }
        for (Schema schema : collection) {
            this.collectUsage((Component)schema);
        }
        super.visit(types);
    }

    public void visit(Part part) {
        try {
            if (this.referenced instanceof GlobalElement && part.getElement() != null && part.getElement().references((Referenceable)((GlobalElement)this.referenced)) || this.referenced instanceof GlobalType && part.getType() != null && part.getType().references((Referenceable)((GlobalType)this.referenced))) {
                this.elements.add(new WSDLRefactoringElement(this.model, (Referenceable)this.referenced, (Component)part));
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        super.visit(part);
    }

    private void collectUsage(Component component) {
        WhereUsedQuery whereUsedQuery = new WhereUsedQuery(Lookups.singleton((Object)this.referenced));
        whereUsedQuery.getContext().add((Object)component);
        if (this.transaction != null) {
            whereUsedQuery.getContext().add((Object)this.transaction);
        }
        whereUsedQuery.prepare(this.session);
    }
}

