/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge.impl;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.bridge.BridgeInterface;
import org.apache.tools.ant.module.bridge.IntrospectionHelperProxy;
import org.apache.tools.ant.module.bridge.impl.ForkedJavaOverride;
import org.apache.tools.ant.module.bridge.impl.IntrospectionHelperImpl;
import org.apache.tools.ant.module.bridge.impl.NbAntlib;
import org.apache.tools.ant.module.bridge.impl.NbBuildLogger;
import org.apache.tools.ant.module.bridge.impl.NbInputHandler;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeImpl
implements BridgeInterface {
    private static final int STOP_TIMEOUT = 3000;
    private static boolean classpathInitialized = false;
    private static final Map<Thread, NbBuildLogger> loggersByThread = new WeakHashMap<Thread, NbBuildLogger>();
    private static final RequestProcessor.Task refreshFilesystemsTask = RequestProcessor.getDefault().create(new Runnable(){

        public void run() {
            Logger.getLogger(BridgeImpl.class.getName()).log(Level.FINE, "Refreshing filesystems");
            FileUtil.refreshAll();
        }
    });
    private static boolean doHack36393 = true;
    private static boolean doGutProject = !Boolean.getBoolean("org.apache.tools.ant.module.bridge.impl.BridgeImpl.doNotGutProject");

    public String getAntVersion() {
        try {
            return Main.getAntVersion();
        }
        catch (BuildException be) {
            AntModule.err.notify(1, (Throwable)be);
            return NbBundle.getMessage(BridgeImpl.class, (String)"LBL_ant_version_unknown");
        }
    }

    public boolean isAnt16() {
        try {
            Class.forName("org.apache.tools.ant.taskdefs.Antlib");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public IntrospectionHelperProxy getIntrospectionHelper(Class<?> clazz) {
        return new IntrospectionHelperImpl(clazz);
    }

    public boolean toBoolean(String val) {
        return Project.toBoolean((String)val);
    }

    public String[] getEnumeratedValues(Class<?> c) {
        if (EnumeratedAttribute.class.isAssignableFrom(c)) {
            try {
                return ((EnumeratedAttribute)c.newInstance()).getValues();
            }
            catch (Exception e) {
                AntModule.err.notify(1, (Throwable)e);
            }
        } else if (Enum.class.isAssignableFrom(c)) {
            try {
                Enum[] vals = (Enum[])c.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                String[] names = new String[vals.length];
                for (int i = 0; i < vals.length; ++i) {
                    names[i] = vals[i].name();
                }
                return names;
            }
            catch (Exception x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(File buildFile, List<String> targets, InputStream in, OutputWriter out, OutputWriter err, Map<String, String> properties, int verbosity, String displayName, Runnable interestingOutputCallback, ProgressHandle handle) {
        if (!classpathInitialized) {
            classpathInitialized = true;
            Path.systemClasspath = new Path(null, AntBridge.getMainClassPath());
        }
        boolean ok = false;
        final boolean ant16 = this.isAnt16();
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        ClassLoader newCCL = Project.class.getClassLoader();
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("Fixing CCL: " + oldCCL + " -> " + newCCL);
        }
        Thread.currentThread().setContextClassLoader(newCCL);
        AntBridge.fakeJavaClassPath();
        try {
            Object c;
            Vector<String> targs;
            Project project;
            final NbBuildLogger logger = new NbBuildLogger(buildFile, out, err, verbosity, displayName, interestingOutputCallback, handle);
            try {
                project = new Project();
                project.addBuildListener((BuildListener)logger);
                project.init();
                project.addTaskDefinition("java", ForkedJavaOverride.class);
                try {
                    BridgeImpl.addCustomDefs(project);
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
                project.setUserProperty("ant.file", buildFile.getAbsolutePath());
                project.setUserProperty("ant.version", Main.getAntVersion());
                File antHome = AntSettings.getAntHome();
                if (antHome != null) {
                    project.setUserProperty("ant.home", antHome.getAbsolutePath());
                }
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    project.setUserProperty(entry.getKey(), entry.getValue());
                }
                if (in != null && ant16) {
                    try {
                        Method m = Project.class.getMethod("setDefaultInputStream", InputStream.class);
                        m.invoke((Object)project, in);
                    }
                    catch (Exception e) {
                        AntModule.err.notify(1, (Throwable)e);
                    }
                }
                if (AntModule.err.isLoggable(1)) {
                    AntModule.err.log("CCL when configureProject is called: " + Thread.currentThread().getContextClassLoader());
                }
                ProjectHelper projhelper = ProjectHelper.getProjectHelper();
                project.addReference("ant.projectHelper", (Object)projhelper);
                projhelper.parse(project, (Object)buildFile);
                project.setInputHandler((InputHandler)new NbInputHandler(interestingOutputCallback));
                if (targets != null) {
                    targs = new Vector<String>(targets);
                } else {
                    targs = new Vector(1);
                    targs.add(project.getDefaultTarget());
                }
                logger.setActualTargets(targets != null ? targets.toArray(new String[targets.size()]) : null);
            }
            catch (BuildException be) {
                logger.buildInitializationFailed(be);
                logger.shutdown();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        AntModule.err.notify((Throwable)e);
                    }
                }
                boolean e = false;
                AntBridge.unfakeJavaClassPath();
                if (AntModule.err.isLoggable(1)) {
                    AntModule.err.log("Restoring CCL: " + oldCCL);
                }
                Thread.currentThread().setContextClassLoader(oldCCL);
                return e;
            }
            project.fireBuildStarted();
            InputStream is = System.in;
            if (in != null && ant16) {
                try {
                    Class<InputStream> dis = Class.forName("org.apache.tools.ant.DemuxInputStream").asSubclass(InputStream.class);
                    c = dis.getConstructor(Project.class);
                    is = ((Constructor)c).newInstance(project);
                }
                catch (Exception e) {
                    AntModule.err.notify(1, (Throwable)e);
                }
            }
            AntBridge.pushSystemInOutErr((InputStream)is, (PrintStream)new PrintStream((OutputStream)new DemuxOutputStream(project, false)), (PrintStream)new PrintStream((OutputStream)new DemuxOutputStream(project, true)));
            Thread currentThread = Thread.currentThread();
            c = loggersByThread;
            synchronized (c) {
                assert (!loggersByThread.containsKey(currentThread));
                loggersByThread.put(currentThread, logger);
            }
            try {
                project.executeTargets(targs);
                project.fireBuildFinished(null);
                ok = true;
            }
            catch (Throwable t) {
                project.fireBuildFinished(t);
            }
            finally {
                AntBridge.restoreSystemInOutErr();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        AntModule.err.notify((Throwable)e);
                    }
                }
                Map<Thread, NbBuildLogger> e = loggersByThread;
                synchronized (e) {
                    loggersByThread.remove(currentThread);
                }
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    IntrospectedInfo custom = AntSettings.getCustomDefs();
                    HashMap<String, Map> defs = new HashMap<String, Map>();
                    try {
                        defs.put("task", NbCollections.checkedMapByCopy((Map)project.getTaskDefinitions(), String.class, Class.class, (boolean)true));
                        defs.put("type", NbCollections.checkedMapByCopy((Map)project.getDataTypeDefinitions(), String.class, Class.class, (boolean)true));
                    }
                    catch (ThreadDeath threadDeath) {
                        // empty catch block
                    }
                    custom.scanProject(defs);
                    AntSettings.setCustomDefs((IntrospectedInfo)custom);
                    logger.shutdown();
                    refreshFilesystemsTask.schedule(0);
                    BridgeImpl.gutProject(project);
                    if (!ant16) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                BridgeImpl.hack36393();
                            }
                        });
                    }
                }
            });
        }
        finally {
            AntBridge.unfakeJavaClassPath();
            if (AntModule.err.isLoggable(1)) {
                AntModule.err.log("Restoring CCL: " + oldCCL);
            }
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final Thread process) {
        NbBuildLogger logger;
        Map<Thread, NbBuildLogger> map = loggersByThread;
        synchronized (map) {
            logger = loggersByThread.get(process);
        }
        if (logger != null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(BridgeImpl.class, (String)"MSG_stopping", (Object)logger.getDisplayNameNoLock()));
            logger.stop();
            process.interrupt();
            RequestProcessor.getDefault().create(new Runnable(){

                public void run() {
                    BridgeImpl.this.forciblyStop(process);
                }
            }).schedule(3000);
        } else {
            this.forciblyStop(process);
        }
    }

    private void forciblyStop(Thread process) {
        if (process.isAlive()) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(BridgeImpl.class, (String)"MSG_halting"));
            BridgeImpl.stopThread(process);
        }
    }

    private static void stopThread(Thread process) {
        process.stop();
    }

    private static void addCustomDefs(Project project) throws BuildException, IOException {
        long start = System.currentTimeMillis();
        if (AntBridge.getInterface().isAnt16()) {
            Map antlibLoaders = AntBridge.getCustomDefClassLoaders();
            for (Map.Entry entry : antlibLoaders.entrySet()) {
                String resource;
                String cnb = (String)entry.getKey();
                ClassLoader l = (ClassLoader)entry.getValue();
                URL antlib = l.getResource(resource = cnb.replace('.', '/') + "/antlib.xml");
                if (antlib == null) {
                    throw new IOException("Could not find " + antlib + " in ant/nblib/" + cnb.replace('.', '-') + ".jar");
                }
                NbAntlib.process(project, antlib, null, l);
                String antlibUri = "antlib:" + cnb;
                NbAntlib.process(project, antlib, antlibUri, l);
            }
        } else {
            Map customDefs = AntBridge.getCustomDefsNoNamespace();
            for (Map.Entry entry : ((Map)customDefs.get("task")).entrySet()) {
                project.addTaskDefinition((String)entry.getKey(), (Class)entry.getValue());
            }
            for (Map.Entry entry : ((Map)customDefs.get("type")).entrySet()) {
                project.addDataTypeDefinition((String)entry.getKey(), (Class)entry.getValue());
            }
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("addCustomDefs took " + (System.currentTimeMillis() - start) + "msec");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void hack36393() {
        if (!doHack36393) {
            return;
        }
        try {
            Class<?> shutdownC = Class.forName("java.lang.Shutdown");
            Class<?> wrappedHookC = Class.forName("java.lang.Shutdown$WrappedHook");
            Field hooksF = shutdownC.getDeclaredField("hooks");
            hooksF.setAccessible(true);
            Field hookF = wrappedHookC.getDeclaredField("hook");
            hookF.setAccessible(true);
            Field lockF = shutdownC.getDeclaredField("lock");
            lockF.setAccessible(true);
            Object lock = lockF.get(null);
            HashSet<Thread> toRemove = new HashSet<Thread>();
            Object object = lock;
            synchronized (object) {
                Set hooks = (Set)hooksF.get(null);
                for (Object wrappedHook : hooks) {
                    Thread hook = (Thread)hookF.get(wrappedHook);
                    if (!hook.getClass().getName().equals("org.apache.tools.ant.taskdefs.ProcessDestroyer")) continue;
                    toRemove.add(hook);
                }
            }
            for (Thread hook : toRemove) {
                if (!Runtime.getRuntime().removeShutdownHook(hook)) {
                    throw new IllegalStateException("Hook was not really registered!");
                }
                AntModule.err.log("#36393: removing an unwanted ProcessDestroyer shutdown hook");
                hook.start();
            }
        }
        catch (Exception e) {
            AntModule.err.notify(1, (Throwable)e);
            doHack36393 = false;
        }
    }

    private static void gutProject(Project p) {
        if (!doGutProject) {
            return;
        }
        try {
            Field helpersF;
            String s = p.getName();
            AntModule.err.log("Gutting extra references in project \"" + s + "\"");
            Field[] fs = Project.class.getDeclaredFields();
            for (int i = 0; i < fs.length; ++i) {
                if (Modifier.isStatic(fs[i].getModifiers()) || fs[i].getType().isPrimitive()) continue;
                fs[i].setAccessible(true);
                Object o = fs[i].get(p);
                try {
                    if (o instanceof Collection) {
                        ((Collection)o).clear();
                        continue;
                    }
                    if (o instanceof Map) {
                        ((Map)o).clear();
                        continue;
                    }
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                if (Modifier.isFinal(fs[i].getModifiers())) continue;
                fs[i].set(p, null);
            }
            try {
                helpersF = IntrospectionHelper.class.getDeclaredField("helpers");
            }
            catch (NoSuchFieldException x) {
                helpersF = IntrospectionHelper.class.getDeclaredField("HELPERS");
            }
            helpersF.setAccessible(true);
            Object helpersO = helpersF.get(null);
            Map helpersM = (Map)helpersO;
            helpersM.clear();
            Introspector.flushCaches();
        }
        catch (Exception e) {
            AntModule.err.notify(1, (Throwable)e);
            doGutProject = false;
        }
    }
}

