/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.ssl.SSLSelectorThread;
import com.sun.grizzly.util.ByteBufferInputStream;
import com.sun.grizzly.util.SSLUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class SSLAsyncStream
extends ByteBufferInputStream {
    private SSLEngine sslEngine;
    private ByteBuffer inputBB;

    public SSLAsyncStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    protected int doRead() {
        int initialPosition = this.byteBuffer.position();
        int byteRead = 0;
        while (this.byteBuffer.position() == initialPosition) {
            int count = SSLUtils.doRead((SocketChannel)this.key.channel(), this.inputBB, this.sslEngine, this.readTimeout);
            if (count > 0) {
                byteRead += count;
                try {
                    this.byteBuffer = SSLUtils.unwrapAll(this.byteBuffer, this.inputBB, this.sslEngine);
                    continue;
                }
                catch (IOException ex) {
                    Logger logger = SSLSelectorThread.logger();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "SSLUtils.unwrapAll", ex);
                    }
                    return -1;
                }
            }
            if (count != -1 || byteRead != 0) break;
            byteRead = -1;
            break;
        }
        this.byteBuffer.flip();
        return byteRead;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public void setSslEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public ByteBuffer getInputBB() {
        return this.inputBB;
    }

    public void setInputBB(ByteBuffer inputBB) {
        this.inputBB = inputBB;
    }
}

