/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.anttasks.cli;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.project.CommandlineBpelProjectXmlCatalogProvider;
import org.netbeans.modules.bpel.project.anttasks.cli.CliBpelCatalogModel;
import org.netbeans.modules.bpel.project.anttasks.util.Util;
import org.netbeans.modules.soa.validation.core.Controller;
import org.netbeans.modules.xml.xam.Model;

public class CliValidateBpelProjectDelegate
extends Task {
    private String mSourceDirectory;
    private String mProjectClassPath;
    private String mBuildDirectory;
    private String mBuildDependentProjectFilesDirectory;
    private File mSourceDir;
    private File mBuildDir;
    private Map myFileNamesToFileInBuildDir = new HashMap();
    private boolean myIsFoundErrors = false;
    private boolean myAllowBuildWithError = false;

    public void setSourceDirectory(String srcDir) {
        this.mSourceDirectory = srcDir;
    }

    public void setBuildDirectory(String buildDir) {
        this.mBuildDirectory = buildDir;
    }

    public void setRunValidation(String flag) {
        this.setAllowBuildWithError(flag);
        this.myAllowBuildWithError = !this.myAllowBuildWithError;
    }

    public void setAllowBuildWithError(String flag) {
        if (flag != null) {
            if (flag.equals("false")) {
                this.myAllowBuildWithError = false;
            } else if (flag.equals("true")) {
                this.myAllowBuildWithError = true;
            }
        }
    }

    public void setClasspathRef(Reference ref) {
    }

    public void setProjectClassPath(String projectClassPath) {
        this.mProjectClassPath = projectClassPath;
    }

    public void setBuildDependentProjectDir(String dependentProjectFilesDir) {
        this.mBuildDependentProjectFilesDirectory = dependentProjectFilesDir;
    }

    public boolean isFoundErrors() {
        return this.myIsFoundErrors;
    }

    public void execute() throws BuildException {
        if (this.mSourceDirectory == null) {
            throw new BuildException("No directory is set for source files.");
        }
        if (this.mBuildDirectory == null) {
            throw new BuildException("No build directory is set.");
        }
        if (this.mBuildDependentProjectFilesDirectory == null) {
            throw new BuildException("No dependentProjectFiles directory is set.");
        }
        try {
            this.mSourceDir = new File(this.mSourceDirectory);
            CommandlineBpelProjectXmlCatalogProvider.getInstance().setSourceDirectory(this.mSourceDirectory);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to get File object for project source directory " + this.mSourceDirectory, (Throwable)ex);
        }
        try {
            this.mBuildDir = new File(this.mBuildDirectory);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to get File object for project build directory " + this.mBuildDirectory, (Throwable)ex);
        }
        this.processBuildDir(this.mBuildDir);
        this.processSourceDir(this.mSourceDir);
    }

    private void processBuildDir(File folder) {
        File[] files = folder.listFiles(new Util.BpelFileFilter());
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isFile()) {
                this.myFileNamesToFileInBuildDir.put(Util.getRelativePath(this.mBuildDir, file), file);
                continue;
            }
            this.processBuildDir(file);
        }
    }

    private void validateFile(File file) throws BuildException {
        try {
            BpelModel model = CliBpelCatalogModel.getDefault().getBPELModel(file.toURI());
            if (new Controller((Model)model).cliValidate(file)) {
                this.myIsFoundErrors = true;
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private boolean isModified(File file) {
        boolean modified = true;
        String relativePath = Util.getRelativePath(this.mSourceDir, file);
        File fileInBuildDir = (File)this.myFileNamesToFileInBuildDir.get(relativePath);
        if (fileInBuildDir != null && fileInBuildDir.lastModified() == file.lastModified()) {
            modified = false;
        }
        return modified;
    }

    private void processSourceDir(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles(new Util.BpelFileFilter());
            if (children == null) {
                return;
            }
            for (int i = 0; i < children.length; ++i) {
                this.processSourceDir(children[i]);
            }
        } else if (this.isModified(file)) {
            this.validateFile(file);
        }
    }
}

