/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.netbeans.modules.search.FindInFilesAction;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Mutex;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

final class FindActionManager
implements PropertyChangeListener,
Runnable {
    private static final Logger LOG = Logger.getLogger(FindActionManager.class.getName());
    private static final String MAPPED_FIND_ACTION = FindActionManager.class.getName() + " - FindActionImpl";
    private static FindActionManager instance;
    private final FindInFilesAction findAction;
    private final Set<TopComponent> activatedOnWindows = new WeakSet(8);
    private Object findActionMapKey;

    private FindActionManager() {
        this.findAction = (FindInFilesAction)SharedClassObject.findObject(FindInFilesAction.class, (boolean)true);
    }

    static FindActionManager getInstance() {
        LOG.finer("getInstance()");
        if (instance == null) {
            instance = new FindActionManager();
        }
        return instance;
    }

    void init() {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        Mutex.EVENT.writeAccess((Runnable)this);
    }

    void cleanup() {
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Object>(){

            public Object run() {
                FindActionManager.this.cleanupWindowRegistry();
                return null;
            }
        });
    }

    public void run() {
        this.someoneActivated();
    }

    private void cleanupWindowRegistry() {
        Object object = this.getFindActionMapKey();
        for (TopComponent topComponent : this.activatedOnWindows) {
            Object t;
            Action action = null;
            Action action2 = null;
            Object object2 = topComponent.getClientProperty((Object)MAPPED_FIND_ACTION);
            if (object2 instanceof Reference && (t = ((Reference)object2).get()) instanceof Action) {
                action = (Action)t;
            }
            if (action != null) {
                action2 = topComponent.getActionMap().get(object);
            }
            if (action2 != null && action2 == action) {
                topComponent.getActionMap().put(object, null);
            } else {
                ErrorManager.getDefault().log(16, "ActionMap mapping of FindAction changed for window " + topComponent.getName());
            }
            if (object2 == null) continue;
            topComponent.putClientProperty((Object)MAPPED_FIND_ACTION, null);
        }
        this.activatedOnWindows.clear();
    }

    private void someoneActivated() {
        Object object;
        Object object2;
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (LOG.isLoggable(Level.FINER)) {
            if (topComponent == null) {
                object2 = "<null>";
            } else {
                object = topComponent.getDisplayName();
                if (object == null) {
                    object = topComponent.getHtmlDisplayName();
                }
                if (object == null) {
                    object = topComponent.getName();
                }
                object = object != null ? '\"' + (String)object + '\"' : "<noname>";
                object2 = (String)object + '(' + topComponent.getClass().getName() + ')';
            }
            LOG.finer("someoneActivated (" + (String)object2 + ')');
        }
        if (topComponent == null || topComponent instanceof CloneableEditorSupport.Pane) {
            return;
        }
        object2 = this.getFindActionMapKey();
        object = topComponent.getActionMap();
        if (((ActionMap)object).get(object2) == null && this.activatedOnWindows.add(topComponent)) {
            Action action = this.findAction.createContextAwareInstance(topComponent.getLookup(), true);
            ((ActionMap)object).put(object2, action);
            topComponent.putClientProperty((Object)MAPPED_FIND_ACTION, new WeakReference<Action>(action));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            this.someoneActivated();
        }
    }

    private Object getFindActionMapKey() {
        if (this.findActionMapKey == null) {
            FindAction findAction = (FindAction)SharedClassObject.findObject(FindAction.class, (boolean)true);
            assert (findAction != null);
            this.findActionMapKey = findAction.getActionMapKey();
        }
        return this.findActionMapKey;
    }
}

