/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.search.LineReader;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.TextDetail;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

final class MatchingObject
implements PropertyChangeListener {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());
    private final ResultModel resultModel;
    private final File file;
    private final long timestamp;
    final Object object;
    private final Charset charset;
    private boolean selected = true;
    private boolean expanded = false;
    private boolean[] matchesSelection;
    private int selectedMatchesCount;
    private boolean childrenSelectionDirty;
    private boolean valid = true;
    private StringBuilder text;
    LineReader.LineSeparator[] lineSeparators;
    private static final boolean REALLY_WRITE = true;

    MatchingObject(ResultModel resultModel, Object object, Charset charset) {
        if (resultModel == null) {
            throw new IllegalArgumentException("resultModel = null");
        }
        if (object == null) {
            throw new IllegalArgumentException("object = null");
        }
        this.resultModel = resultModel;
        this.object = object;
        this.charset = charset;
        FileObject fileObject = this.getFileObject();
        this.file = FileUtil.toFile((FileObject)fileObject);
        this.timestamp = this.file != null ? this.file.lastModified() : 0L;
        this.valid = this.timestamp != 0L;
        this.setUpDataObjValidityChecking();
    }

    private void setUpDataObjValidityChecking() {
        DataObject dataObject = (DataObject)this.object;
        if (dataObject.isValid()) {
            dataObject.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    void cleanup() {
        DataObject dataObject = (DataObject)this.object;
        dataObject.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("valid".equals(propertyChangeEvent.getPropertyName()) && Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
            assert (propertyChangeEvent.getSource() == (DataObject)this.object);
            DataObject dataObject = (DataObject)this.object;
            dataObject.removePropertyChangeListener((PropertyChangeListener)this);
            this.resultModel.objectBecameInvalid(this);
        }
    }

    boolean isObjectValid() {
        return ((DataObject)this.object).isValid();
    }

    private FileObject getFileObject() {
        return ((DataObject)this.object).getPrimaryFile();
    }

    void setSelected(boolean bl) {
        if (bl == this.selected) {
            return;
        }
        this.selected = bl;
        this.matchesSelection = null;
    }

    boolean isSelected() {
        return this.selected;
    }

    boolean isUniformSelection() {
        return this.matchesSelection == null;
    }

    Boolean checkSubnodesSelection() {
        if (this.matchesSelection == null) {
            return this.selected;
        }
        boolean bl = this.matchesSelection[0];
        for (int i = 1; i < this.matchesSelection.length; ++i) {
            if (this.matchesSelection[i] == bl) continue;
            return null;
        }
        return bl;
    }

    boolean toggleSubnodeSelection(ResultModel resultModel, int n) {
        if (this.matchesSelection == null) {
            int n2 = resultModel.getDetailsCount(this);
            if (n2 == 1) {
                this.selected = !this.selected;
                return true;
            }
            this.matchesSelection = new boolean[n2];
            Arrays.fill(this.matchesSelection, this.selected);
            this.matchesSelection[n] = !this.selected;
            boolean bl = this.selected;
            this.selectedMatchesCount = bl ? n2 - 1 : 1;
            this.selected = true;
            return this.selected != bl;
        }
        assert (this.selected);
        assert (this.selectedMatchesCount > 0 && this.selectedMatchesCount < this.matchesSelection.length);
        boolean bl = this.matchesSelection[n];
        if (bl) {
            if (--this.selectedMatchesCount == 0) {
                this.matchesSelection = null;
                this.selected = false;
                return true;
            }
        } else if (++this.selectedMatchesCount == this.matchesSelection.length) {
            this.matchesSelection = null;
            return false;
        }
        this.matchesSelection[n] = !bl;
        return false;
    }

    boolean isSubnodeSelected(int n) {
        assert (this.matchesSelection == null || n >= 0 && n < this.matchesSelection.length);
        return this.matchesSelection == null ? this.selected : this.matchesSelection[n];
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == MatchingObject.class && ((MatchingObject)object).object == this.object;
    }

    public int hashCode() {
        return this.object.hashCode() + 1;
    }

    void markChildrenSelectionDirty() {
        this.childrenSelectionDirty = true;
    }

    void markChildrenSelectionClean() {
        this.childrenSelectionDirty = false;
    }

    boolean isChildrenSelectionDirty() {
        return this.childrenSelectionDirty;
    }

    void markExpanded(boolean bl) {
        this.expanded = bl;
    }

    boolean isExpanded() {
        return this.expanded;
    }

    File getFile() {
        return this.file;
    }

    String getName() {
        return this.getFile().getName();
    }

    long getTimestamp() {
        return this.timestamp;
    }

    String getDescription() {
        return this.getFile().getParent();
    }

    String getText() throws IOException {
        StringBuilder stringBuilder = this.text();
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        return null;
    }

    FileLock lock() throws IOException {
        return this.getFileObject().lock();
    }

    private StringBuilder text() throws IOException {
        return this.text(false);
    }

    private StringBuilder text(boolean bl) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (bl || this.text == null) {
            this.text = this.readText();
        }
        return this.text == null ? new StringBuilder() : this.text;
    }

    private StringBuilder readText() throws IOException {
        StringBuilder stringBuilder = null;
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (byteBuffer != null) {
            CharBuffer charBuffer = this.decodeByteBuffer(byteBuffer, this.charset);
            LineReader lineReader = new LineReader(charBuffer);
            stringBuilder = lineReader.readText();
            this.lineSeparators = lineReader.getLineSeparators();
            lineReader.clear();
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getByteBuffer() throws IOException {
        assert (!EventQueue.isDispatchThread());
        File file = this.getFile();
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)file.length());
        FileChannel fileChannel = fileInputStream.getChannel();
        try {
            fileChannel.read(byteBuffer, 0L);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            ByteBuffer byteBuffer2 = null;
            return byteBuffer2;
        }
        finally {
            fileChannel.close();
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    InvalidityStatus checkValidity() {
        InvalidityStatus invalidityStatus = this.getInvalidityStatus();
        if (invalidityStatus != null) {
            this.valid = false;
        }
        return invalidityStatus;
    }

    String getInvalidityDescription() {
        InvalidityStatus invalidityStatus = this.getInvalidityStatus();
        String string = invalidityStatus != null ? invalidityStatus.getDescription(this.getFile().getPath()) : null;
        return string;
    }

    private InvalidityStatus getInvalidityStatus() {
        this.log(Level.FINER, "getInvalidityStatus()");
        File file = this.getFile();
        if (!file.exists()) {
            this.log(Level.FINEST, " - DELETED");
            return InvalidityStatus.DELETED;
        }
        if (file.isDirectory()) {
            this.log(Level.FINEST, " - BECAME_DIR");
            return InvalidityStatus.BECAME_DIR;
        }
        long l = file.lastModified();
        if (l > this.resultModel.getCreationTime()) {
            this.log(Level.SEVERE, "file's timestamp changed since start of the search");
            if (this.LOG.isLoggable(Level.FINEST)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l);
                this.log(Level.FINEST, " - file stamp:           " + l + " (" + calendar.getTime() + ')');
                calendar.setTimeInMillis(this.resultModel.getCreationTime());
                this.log(Level.FINEST, " - result model created: " + this.resultModel.getCreationTime() + " (" + calendar.getTime() + ')');
            }
            return InvalidityStatus.CHANGED;
        }
        if (file.length() > Integer.MAX_VALUE) {
            return InvalidityStatus.TOO_BIG;
        }
        if (!file.canRead()) {
            return InvalidityStatus.CANT_READ;
        }
        return null;
    }

    boolean isValid() {
        return this.valid;
    }

    public InvalidityStatus replace() throws IOException {
        boolean bl;
        assert (!EventQueue.isDispatchThread());
        assert (this.isSelected());
        Boolean bl2 = this.checkSubnodesSelection();
        boolean bl3 = bl = bl2 == Boolean.FALSE;
        if (bl) {
            return null;
        }
        StringBuilder stringBuilder = this.text(true);
        List<TextDetail> list = this.resultModel.basicCriteria.getTextDetails(this.object);
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        block0: for (TextDetail textDetail : list) {
            int n6;
            int n7;
            int n8;
            int n9 = textDetail.getLine();
            while (n3 < n9) {
                n8 = stringBuilder.indexOf("\n", n2);
                if (n8 == -1) {
                    assert (false);
                    break block0;
                }
                n2 = n8 + 1;
                ++n3;
                n4 = 0;
                n5 = 0;
            }
            if (!this.isSubnodeSelected(n++)) continue;
            if (++n4 == 1) {
                n8 = 0;
                if (!$assertionsDisabled) {
                    n8 = 1;
                    if (1 == 0) {
                        throw new AssertionError();
                    }
                }
                if (n8 != 0) {
                    String string;
                    n7 = stringBuilder.indexOf("\n", n2);
                    String string2 = string = n7 != -1 ? stringBuilder.substring(n2, n7) : stringBuilder.substring(n2);
                    if (!string.equals(textDetail.getLineText())) {
                        this.log(Level.SEVERE, "file line differs from the expected line");
                        if (this.LOG.isLoggable(Level.FINEST)) {
                            this.log(Level.SEVERE, " - expected line: \"" + textDetail.getLineText() + '\"');
                            this.log(Level.SEVERE, " - file line:     \"" + string + '\"');
                        }
                        return InvalidityStatus.CHANGED;
                    }
                }
            }
            n8 = textDetail.getMarkLength();
            n7 = n2 + n5 + (textDetail.getColumn() - 1);
            if (!stringBuilder.substring(n7, n6 = n7 + n8).equals(textDetail.getLineText().substring(textDetail.getColumn() - 1, textDetail.getColumn() - 1 + n8))) {
                this.log(Level.SEVERE, "file match part differs from the expected match");
                if (this.LOG.isLoggable(Level.FINEST)) {
                    this.log(Level.SEVERE, " - expected line: \"" + textDetail.getLineText().substring(textDetail.getColumn() - 1, textDetail.getColumn() - 1 + n8) + '\"');
                    this.log(Level.SEVERE, " - file line:     \"" + stringBuilder.substring(n7, n6) + '\"');
                }
                return InvalidityStatus.CHANGED;
            }
            stringBuilder.replace(n7, n6, this.resultModel.replaceString);
            n5 += this.resultModel.replaceString.length() - n8;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(FileLock fileLock) throws IOException {
        if (this.text == null) {
            throw new IllegalStateException("Buffer is gone");
        }
        FileObject fileObject = this.getFileObject();
        Writer writer = null;
        try {
            writer = new OutputStreamWriter(fileObject.getOutputStream(fileLock), this.charset);
            writer.write(this.makeStringToWrite());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String makeStringToWrite() {
        return MatchingObject.makeStringToWrite(this.text, this.lineSeparators);
    }

    static String makeStringToWrite(StringBuilder stringBuilder, LineReader.LineSeparator[] lineSeparatorArray) {
        int n;
        if (lineSeparatorArray == null || lineSeparatorArray.length == 0) {
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.length() + lineSeparatorArray.length);
        int n2 = 0;
        int n3 = 0;
        while ((n = stringBuilder.indexOf("\n", n2)) != -1) {
            stringBuilder2.append(stringBuilder.substring(n2, n));
            stringBuilder2.append(lineSeparatorArray[n3++].getString());
            n2 = n + 1;
        }
        if (n2 != stringBuilder.length()) {
            stringBuilder2.append(stringBuilder.substring(n2));
        }
        return stringBuilder2.toString();
    }

    private CharBuffer decodeByteBuffer(ByteBuffer byteBuffer, Charset charset) throws CharacterCodingException {
        CharsetDecoder charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        int n = byteBuffer.remaining();
        if (n == 0) {
            return CharBuffer.allocate(0);
        }
        int n2 = (int)((float)n * charsetDecoder.averageCharsPerByte());
        if (n2 < 16) {
            n2 = 16;
        }
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        charsetDecoder.reset();
        while (true) {
            CoderResult coderResult;
            CoderResult coderResult2 = coderResult = byteBuffer.hasRemaining() ? charsetDecoder.decode(byteBuffer, charBuffer, true) : CoderResult.UNDERFLOW;
            if (coderResult.isUnderflow()) {
                coderResult = charsetDecoder.flush(charBuffer);
            }
            if (coderResult.isUnderflow()) break;
            if (coderResult.isOverflow()) {
                CharBuffer charBuffer2 = CharBuffer.allocate(n2 <<= 1);
                charBuffer.flip();
                charBuffer2.put(charBuffer);
                charBuffer = charBuffer2;
                continue;
            }
            coderResult.throwException();
        }
        charBuffer.flip();
        return charBuffer;
    }

    private void log(Level level, String string) {
        String string2;
        String string3 = string2 = this.object instanceof DataObject ? ((DataObject)this.object).getName() : this.object.toString();
        if (this.LOG.isLoggable(level)) {
            this.LOG.log(level, string2 + ": " + string);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InvalidityStatus {
        DELETED(true, "Inv_status_Err_deleted"),
        BECAME_DIR(true, "Inv_status_Err_became_dir"),
        CHANGED(false, "Inv_status_Err_changed"),
        TOO_BIG(false, "Inv_status_Err_too_big"),
        CANT_READ(false, "Inv_status_Err_cannot_read");

        private final boolean fatal;
        private final String descrBundleKey;

        private InvalidityStatus(boolean bl, String string2) {
            this.fatal = bl;
            this.descrBundleKey = string2;
        }

        boolean isFatal() {
            return this.fatal;
        }

        String getDescription(String string) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.descrBundleKey, (Object)string);
        }
    }
}

